/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.nio.client;

import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.client.HttpAsyncRequestProducer;
import org.apache.http.nio.entity.NHttpEntityWrapper;
import org.apache.http.nio.entity.ProducingNHttpEntity;

public class BasicHttpAsyncRequestProducer
implements HttpAsyncRequestProducer {
    private final HttpHost target;
    private final HttpRequest request;
    private volatile ProducingNHttpEntity contentProducingEntity;

    public BasicHttpAsyncRequestProducer(HttpHost target, HttpRequest request) {
        if (target == null) {
            throw new IllegalArgumentException("Target host may not be null");
        }
        if (request == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        this.target = target;
        this.request = request;
    }

    public HttpRequest generateRequest() {
        return this.request;
    }

    public HttpHost getTarget() {
        return this.target;
    }

    protected ProducingNHttpEntity createProducingHttpEntity(HttpRequest request) throws IOException {
        HttpEntity entity = null;
        if (request instanceof HttpEntityEnclosingRequest) {
            entity = ((HttpEntityEnclosingRequest)request).getEntity();
        }
        if (entity != null) {
            if (entity instanceof ProducingNHttpEntity) {
                return (ProducingNHttpEntity)entity;
            }
            return new NHttpEntityWrapper(entity);
        }
        return null;
    }

    private ProducingNHttpEntity getProducingHttpEntity() throws IOException {
        if (this.contentProducingEntity == null) {
            this.contentProducingEntity = this.createProducingHttpEntity(this.request);
            if (this.contentProducingEntity == null) {
                throw new IllegalStateException("Content producer is null");
            }
        }
        return this.contentProducingEntity;
    }

    public synchronized void produceContent(ContentEncoder encoder, IOControl ioctrl) throws IOException {
        ProducingNHttpEntity producer = this.getProducingHttpEntity();
        producer.produceContent(encoder, ioctrl);
    }

    public synchronized boolean isRepeatable() {
        if (this.request instanceof HttpEntityEnclosingRequest) {
            HttpEntity entity = ((HttpEntityEnclosingRequest)this.request).getEntity();
            if (entity != null) {
                return entity.isRepeatable();
            }
            return true;
        }
        return true;
    }

    public synchronized void resetRequest() {
        if (this.contentProducingEntity != null) {
            try {
                this.contentProducingEntity.finish();
                this.contentProducingEntity = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

