/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.nio.client;

import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.protocol.RequestDefaultHeaders;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.nio.client.AbstractHttpAsyncClient;
import org.apache.http.nio.conn.ClientConnectionManager;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.params.SyncBasicHttpParams;
import org.apache.http.protocol.BasicHttpProcessor;
import org.apache.http.protocol.RequestConnControl;
import org.apache.http.protocol.RequestContent;
import org.apache.http.protocol.RequestExpectContinue;
import org.apache.http.protocol.RequestTargetHost;
import org.apache.http.protocol.RequestUserAgent;
import org.apache.http.util.VersionInfo;

public class DefaultHttpAsyncClient
extends AbstractHttpAsyncClient {
    public DefaultHttpAsyncClient(ConnectingIOReactor ioReactor, ClientConnectionManager connmgr, HttpParams params) {
        super(ioReactor, connmgr, params);
    }

    public DefaultHttpAsyncClient(HttpParams params) throws IOReactorException {
        super(params);
    }

    public DefaultHttpAsyncClient() throws IOReactorException {
        this(null);
    }

    public DefaultHttpAsyncClient(ConnectingIOReactor ioReactor, ClientConnectionManager connmgr) throws IOReactorException {
        this(ioReactor, connmgr, null);
    }

    protected HttpParams createHttpParams() {
        SyncBasicHttpParams params = new SyncBasicHttpParams();
        DefaultHttpAsyncClient.setDefaultHttpParams((HttpParams)params);
        return params;
    }

    public static void setDefaultHttpParams(HttpParams params) {
        HttpProtocolParams.setVersion((HttpParams)params, (ProtocolVersion)HttpVersion.HTTP_1_1);
        HttpProtocolParams.setContentCharset((HttpParams)params, (String)"ISO-8859-1");
        HttpConnectionParams.setTcpNoDelay((HttpParams)params, (boolean)true);
        HttpConnectionParams.setSocketBufferSize((HttpParams)params, (int)8192);
        VersionInfo vi = VersionInfo.loadVersionInfo((String)"org.apache.http.nio.client", (ClassLoader)DefaultHttpClient.class.getClassLoader());
        String release = vi != null ? vi.getRelease() : "UNAVAILABLE";
        HttpProtocolParams.setUserAgent((HttpParams)params, (String)("Apache-HttpAsyncClient/" + release + " (java 1.5)"));
    }

    protected BasicHttpProcessor createHttpProcessor() {
        BasicHttpProcessor httpproc = new BasicHttpProcessor();
        httpproc.addInterceptor((HttpRequestInterceptor)new RequestDefaultHeaders());
        httpproc.addInterceptor((HttpRequestInterceptor)new RequestContent());
        httpproc.addInterceptor((HttpRequestInterceptor)new RequestTargetHost());
        httpproc.addInterceptor((HttpRequestInterceptor)new RequestConnControl());
        httpproc.addInterceptor((HttpRequestInterceptor)new RequestUserAgent());
        httpproc.addInterceptor((HttpRequestInterceptor)new RequestExpectContinue());
        return httpproc;
    }
}

