/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.nio.client;

import org.apache.http.impl.nio.client.HttpAsyncResponseSet;
import org.apache.http.nio.client.HttpAsyncResponseConsumer;
import org.apache.http.nio.concurrent.FutureCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ResponseCompletedCallback<T>
implements FutureCallback<T> {
    private final FutureCallback<T> callback;
    private final HttpAsyncResponseConsumer<T> responseConsumer;
    private final HttpAsyncResponseSet set;

    public ResponseCompletedCallback(FutureCallback<T> callback, HttpAsyncResponseConsumer<T> responseConsumer, HttpAsyncResponseSet set) {
        this.callback = callback;
        this.responseConsumer = responseConsumer;
        this.set = set;
    }

    @Override
    public void completed(T result) {
        this.set.remove(this.responseConsumer);
        if (this.callback != null) {
            this.callback.completed(result);
        }
    }

    @Override
    public void failed(Exception ex) {
        this.set.remove(this.responseConsumer);
        if (this.callback != null) {
            this.callback.failed(ex);
        }
    }

    @Override
    public void cancelled() {
        this.set.remove(this.responseConsumer);
        if (this.callback != null) {
            this.callback.cancelled();
        }
    }
}

