/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.nio.pool;

import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.http.impl.nio.pool.PoolEntry;
import org.apache.http.impl.nio.pool.PoolEntryCallback;
import org.apache.http.impl.nio.pool.PoolEntryFactory;
import org.apache.http.nio.reactor.IOSession;
import org.apache.http.nio.reactor.SessionRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RouteSpecificPool<T, E extends PoolEntry<T>> {
    private final T route;
    private final PoolEntryFactory<T, E> factory;
    private final Set<E> leasedSessions;
    private final LinkedList<E> availableSessions;
    private final Map<SessionRequest, PoolEntryCallback<T, E>> pendingSessions;

    public RouteSpecificPool(T route, PoolEntryFactory<T, E> factory) {
        this.route = route;
        this.factory = factory;
        this.leasedSessions = new HashSet();
        this.availableSessions = new LinkedList();
        this.pendingSessions = new HashMap<SessionRequest, PoolEntryCallback<T, E>>();
    }

    public int getLeasedCount() {
        return this.leasedSessions.size();
    }

    public int getPendingCount() {
        return this.pendingSessions.size();
    }

    public int getAvailableCount() {
        return this.availableSessions.size();
    }

    public int getAllocatedCount() {
        return this.availableSessions.size() + this.leasedSessions.size() + this.pendingSessions.size();
    }

    public E getFreeEntry(Object state) {
        if (!this.availableSessions.isEmpty()) {
            ListIterator<E> it = this.availableSessions.listIterator(this.availableSessions.size());
            while (it.hasPrevious()) {
                PoolEntry entry = (PoolEntry)it.previous();
                IOSession iosession = entry.getIOSession();
                if (iosession.isClosed() || entry.isExpired(System.currentTimeMillis())) {
                    it.remove();
                    continue;
                }
                if (entry.getState() != null && !entry.getState().equals(state)) continue;
                it.remove();
                this.leasedSessions.add(entry);
                return (E)entry;
            }
        }
        return null;
    }

    public E deleteLastUsed() {
        return (E)((PoolEntry)this.availableSessions.poll());
    }

    public boolean remove(E entry) {
        if (entry == null) {
            throw new IllegalArgumentException("Pool entry may not be null");
        }
        boolean foundLeased = this.leasedSessions.remove(entry);
        boolean foundFree = this.availableSessions.remove(entry);
        return foundLeased || foundFree;
    }

    public void freeEntry(E entry, boolean reusable) {
        if (entry == null) {
            throw new IllegalArgumentException("Pool entry may not be null");
        }
        boolean found = this.leasedSessions.remove(entry);
        if (!found) {
            throw new IllegalStateException("Entry " + entry + " has not been leased from this pool");
        }
        if (reusable) {
            this.availableSessions.add(entry);
        }
    }

    public void addPending(SessionRequest sessionRequest, PoolEntryCallback<T, E> callback) {
        this.pendingSessions.put(sessionRequest, callback);
    }

    private PoolEntryCallback<T, E> removeRequest(SessionRequest request) {
        PoolEntryCallback<T, E> callback = this.pendingSessions.remove(request);
        if (callback == null) {
            throw new IllegalStateException("Invalid session request");
        }
        return callback;
    }

    public E completed(SessionRequest request) {
        PoolEntryCallback<T, E> callback = this.removeRequest(request);
        IOSession iosession = request.getSession();
        E entry = this.factory.createEntry(this.route, iosession);
        this.leasedSessions.add(entry);
        callback.completed(entry);
        return entry;
    }

    public void cancelled(SessionRequest request) {
        PoolEntryCallback<T, E> callback = this.removeRequest(request);
        callback.cancelled();
    }

    public void failed(SessionRequest request) {
        PoolEntryCallback<T, E> callback = this.removeRequest(request);
        callback.failed(request.getException());
    }

    public void timeout(SessionRequest request) {
        PoolEntryCallback<T, E> callback = this.removeRequest(request);
        callback.failed(new SocketTimeoutException());
    }

    public void shutdown() {
        for (SessionRequest sessionRequest : this.pendingSessions.keySet()) {
            sessionRequest.cancel();
        }
        this.pendingSessions.clear();
        for (PoolEntry entry : this.availableSessions) {
            entry.getIOSession().close();
        }
        this.availableSessions.clear();
        for (PoolEntry entry : this.leasedSessions) {
            entry.getIOSession().close();
        }
        this.leasedSessions.clear();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[route: ");
        buffer.append(this.route);
        buffer.append("][leased: ");
        buffer.append(this.leasedSessions.size());
        buffer.append("][available: ");
        buffer.append(this.availableSessions.size());
        buffer.append("][pending: ");
        buffer.append(this.pendingSessions.size());
        buffer.append("]");
        return super.toString();
    }
}

