/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.nio.client;

import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.client.methods.AbstractHttpAsyncResponseConsumer;
import org.apache.http.nio.entity.BufferingNHttpEntity;
import org.apache.http.nio.entity.ConsumingNHttpEntity;
import org.apache.http.nio.util.ByteBufferAllocator;
import org.apache.http.nio.util.HeapByteBufferAllocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BasicHttpAsyncResponseConsumer
extends AbstractHttpAsyncResponseConsumer<HttpResponse> {
    private volatile HttpResponse response;
    private volatile ConsumingNHttpEntity consumer;

    @Override
    protected void onResponseReceived(HttpResponse response) {
        this.response = response;
        this.consumer = response.getEntity() != null ? new BufferingNHttpEntity(response.getEntity(), (ByteBufferAllocator)new HeapByteBufferAllocator()) : null;
        this.response.setEntity((HttpEntity)this.consumer);
    }

    @Override
    protected void onContentReceived(ContentDecoder decoder, IOControl ioctrl) throws IOException {
        this.consumer.consumeContent(decoder, ioctrl);
    }

    @Override
    protected void onCleanup() {
    }

    @Override
    protected HttpResponse buildResult() {
        return this.response;
    }
}

