/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.nio.client;

import java.util.Queue;
import org.apache.http.impl.nio.client.ResultCallback;
import org.apache.http.nio.client.HttpAsyncExchangeHandler;
import org.apache.http.nio.concurrent.BasicFuture;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultResultCallback<T>
implements ResultCallback<T> {
    private final BasicFuture<T> future;
    private final Queue<HttpAsyncExchangeHandler<?>> queue;

    DefaultResultCallback(BasicFuture<T> future, Queue<HttpAsyncExchangeHandler<?>> queue) {
        this.future = future;
        this.queue = queue;
    }

    @Override
    public void completed(T result, HttpAsyncExchangeHandler<T> handler) {
        this.future.completed(result);
        this.queue.remove(handler);
    }

    @Override
    public void failed(Exception ex, HttpAsyncExchangeHandler<T> handler) {
        this.future.failed(ex);
        this.queue.remove(handler);
    }

    @Override
    public void cancelled(HttpAsyncExchangeHandler<T> handler) {
        this.future.cancel(true);
        this.queue.remove(handler);
    }

    @Override
    public boolean isDone() {
        return this.future.isDone();
    }
}

