/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.nio.client;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.impl.nio.conn.DefaultClientAsyncConnection;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.NHttpClientConnection;
import org.apache.http.nio.protocol.HttpAsyncRequestExecutor;

class LoggingAsyncRequestExecutor
extends HttpAsyncRequestExecutor {
    private final Log headerlog = LogFactory.getLog((String)"org.apache.http.headers");
    private final Log log = LogFactory.getLog(HttpAsyncRequestExecutor.class);

    protected void log(Exception ex) {
        this.log.debug((Object)ex.getMessage(), (Throwable)ex);
    }

    public void connected(NHttpClientConnection conn, Object attachment) throws IOException, HttpException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(conn + ": Connected"));
        }
        super.connected(conn, attachment);
    }

    public void closed(NHttpClientConnection conn) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(conn + ": Disconnected"));
        }
        super.closed(conn);
    }

    public void exception(NHttpClientConnection conn, Exception ex) {
        if (this.log.isErrorEnabled()) {
            this.log.error((Object)(conn + " HTTP protocol exception: " + ex.getMessage()), (Throwable)ex);
        }
        super.exception(conn, ex);
    }

    public void requestReady(NHttpClientConnection conn) throws IOException, HttpException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(conn + " Request ready"));
        }
        super.requestReady(conn);
    }

    public void inputReady(NHttpClientConnection conn, ContentDecoder decoder) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(conn + " Input ready"));
        }
        super.inputReady(conn, decoder);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(conn + " " + decoder));
        }
    }

    public void outputReady(NHttpClientConnection conn, ContentEncoder encoder) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(conn + " Output ready"));
        }
        super.outputReady(conn, encoder);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(conn + " " + encoder));
        }
    }

    public void responseReceived(NHttpClientConnection conn) throws HttpException, IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(conn + " Response received"));
        }
        if (this.headerlog.isDebugEnabled()) {
            HttpResponse response = conn.getHttpResponse();
            String id = conn instanceof DefaultClientAsyncConnection ? ((DefaultClientAsyncConnection)conn).getId() : conn.toString();
            if (response != null && this.headerlog.isDebugEnabled()) {
                this.headerlog.debug((Object)(id + " << " + response.getStatusLine().toString()));
                Header[] headers = response.getAllHeaders();
                for (int i = 0; i < headers.length; ++i) {
                    this.headerlog.debug((Object)(id + " << " + headers[i].toString()));
                }
            }
        }
        super.responseReceived(conn);
    }

    public void timeout(NHttpClientConnection conn) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(conn + " Timeout"));
        }
        super.timeout(conn);
    }
}

