/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client.cache;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.http.annotation.ThreadSafe;
import org.apache.http.client.cache.HttpCache;
import org.apache.http.client.cache.HttpCacheOperationException;
import org.apache.http.client.cache.HttpCacheUpdateCallback;
import org.apache.http.impl.client.cache.CacheEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class BasicHttpCache
implements HttpCache<CacheEntry> {
    private final LinkedHashMap<String, CacheEntry> baseMap = new LinkedHashMap<String, CacheEntry>(20, 0.75f, true){
        private static final long serialVersionUID = -7750025207539768511L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, CacheEntry> eldest) {
            return this.size() > BasicHttpCache.this.maxEntries;
        }
    };
    private final Map<String, CacheEntry> syncMap;
    private final int maxEntries;

    public BasicHttpCache(int maxEntries) {
        this.maxEntries = maxEntries;
        this.syncMap = Collections.synchronizedMap(this.baseMap);
    }

    @Override
    public void putEntry(String url, CacheEntry entry) {
        this.syncMap.put(url, entry);
    }

    @Override
    public CacheEntry getEntry(String url) {
        return this.syncMap.get(url);
    }

    @Override
    public void removeEntry(String url) {
        this.syncMap.remove(url);
    }

    @Override
    public synchronized void updateCacheEntry(String url, HttpCacheUpdateCallback<CacheEntry> callback) throws HttpCacheOperationException {
        CacheEntry existingEntry = this.syncMap.get(url);
        CacheEntry updated = callback.getUpdatedEntry(existingEntry);
        this.syncMap.put(url, updated);
    }
}

