/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client.cache;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.annotation.Immutable;
import org.apache.http.impl.client.cache.CacheEntry;

@Immutable
public class CachedResponseSuitabilityChecker {
    private final Log log = LogFactory.getLog(this.getClass());

    public boolean canCachedResponseBeUsed(HttpHost host, HttpRequest request, CacheEntry entry) {
        if (!entry.isResponseFresh()) {
            this.log.debug((Object)"Cache entry was not fresh enough");
            return false;
        }
        if (!entry.contentLengthHeaderMatchesActualLength()) {
            this.log.debug((Object)"Cache entry Content-Length and header information do not match");
            return false;
        }
        if (entry.modifiedSince(request)) {
            this.log.debug((Object)"Cache entry modified times didn't line up. Cache Entry should not be used");
            return false;
        }
        for (Header ccHdr : request.getHeaders("Cache-Control")) {
            for (HeaderElement elt : ccHdr.getElements()) {
                if ("no-cache".equals(elt.getName())) {
                    this.log.debug((Object)"Response contained NO CACHE directive, cache was not suitable");
                    return false;
                }
                if ("no-store".equals(elt.getName())) {
                    this.log.debug((Object)"Response contained NO SORE directive, cache was not suitable");
                    return false;
                }
                if ("max-age".equals(elt.getName())) {
                    try {
                        int maxage = Integer.parseInt(elt.getValue());
                        if (entry.getCurrentAgeSecs() > (long)maxage) {
                            this.log.debug((Object)"Response from cache was NOT suitable due to max age");
                            return false;
                        }
                    }
                    catch (NumberFormatException ex) {
                        this.log.debug((Object)("Response from cache was malformed: " + ex.getMessage()));
                        return false;
                    }
                }
                if ("max-stale".equals(elt.getName())) {
                    try {
                        int maxstale = Integer.parseInt(elt.getValue());
                        if (entry.getFreshnessLifetimeSecs() > (long)maxstale) {
                            this.log.debug((Object)"Response from cache was not suitable due to Max stale freshness");
                            return false;
                        }
                    }
                    catch (NumberFormatException ex) {
                        this.log.debug((Object)("Response from cache was malformed: " + ex.getMessage()));
                        return false;
                    }
                }
                if (!"min-fresh".equals(elt.getName())) continue;
                try {
                    int minfresh = Integer.parseInt(elt.getValue());
                    if (entry.getFreshnessLifetimeSecs() >= (long)minfresh) continue;
                    this.log.debug((Object)"Response from cache was not suitable due to min fresh freshness requirement");
                    return false;
                }
                catch (NumberFormatException ex) {
                    this.log.debug((Object)("Response from cache was malformed: " + ex.getMessage()));
                    return false;
                }
            }
        }
        this.log.debug((Object)"Response from cache was suitable");
        return true;
    }
}

