/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.auth;

import java.io.IOException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.InvalidCredentialsException;
import org.apache.http.auth.MalformedChallengeException;
import org.apache.http.impl.auth.AuthSchemeBase;
import org.apache.http.impl.auth.SpnegoTokenGenerator;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.CharArrayBuffer;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class NegotiateScheme
extends AuthSchemeBase {
    private static final String SPNEGO_OID = "1.3.6.1.5.5.2";
    private static final String KERBEROS_OID = "1.2.840.113554.1.2.2";
    private final Log log = LogFactory.getLog(this.getClass());
    private final SpnegoTokenGenerator spengoGenerator;
    private final boolean stripPort;
    private GSSContext gssContext = null;
    private State state = State.UNINITIATED;
    private byte[] token;
    private Oid negotiationOid = null;

    public NegotiateScheme(SpnegoTokenGenerator spengoGenerator, boolean stripPort) {
        this.spengoGenerator = spengoGenerator;
        this.stripPort = stripPort;
    }

    public NegotiateScheme(SpnegoTokenGenerator spengoGenerator) {
        this(spengoGenerator, false);
    }

    public NegotiateScheme() {
        this(null, false);
    }

    public boolean isComplete() {
        return this.state == State.TOKEN_GENERATED || this.state == State.FAILED;
    }

    public String getSchemeName() {
        return "Negotiate";
    }

    @Deprecated
    public Header authenticate(Credentials credentials, HttpRequest request) throws AuthenticationException {
        return this.authenticate(credentials, request, null);
    }

    protected GSSManager getManager() {
        return GSSManager.getInstance();
    }

    public Header authenticate(Credentials credentials, HttpRequest request, HttpContext context) throws AuthenticationException {
        if (request == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        switch (this.state) {
            case UNINITIATED: {
                throw new AuthenticationException("SPNEGO authentication has not been initiated");
            }
            case FAILED: {
                throw new AuthenticationException("SPNEGO authentication has failed");
            }
            case CHALLENGE_RECEIVED: {
                try {
                    GSSName serverName;
                    GSSManager manager;
                    String key = null;
                    key = this.isProxy() ? "http.proxy_host" : "http.target_host";
                    HttpHost host = (HttpHost)context.getAttribute(key);
                    if (host == null) {
                        throw new AuthenticationException("Authentication host is not set in the execution context");
                    }
                    String authServer = !this.stripPort && host.getPort() > 0 ? host.toHostString() : host.getHostName();
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("init " + authServer));
                    }
                    this.negotiationOid = new Oid(SPNEGO_OID);
                    boolean tryKerberos = false;
                    try {
                        manager = this.getManager();
                        serverName = manager.createName("HTTP@" + authServer, GSSName.NT_HOSTBASED_SERVICE);
                        this.gssContext = manager.createContext(serverName.canonicalize(this.negotiationOid), this.negotiationOid, null, 0);
                        this.gssContext.requestMutualAuth(true);
                        this.gssContext.requestCredDeleg(true);
                    }
                    catch (GSSException ex) {
                        if (ex.getMajor() == 2) {
                            this.log.debug((Object)"GSSException BAD_MECH, retry with Kerberos MECH");
                            tryKerberos = true;
                        }
                        throw ex;
                    }
                    if (tryKerberos) {
                        this.log.debug((Object)"Using Kerberos MECH 1.2.840.113554.1.2.2");
                        this.negotiationOid = new Oid(KERBEROS_OID);
                        manager = this.getManager();
                        serverName = manager.createName("HTTP@" + authServer, GSSName.NT_HOSTBASED_SERVICE);
                        this.gssContext = manager.createContext(serverName.canonicalize(this.negotiationOid), this.negotiationOid, null, 0);
                        this.gssContext.requestMutualAuth(true);
                        this.gssContext.requestCredDeleg(true);
                    }
                    if (this.token == null) {
                        this.token = new byte[0];
                    }
                    this.token = this.gssContext.initSecContext(this.token, 0, this.token.length);
                    if (this.token == null) {
                        this.state = State.FAILED;
                        throw new AuthenticationException("GSS security context initialization failed");
                    }
                    if (this.spengoGenerator != null && this.negotiationOid.toString().equals(KERBEROS_OID)) {
                        this.token = this.spengoGenerator.generateSpnegoDERObject(this.token);
                    }
                    this.state = State.TOKEN_GENERATED;
                }
                catch (GSSException gsse) {
                    this.state = State.FAILED;
                    if (gsse.getMajor() == 9 || gsse.getMajor() == 8) {
                        throw new InvalidCredentialsException(gsse.getMessage(), gsse);
                    }
                    if (gsse.getMajor() == 13) {
                        throw new InvalidCredentialsException(gsse.getMessage(), gsse);
                    }
                    if (gsse.getMajor() == 10 || gsse.getMajor() == 19 || gsse.getMajor() == 20) {
                        throw new AuthenticationException(gsse.getMessage(), gsse);
                    }
                    throw new AuthenticationException(gsse.getMessage());
                }
                catch (IOException ex) {
                    this.state = State.FAILED;
                    throw new AuthenticationException(ex.getMessage());
                }
            }
            case TOKEN_GENERATED: {
                String tokenstr = new String(Base64.encodeBase64(this.token, false));
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Sending response '" + tokenstr + "' back to the auth server"));
                }
                return new BasicHeader("Authorization", "Negotiate " + tokenstr);
            }
        }
        throw new IllegalStateException("Illegal state: " + (Object)((Object)this.state));
    }

    public String getParameter(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Parameter name may not be null");
        }
        return null;
    }

    public String getRealm() {
        return null;
    }

    public boolean isConnectionBased() {
        return true;
    }

    protected void parseChallenge(CharArrayBuffer buffer, int beginIndex, int endIndex) throws MalformedChallengeException {
        String challenge = buffer.substringTrimmed(beginIndex, endIndex);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Received challenge '" + challenge + "' from the auth server"));
        }
        if (this.state == State.UNINITIATED) {
            this.token = new Base64().decode(challenge.getBytes());
            this.state = State.CHALLENGE_RECEIVED;
        } else {
            this.log.debug((Object)"Authentication already attempted");
            this.state = State.FAILED;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        UNINITIATED,
        CHALLENGE_RECEIVED,
        TOKEN_GENERATED,
        FAILED;

    }
}

