/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn;

import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpHost;
import org.apache.http.annotation.Immutable;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Lookup;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.DnsResolver;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.conn.ManagedHttpClientConnection;
import org.apache.http.conn.SchemePortResolver;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainSocketFactory;
import org.apache.http.impl.conn.DefaultSchemePortResolver;
import org.apache.http.impl.conn.SystemDefaultDnsResolver;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Args;
import org.apache.http.util.Asserts;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
class HttpClientConnectionOperator {
    private final Log log = LogFactory.getLog(HttpClientConnectionManager.class);
    private final Lookup<ConnectionSocketFactory> socketFactoryRegistry;
    private final SchemePortResolver schemePortResolver;
    private final DnsResolver dnsResolver;

    HttpClientConnectionOperator(Lookup<ConnectionSocketFactory> socketFactoryRegistry, SchemePortResolver schemePortResolver, DnsResolver dnsResolver) {
        Args.notNull(socketFactoryRegistry, (String)"Socket factory registry");
        this.socketFactoryRegistry = socketFactoryRegistry;
        this.schemePortResolver = schemePortResolver != null ? schemePortResolver : DefaultSchemePortResolver.INSTANCE;
        this.dnsResolver = dnsResolver != null ? dnsResolver : SystemDefaultDnsResolver.INSTANCE;
    }

    private Lookup<ConnectionSocketFactory> getSocketFactoryRegistry(HttpContext context) {
        Lookup<ConnectionSocketFactory> reg = (Lookup<ConnectionSocketFactory>)context.getAttribute("http.socket-factory-registry");
        if (reg == null) {
            reg = this.socketFactoryRegistry;
        }
        return reg;
    }

    public void connect(ManagedHttpClientConnection conn, HttpHost host, InetSocketAddress localAddress, int connectTimeout, SocketConfig socketConfig, HttpContext context) throws IOException {
        Lookup<ConnectionSocketFactory> registry = this.getSocketFactoryRegistry(context);
        ConnectionSocketFactory sf = (ConnectionSocketFactory)registry.lookup(host.getSchemeName());
        if (sf == null) {
            throw new IOException("Unsupported scheme: " + host.getSchemeName());
        }
        InetAddress[] addresses = this.dnsResolver.resolve(host.getHostName());
        int port = this.schemePortResolver.resolve(host);
        for (int i = 0; i < addresses.length; ++i) {
            InetSocketAddress remoteAddress;
            block8: {
                InetAddress address = addresses[i];
                boolean last = i == addresses.length - 1;
                Socket sock = sf.createSocket(context);
                sock.setReuseAddress(socketConfig.isSoReuseAddress());
                conn.bind(sock);
                remoteAddress = new InetSocketAddress(address, port);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Connecting to " + remoteAddress));
                }
                try {
                    sock.setSoTimeout(socketConfig.getSoTimeout());
                    sock = sf.connectSocket(connectTimeout, sock, host, remoteAddress, localAddress, context);
                    sock.setTcpNoDelay(socketConfig.isTcpNoDelay());
                    sock.setKeepAlive(socketConfig.isSoKeepAlive());
                    int linger = socketConfig.getSoLinger();
                    if (linger >= 0) {
                        sock.setSoLinger(linger > 0, linger);
                    }
                    conn.bind(sock);
                    return;
                }
                catch (ConnectException ex) {
                    if (last) {
                        throw new HttpHostConnectException(host, ex);
                    }
                }
                catch (ConnectTimeoutException ex) {
                    if (!last) break block8;
                    throw ex;
                }
            }
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug((Object)("Connect to " + remoteAddress + " timed out. " + "Connection will be retried using another IP address"));
        }
    }

    public void upgrade(ManagedHttpClientConnection conn, HttpHost host, HttpContext context) throws IOException {
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        Lookup<ConnectionSocketFactory> registry = this.getSocketFactoryRegistry((HttpContext)clientContext);
        ConnectionSocketFactory sf = (ConnectionSocketFactory)registry.lookup(host.getSchemeName());
        if (sf == null) {
            sf = PlainSocketFactory.INSTANCE;
        }
        Asserts.check((boolean)(sf instanceof LayeredConnectionSocketFactory), (String)"Socket factory must implement LayeredConnectionSocketFactory");
        LayeredConnectionSocketFactory lsf = (LayeredConnectionSocketFactory)sf;
        Socket sock = conn.getSocket();
        try {
            int port = this.schemePortResolver.resolve(host);
            sock = lsf.createLayeredSocket(sock, host.getHostName(), port, context);
        }
        catch (ConnectException ex) {
            throw new HttpHostConnectException(host, ex);
        }
        conn.bind(sock);
    }
}

