/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.entity.mime;

import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.FormBodyPart;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ByteArrayBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.util.Args;

public class MultipartEntityBuilder {
    private boolean lax;
    private String boundary;
    private Charset charset;
    private List<FormBodyPart> bodyParts;

    public static MultipartEntityBuilder create() {
        return new MultipartEntityBuilder();
    }

    MultipartEntityBuilder() {
    }

    public MultipartEntityBuilder setLaxMode() {
        this.lax = true;
        return this;
    }

    public MultipartEntityBuilder setStrictMode() {
        this.lax = false;
        return this;
    }

    public MultipartEntityBuilder setBoundary(String boundary) {
        this.boundary = boundary;
        return this;
    }

    public MultipartEntityBuilder setCharset(Charset charset) {
        this.charset = charset;
        return this;
    }

    public MultipartEntityBuilder addTextBody(String name, String text, ContentType contentType) {
        Args.notNull(name, "Name");
        Args.notNull(text, "Text");
        if (this.bodyParts == null) {
            this.bodyParts = new ArrayList<FormBodyPart>();
        }
        this.bodyParts.add(new FormBodyPart(name, new StringBody(text, contentType)));
        return this;
    }

    public MultipartEntityBuilder addTextBody(String name, String text) {
        return this.addTextBody(name, text, ContentType.DEFAULT_TEXT);
    }

    public MultipartEntityBuilder addBinaryBody(String name, byte[] b, ContentType contentType, String filename) {
        if (this.bodyParts == null) {
            this.bodyParts = new ArrayList<FormBodyPart>();
        }
        this.bodyParts.add(new FormBodyPart(name, new ByteArrayBody(b, contentType, filename)));
        return this;
    }

    public MultipartEntityBuilder addBinaryBody(String name, byte[] b) {
        return this.addBinaryBody(name, b, ContentType.DEFAULT_BINARY, null);
    }

    public MultipartEntityBuilder addBinaryBody(String name, File file, ContentType contentType, String filename) {
        if (this.bodyParts == null) {
            this.bodyParts = new ArrayList<FormBodyPart>();
        }
        this.bodyParts.add(new FormBodyPart(name, new FileBody(file, contentType, filename)));
        return this;
    }

    public MultipartEntityBuilder addBinaryBody(String name, File file) {
        return this.addBinaryBody(name, file, ContentType.DEFAULT_BINARY, null);
    }

    public MultipartEntityBuilder addBinaryBody(String name, InputStream stream, ContentType contentType, String filename) {
        if (this.bodyParts == null) {
            this.bodyParts = new ArrayList<FormBodyPart>();
        }
        this.bodyParts.add(new FormBodyPart(name, new InputStreamBody(stream, contentType, filename)));
        return this;
    }

    public MultipartEntityBuilder addBinaryBody(String name, InputStream stream) {
        return this.addBinaryBody(name, stream, ContentType.DEFAULT_BINARY, null);
    }

    public MultipartEntity build() {
        MultipartEntity e = new MultipartEntity(this.lax ? HttpMultipartMode.BROWSER_COMPATIBLE : HttpMultipartMode.STRICT, this.boundary, this.charset);
        if (this.bodyParts != null) {
            for (FormBodyPart bp : this.bodyParts) {
                e.addPart(bp);
            }
        }
        return e;
    }
}

