/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.auth;

import org.apache.http.auth.Credentials;
import org.apache.http.util.LangUtils;

public class UsernamePasswordCredentials
implements Credentials {
    private final String userName;
    private final String password;

    public UsernamePasswordCredentials(String usernamePassword) {
        if (usernamePassword == null) {
            throw new IllegalArgumentException("Username:password string may not be null");
        }
        int atColon = usernamePassword.indexOf(58);
        if (atColon >= 0) {
            this.userName = usernamePassword.substring(0, atColon);
            this.password = usernamePassword.substring(atColon + 1);
        } else {
            this.userName = usernamePassword;
            this.password = null;
        }
    }

    public UsernamePasswordCredentials(String userName, String password) {
        if (userName == null) {
            throw new IllegalArgumentException("Username may not be null");
        }
        this.userName = userName;
        this.password = password;
    }

    public String getPrincipalName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public String toText() {
        return this.toString();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.userName);
        result.append(':');
        result.append(this.password == null ? "null" : this.password);
        return result.toString();
    }

    public int hashCode() {
        int hash = 17;
        hash = LangUtils.hashCode((int)hash, (Object)this.userName);
        hash = LangUtils.hashCode((int)hash, (Object)this.password);
        return hash;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (this.getClass().equals(o.getClass())) {
            UsernamePasswordCredentials that = (UsernamePasswordCredentials)o;
            if (LangUtils.equals((Object)this.userName, (Object)that.userName) && LangUtils.equals((Object)this.password, (Object)that.password)) {
                return true;
            }
        }
        return false;
    }
}

