/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.protocol;

import junit.framework.Assert;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.client.protocol.RequestAcceptEncoding;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.junit.Test;

public class TestRequestAcceptEncoding {
    @Test
    public void testAcceptEncoding() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        BasicHttpContext context = new BasicHttpContext();
        RequestAcceptEncoding interceptor = new RequestAcceptEncoding();
        interceptor.process((HttpRequest)request, (HttpContext)context);
        Header header = request.getFirstHeader("Accept-Encoding");
        Assert.assertNotNull((Object)header);
        Assert.assertEquals((String)"gzip,deflate", (String)header.getValue());
    }

    @Test
    public void testAcceptEncodingAlreadyPResent() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        request.addHeader("Accept-Encoding", "stuff");
        BasicHttpContext context = new BasicHttpContext();
        RequestAcceptEncoding interceptor = new RequestAcceptEncoding();
        interceptor.process((HttpRequest)request, (HttpContext)context);
        Header header = request.getFirstHeader("Accept-Encoding");
        Assert.assertNotNull((Object)header);
        Assert.assertEquals((String)"stuff", (String)header.getValue());
    }
}

