/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.protocol;

import junit.framework.Assert;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.auth.AuthProtocolState;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.protocol.ResponseAuthCache;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.junit.Before;
import org.junit.Test;

@Deprecated
public class TestResponseAuthCache {
    private HttpHost target;
    private HttpHost proxy;
    private BasicScheme authscheme1;
    private BasicScheme authscheme2;
    private Credentials credentials;
    private AuthState targetState;
    private AuthState proxyState;

    @Before
    public void setUp() throws Exception {
        this.target = new HttpHost("localhost", 80);
        this.proxy = new HttpHost("localhost", 8080);
        this.authscheme1 = new BasicScheme();
        this.authscheme2 = new BasicScheme();
        this.credentials = new UsernamePasswordCredentials("user", "pwd");
        this.targetState = new AuthState();
        this.proxyState = new AuthState();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testResponseParameterCheck() throws Exception {
        BasicHttpContext context = new BasicHttpContext();
        ResponseAuthCache interceptor = new ResponseAuthCache();
        interceptor.process(null, (HttpContext)context);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testContextParameterCheck() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        ResponseAuthCache interceptor = new ResponseAuthCache();
        interceptor.process((HttpResponse)response, null);
    }

    @Test
    public void testTargetAndProxyAuthCaching() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        this.authscheme1.processChallenge((Header)new BasicHeader("WWW-Authenticate", "BASIC realm=auth-realm"));
        this.authscheme2.processChallenge((Header)new BasicHeader("Proxy-Authenticate", "BASIC realm=auth-realm"));
        this.targetState.setState(AuthProtocolState.CHALLENGED);
        this.targetState.update((AuthScheme)this.authscheme1, this.credentials);
        this.proxyState.setState(AuthProtocolState.CHALLENGED);
        this.proxyState.update((AuthScheme)this.authscheme2, this.credentials);
        BasicHttpContext context = new BasicHttpContext();
        context.setAttribute("http.target_host", (Object)this.target);
        context.setAttribute("http.proxy_host", (Object)this.proxy);
        context.setAttribute("http.auth.target-scope", (Object)this.targetState);
        context.setAttribute("http.auth.proxy-scope", (Object)this.proxyState);
        ResponseAuthCache interceptor = new ResponseAuthCache();
        interceptor.process((HttpResponse)response, (HttpContext)context);
        AuthCache authCache = (AuthCache)context.getAttribute("http.auth.auth-cache");
        Assert.assertNotNull((Object)authCache);
        Assert.assertSame((Object)this.authscheme1, (Object)authCache.get(this.target));
        Assert.assertSame((Object)this.authscheme2, (Object)authCache.get(this.proxy));
    }

    @Test
    public void testNoAuthStateInitialized() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        BasicHttpContext context = new BasicHttpContext();
        context.setAttribute("http.target_host", (Object)this.target);
        context.setAttribute("http.proxy_host", (Object)this.proxy);
        ResponseAuthCache interceptor = new ResponseAuthCache();
        interceptor.process((HttpResponse)response, (HttpContext)context);
        AuthCache authCache = (AuthCache)context.getAttribute("http.auth.auth-cache");
        Assert.assertNull((Object)authCache);
    }

    @Test
    public void testNoAuthSchemeSelected() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        BasicHttpContext context = new BasicHttpContext();
        context.setAttribute("http.target_host", (Object)this.target);
        context.setAttribute("http.proxy_host", (Object)this.proxy);
        context.setAttribute("http.auth.target-scope", (Object)this.targetState);
        context.setAttribute("http.auth.proxy-scope", (Object)this.proxyState);
        ResponseAuthCache interceptor = new ResponseAuthCache();
        interceptor.process((HttpResponse)response, (HttpContext)context);
        AuthCache authCache = (AuthCache)context.getAttribute("http.auth.auth-cache");
        Assert.assertNull((Object)authCache);
    }

    @Test
    public void testAuthSchemeNotCompleted() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        this.targetState.setState(AuthProtocolState.CHALLENGED);
        this.targetState.update((AuthScheme)this.authscheme1, this.credentials);
        this.proxyState.setState(AuthProtocolState.CHALLENGED);
        this.proxyState.update((AuthScheme)this.authscheme2, this.credentials);
        BasicHttpContext context = new BasicHttpContext();
        context.setAttribute("http.target_host", (Object)this.target);
        context.setAttribute("http.proxy_host", (Object)this.proxy);
        context.setAttribute("http.auth.target-scope", (Object)this.targetState);
        context.setAttribute("http.auth.proxy-scope", (Object)this.proxyState);
        ResponseAuthCache interceptor = new ResponseAuthCache();
        interceptor.process((HttpResponse)response, (HttpContext)context);
        AuthCache authCache = (AuthCache)context.getAttribute("http.auth.auth-cache");
        Assert.assertNull((Object)authCache);
    }

    @Test
    public void testNotChallenged() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        this.authscheme1.processChallenge((Header)new BasicHeader("WWW-Authenticate", "BASIC realm=auth-realm"));
        this.authscheme2.processChallenge((Header)new BasicHeader("Proxy-Authenticate", "BASIC realm=auth-realm"));
        this.targetState.setState(AuthProtocolState.UNCHALLENGED);
        this.targetState.update((AuthScheme)this.authscheme1, this.credentials);
        this.proxyState.setState(AuthProtocolState.UNCHALLENGED);
        this.proxyState.update((AuthScheme)this.authscheme2, this.credentials);
        BasicHttpContext context = new BasicHttpContext();
        context.setAttribute("http.target_host", (Object)this.target);
        context.setAttribute("http.proxy_host", (Object)this.proxy);
        context.setAttribute("http.auth.target-scope", (Object)this.targetState);
        context.setAttribute("http.auth.proxy-scope", (Object)this.proxyState);
        ResponseAuthCache interceptor = new ResponseAuthCache();
        interceptor.process((HttpResponse)response, (HttpContext)context);
        AuthCache authCache = (AuthCache)context.getAttribute("http.auth.auth-cache");
        Assert.assertNotNull((Object)authCache);
        Assert.assertNull((Object)authCache.get(this.target));
        Assert.assertNull((Object)authCache.get(this.proxy));
    }

    @Test
    public void testInvalidateCachingOnAuthFailure() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        this.authscheme1.processChallenge((Header)new BasicHeader("WWW-Authenticate", "BASIC realm=auth-realm"));
        this.authscheme2.processChallenge((Header)new BasicHeader("Proxy-Authenticate", "BASIC realm=auth-realm"));
        this.targetState.setState(AuthProtocolState.FAILURE);
        this.targetState.update((AuthScheme)this.authscheme1, this.credentials);
        this.proxyState.setState(AuthProtocolState.FAILURE);
        this.proxyState.update((AuthScheme)this.authscheme2, this.credentials);
        BasicHttpContext context = new BasicHttpContext();
        context.setAttribute("http.target_host", (Object)this.target);
        context.setAttribute("http.proxy_host", (Object)this.proxy);
        context.setAttribute("http.auth.target-scope", (Object)this.targetState);
        context.setAttribute("http.auth.proxy-scope", (Object)this.proxyState);
        BasicAuthCache authCache = new BasicAuthCache();
        authCache.put(this.target, (AuthScheme)this.authscheme1);
        authCache.put(this.proxy, (AuthScheme)this.authscheme2);
        context.setAttribute("http.auth.auth-cache", (Object)authCache);
        ResponseAuthCache interceptor = new ResponseAuthCache();
        interceptor.process((HttpResponse)response, (HttpContext)context);
        Assert.assertNull((Object)authCache.get(this.target));
        Assert.assertNull((Object)authCache.get(this.proxy));
    }
}

