/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.utils;

import java.net.URI;
import org.apache.http.client.utils.URIBuilder;
import org.junit.Assert;
import org.junit.Test;

public class TestURIBuilder {
    @Test
    public void testHierarchicalUri() throws Exception {
        URI uri = new URI("http", "stuff", "localhost", 80, "/some stuff", "param=stuff", "fragment");
        URIBuilder uribuilder = new URIBuilder(uri);
        URI result = uribuilder.build();
        Assert.assertEquals((Object)uri, (Object)result);
    }

    @Test
    public void testOpaqueUri() throws Exception {
        URI uri = new URI("stuff", "some-stuff", "fragment");
        URIBuilder uribuilder = new URIBuilder(uri);
        URI result = uribuilder.build();
        Assert.assertEquals((Object)uri, (Object)result);
    }

    @Test
    public void testOpaqueUriMutation() throws Exception {
        URI uri = new URI("stuff", "some-stuff", "fragment");
        URIBuilder uribuilder = new URIBuilder(uri).setQuery("param1&param2=stuff").setFragment(null);
        Assert.assertEquals((Object)new URI("stuff:?param1&param2=stuff"), (Object)uribuilder.build());
    }

    @Test
    public void testHierarchicalUriMutation() throws Exception {
        URIBuilder uribuilder = new URIBuilder("/").setScheme("http").setHost("localhost").setPort(80).setPath("/stuff");
        Assert.assertEquals((Object)new URI("http://localhost:80/stuff"), (Object)uribuilder.build());
    }

    @Test
    public void testEmpty() throws Exception {
        URIBuilder uribuilder = new URIBuilder();
        URI result = uribuilder.build();
        Assert.assertEquals((Object)new URI(""), (Object)result);
    }

    @Test
    public void testSetUserInfo() throws Exception {
        URI uri = new URI("http", null, "localhost", 80, "/", "param=stuff", null);
        URIBuilder uribuilder = new URIBuilder(uri).setUserInfo("user", "password");
        URI result = uribuilder.build();
        Assert.assertEquals((Object)new URI("http://user:password@localhost:80/?param=stuff"), (Object)result);
    }

    @Test
    public void testRemoveParameters() throws Exception {
        URI uri = new URI("http", null, "localhost", 80, "/", "param=stuff", null);
        URIBuilder uribuilder = new URIBuilder(uri).removeQuery();
        URI result = uribuilder.build();
        Assert.assertEquals((Object)new URI("http://localhost:80/"), (Object)result);
    }

    @Test
    public void testSetParameter() throws Exception {
        URI uri = new URI("http", null, "localhost", 80, "/", "param=stuff&blah&blah", null);
        URIBuilder uribuilder = new URIBuilder(uri).setParameter("param", "some other stuff").setParameter("blah", "blah");
        URI result = uribuilder.build();
        Assert.assertEquals((Object)new URI("http://localhost:80/?param=some+other+stuff&blah=blah"), (Object)result);
    }

    @Test
    public void testAddParameter() throws Exception {
        URI uri = new URI("http", null, "localhost", 80, "/", "param=stuff&blah&blah", null);
        URIBuilder uribuilder = new URIBuilder(uri).addParameter("param", "some other stuff").addParameter("blah", "blah");
        URI result = uribuilder.build();
        Assert.assertEquals((Object)new URI("http://localhost:80/?param=stuff&blah&blah&param=some+other+stuff&blah=blah"), (Object)result);
    }
}

