/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.utils;

import java.net.URI;
import org.apache.http.HttpHost;
import org.apache.http.client.utils.URIUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestURIUtils {
    private URI baseURI = URI.create("http://a/b/c/d;p?q");

    @Test
    public void testRewite() throws Exception {
        HttpHost target = new HttpHost("thathost", -1);
        Assert.assertEquals((Object)"http://thathost/stuff", (Object)URIUtils.rewriteURI((URI)URI.create("http://thishost/stuff"), (HttpHost)target).toString());
        Assert.assertEquals((Object)"/stuff", (Object)URIUtils.rewriteURI((URI)URI.create("http://thishost/stuff"), null).toString());
        Assert.assertEquals((Object)"/", (Object)URIUtils.rewriteURI((URI)URI.create("http://thishost//"), null).toString());
        Assert.assertEquals((Object)"/stuff///morestuff", (Object)URIUtils.rewriteURI((URI)URI.create("http://thishost//stuff///morestuff"), null).toString());
        Assert.assertEquals((Object)"http://thathost/stuff", (Object)URIUtils.rewriteURI((URI)URI.create("http://thishost/stuff#crap"), (HttpHost)target, (boolean)true).toString());
        Assert.assertEquals((Object)"http://thathost/stuff#crap", (Object)URIUtils.rewriteURI((URI)URI.create("http://thishost/stuff#crap"), (HttpHost)target, (boolean)false).toString());
        Assert.assertEquals((Object)"/stuff/", (Object)URIUtils.rewriteURI((URI)URI.create("http://thishost//////////////stuff/"), null).toString());
        Assert.assertEquals((Object)"http://thathost/stuff", (Object)URIUtils.rewriteURI((URI)URI.create("http://thathost/stuff")).toString());
        Assert.assertEquals((Object)"http://thathost/stuff", (Object)URIUtils.rewriteURI((URI)URI.create("http://thathost/stuff#fragment")).toString());
    }

    @Test
    public void testResolve() {
        Assert.assertEquals((Object)"g:h", (Object)URIUtils.resolve((URI)this.baseURI, (String)"g:h").toString());
        Assert.assertEquals((Object)"http://a/b/c/g", (Object)URIUtils.resolve((URI)this.baseURI, (String)"g").toString());
        Assert.assertEquals((Object)"http://a/b/c/g", (Object)URIUtils.resolve((URI)this.baseURI, (String)"./g").toString());
        Assert.assertEquals((Object)"http://a/b/c/g/", (Object)URIUtils.resolve((URI)this.baseURI, (String)"g/").toString());
        Assert.assertEquals((Object)"http://a/g", (Object)URIUtils.resolve((URI)this.baseURI, (String)"/g").toString());
        Assert.assertEquals((Object)"http://g", (Object)URIUtils.resolve((URI)this.baseURI, (String)"//g").toString());
        Assert.assertEquals((Object)"http://a/b/c/d;p?y", (Object)URIUtils.resolve((URI)this.baseURI, (String)"?y").toString());
        Assert.assertEquals((Object)"http://a/b/c/d;p?y#f", (Object)URIUtils.resolve((URI)this.baseURI, (String)"?y#f").toString());
        Assert.assertEquals((Object)"http://a/b/c/g?y", (Object)URIUtils.resolve((URI)this.baseURI, (String)"g?y").toString());
        Assert.assertEquals((Object)"http://a/b/c/d;p?q#s", (Object)URIUtils.resolve((URI)this.baseURI, (String)"#s").toString());
        Assert.assertEquals((Object)"http://a/b/c/g#s", (Object)URIUtils.resolve((URI)this.baseURI, (String)"g#s").toString());
        Assert.assertEquals((Object)"http://a/b/c/g?y#s", (Object)URIUtils.resolve((URI)this.baseURI, (String)"g?y#s").toString());
        Assert.assertEquals((Object)"http://a/b/c/;x", (Object)URIUtils.resolve((URI)this.baseURI, (String)";x").toString());
        Assert.assertEquals((Object)"http://a/b/c/g;x", (Object)URIUtils.resolve((URI)this.baseURI, (String)"g;x").toString());
        Assert.assertEquals((Object)"http://a/b/c/g;x?y#s", (Object)URIUtils.resolve((URI)this.baseURI, (String)"g;x?y#s").toString());
        Assert.assertEquals((Object)"http://a/b/c/d;p?q", (Object)URIUtils.resolve((URI)this.baseURI, (String)"").toString());
        Assert.assertEquals((Object)"http://a/b/c/", (Object)URIUtils.resolve((URI)this.baseURI, (String)".").toString());
        Assert.assertEquals((Object)"http://a/b/c/", (Object)URIUtils.resolve((URI)this.baseURI, (String)"./").toString());
        Assert.assertEquals((Object)"http://a/b/", (Object)URIUtils.resolve((URI)this.baseURI, (String)"..").toString());
        Assert.assertEquals((Object)"http://a/b/", (Object)URIUtils.resolve((URI)this.baseURI, (String)"../").toString());
        Assert.assertEquals((Object)"http://a/b/g", (Object)URIUtils.resolve((URI)this.baseURI, (String)"../g").toString());
        Assert.assertEquals((Object)"http://a/", (Object)URIUtils.resolve((URI)this.baseURI, (String)"../..").toString());
        Assert.assertEquals((Object)"http://a/", (Object)URIUtils.resolve((URI)this.baseURI, (String)"../../").toString());
        Assert.assertEquals((Object)"http://a/g", (Object)URIUtils.resolve((URI)this.baseURI, (String)"../../g").toString());
        Assert.assertEquals((Object)"http://a/g", (Object)URIUtils.resolve((URI)this.baseURI, (String)"../../../g").toString());
        Assert.assertEquals((Object)"http://a/g", (Object)URIUtils.resolve((URI)this.baseURI, (String)"../../../../g").toString());
        Assert.assertEquals((Object)"http://a/g", (Object)URIUtils.resolve((URI)this.baseURI, (String)"/./g").toString());
        Assert.assertEquals((Object)"http://a/g", (Object)URIUtils.resolve((URI)this.baseURI, (String)"/../g").toString());
        Assert.assertEquals((Object)"http://a/b/c/g.", (Object)URIUtils.resolve((URI)this.baseURI, (String)"g.").toString());
        Assert.assertEquals((Object)"http://a/b/c/.g", (Object)URIUtils.resolve((URI)this.baseURI, (String)".g").toString());
        Assert.assertEquals((Object)"http://a/b/c/g..", (Object)URIUtils.resolve((URI)this.baseURI, (String)"g..").toString());
        Assert.assertEquals((Object)"http://a/b/c/..g", (Object)URIUtils.resolve((URI)this.baseURI, (String)"..g").toString());
        Assert.assertEquals((Object)"http://a/b/g", (Object)URIUtils.resolve((URI)this.baseURI, (String)"./../g").toString());
        Assert.assertEquals((Object)"http://a/b/c/g/", (Object)URIUtils.resolve((URI)this.baseURI, (String)"./g/.").toString());
        Assert.assertEquals((Object)"http://a/b/c/g/h", (Object)URIUtils.resolve((URI)this.baseURI, (String)"g/./h").toString());
        Assert.assertEquals((Object)"http://a/b/c/h", (Object)URIUtils.resolve((URI)this.baseURI, (String)"g/../h").toString());
        Assert.assertEquals((Object)"http://a/b/c/g;x=1/y", (Object)URIUtils.resolve((URI)this.baseURI, (String)"g;x=1/./y").toString());
        Assert.assertEquals((Object)"http://a/b/c/y", (Object)URIUtils.resolve((URI)this.baseURI, (String)"g;x=1/../y").toString());
        Assert.assertEquals((Object)"http://a/b/c/g?y/./x", (Object)URIUtils.resolve((URI)this.baseURI, (String)"g?y/./x").toString());
        Assert.assertEquals((Object)"http://a/b/c/g?y/../x", (Object)URIUtils.resolve((URI)this.baseURI, (String)"g?y/../x").toString());
        Assert.assertEquals((Object)"http://a/b/c/g#s/./x", (Object)URIUtils.resolve((URI)this.baseURI, (String)"g#s/./x").toString());
        Assert.assertEquals((Object)"http://a/b/c/g#s/../x", (Object)URIUtils.resolve((URI)this.baseURI, (String)"g#s/../x").toString());
        Assert.assertEquals((Object)"http:g", (Object)URIUtils.resolve((URI)this.baseURI, (String)"http:g").toString());
        Assert.assertEquals((Object)"http://s/a/g", (Object)URIUtils.resolve((URI)this.baseURI, (String)"http://s/a/b/c/./../../g").toString());
        Assert.assertEquals((Object)"http://s/mid/6", (Object)URIUtils.resolve((URI)this.baseURI, (String)"http://s/mid/content=5/../6").toString());
    }

    @Test
    public void testExtractHost() throws Exception {
        Assert.assertEquals((Object)new HttpHost("localhost"), (Object)URIUtils.extractHost((URI)new URI("http://localhost/abcd")));
        Assert.assertEquals((Object)new HttpHost("localhost"), (Object)URIUtils.extractHost((URI)new URI("http://localhost/abcd%3A")));
        Assert.assertEquals((Object)new HttpHost("local_host"), (Object)URIUtils.extractHost((URI)new URI("http://local_host/abcd")));
        Assert.assertEquals((Object)new HttpHost("local_host"), (Object)URIUtils.extractHost((URI)new URI("http://local_host/abcd%3A")));
        Assert.assertEquals((Object)new HttpHost("localhost", 8), (Object)URIUtils.extractHost((URI)new URI("http://localhost:8/abcd")));
        Assert.assertEquals((Object)new HttpHost("local_host", 8), (Object)URIUtils.extractHost((URI)new URI("http://local_host:8/abcd")));
        Assert.assertEquals((Object)new HttpHost("localhost", -1), (Object)URIUtils.extractHost((URI)new URI("http://localhost:/abcd")));
        Assert.assertEquals((Object)new HttpHost("local_host", -1), (Object)URIUtils.extractHost((URI)new URI("http://local_host:/abcd")));
        Assert.assertEquals((Object)new HttpHost("localhost", 8080), (Object)URIUtils.extractHost((URI)new URI("http://user:pass@localhost:8080/abcd")));
        Assert.assertEquals((Object)new HttpHost("local_host", 8080), (Object)URIUtils.extractHost((URI)new URI("http://user:pass@local_host:8080/abcd")));
        Assert.assertEquals((Object)new HttpHost("localhost", 8080), (Object)URIUtils.extractHost((URI)new URI("http://@localhost:8080/abcd")));
        Assert.assertEquals((Object)new HttpHost("local_host", 8080), (Object)URIUtils.extractHost((URI)new URI("http://@local_host:8080/abcd")));
        Assert.assertEquals((Object)new HttpHost("[2a00:1450:400c:c01::69]", 8080), (Object)URIUtils.extractHost((URI)new URI("http://[2a00:1450:400c:c01::69]:8080/")));
        Assert.assertEquals((Object)new HttpHost("localhost", 8080), (Object)URIUtils.extractHost((URI)new URI("http://localhost:8080/;sessionid=stuff/abcd")));
        Assert.assertEquals((Object)new HttpHost("localhost", 8080), (Object)URIUtils.extractHost((URI)new URI("http://localhost:8080;sessionid=stuff/abcd")));
        Assert.assertEquals((Object)new HttpHost("localhost", -1), (Object)URIUtils.extractHost((URI)new URI("http://localhost:;sessionid=stuff/abcd")));
    }
}

