/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.junit.Assert;
import org.junit.Test;

public class TestRequestRetryHandler {
    @Test(expected=UnknownHostException.class)
    public void testUseRetryHandlerInConnectionTimeOut() throws Exception {
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", 80, (SchemeSocketFactory)new OppsieSchemeSocketFactory()));
        PoolingClientConnectionManager connManager = new PoolingClientConnectionManager(schemeRegistry);
        this.assertOnRetry((ClientConnectionManager)connManager);
    }

    protected void assertOnRetry(ClientConnectionManager connManager) throws Exception {
        DefaultHttpClient client = new DefaultHttpClient(connManager);
        TestHttpRequestRetryHandler testRetryHandler = new TestHttpRequestRetryHandler();
        client.setHttpRequestRetryHandler((HttpRequestRetryHandler)testRetryHandler);
        HttpGet request = new HttpGet("http://www.example.com/");
        HttpConnectionParams.setConnectionTimeout((HttpParams)request.getParams(), (int)1);
        try {
            client.execute((HttpUriRequest)request);
        }
        catch (UnknownHostException ex) {
            Assert.assertEquals((long)2L, (long)testRetryHandler.retryNumber);
            throw ex;
        }
    }

    static class OppsieSchemeSocketFactory
    implements SchemeSocketFactory {
        OppsieSchemeSocketFactory() {
        }

        public boolean isSecure(Socket sock) throws IllegalArgumentException {
            return false;
        }

        public Socket createSocket(HttpParams params) throws IOException {
            return new Socket();
        }

        public Socket connectSocket(Socket sock, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
            throw new UnknownHostException("Ooopsie");
        }
    }

    static class TestHttpRequestRetryHandler
    implements HttpRequestRetryHandler {
        int retryNumber = 0;

        TestHttpRequestRetryHandler() {
        }

        public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
            ++this.retryNumber;
            return executionCount < 2;
        }
    }
}

