/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.http.conn.DnsResolver;
import org.apache.http.impl.conn.DefaultClientConnectionOperator;
import org.apache.http.impl.conn.SchemeRegistryFactory;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestDefaultClientConnectOperator {
    @Test
    public void testCustomDnsResolver() throws Exception {
        DnsResolver dnsResolver = (DnsResolver)Mockito.mock(DnsResolver.class);
        Object[] firstAddress = this.translateIp("192.168.1.1");
        Mockito.when((Object)dnsResolver.resolve("somehost.example.com")).thenReturn((Object)firstAddress);
        Object[] secondAddress = this.translateIp("192.168.12.16");
        Mockito.when((Object)dnsResolver.resolve("otherhost.example.com")).thenReturn((Object)secondAddress);
        DefaultClientConnectionOperator operator = new DefaultClientConnectionOperator(SchemeRegistryFactory.createDefault(), dnsResolver);
        Assert.assertArrayEquals((Object[])firstAddress, (Object[])operator.resolveHostname("somehost.example.com"));
        Assert.assertArrayEquals((Object[])secondAddress, (Object[])operator.resolveHostname("otherhost.example.com"));
    }

    @Test(expected=UnknownHostException.class)
    public void testDnsResolverUnknownHost() throws Exception {
        DnsResolver dnsResolver = (DnsResolver)Mockito.mock(DnsResolver.class);
        Mockito.when((Object)dnsResolver.resolve("unknown.example.com")).thenThrow(new Throwable[]{new UnknownHostException()});
        DefaultClientConnectionOperator operator = new DefaultClientConnectionOperator(SchemeRegistryFactory.createDefault(), dnsResolver);
        operator.resolveHostname("unknown.example.com");
    }

    @Test
    public void testDefaultLocalHost() throws Exception {
        DefaultClientConnectionOperator operator = new DefaultClientConnectionOperator(SchemeRegistryFactory.createDefault());
        operator.resolveHostname("localhost");
    }

    private InetAddress[] translateIp(String ip) throws UnknownHostException {
        String[] ipParts = ip.split("\\.");
        byte[] byteIpAddress = new byte[4];
        for (int i = 0; i < 4; ++i) {
            byteIpAddress[i] = Integer.decode(ipParts[i]).byteValue();
        }
        return new InetAddress[]{InetAddress.getByAddress(byteIpAddress)};
    }
}

