/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ClientConnectionOperator;
import org.apache.http.conn.ClientConnectionRequest;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.ConnectionPoolTimeoutException;
import org.apache.http.conn.ManagedClientConnection;
import org.apache.http.conn.OperatedClientConnection;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.impl.conn.ExecReqThread;
import org.apache.http.impl.conn.Helper;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.impl.conn.SchemeRegistryFactory;
import org.apache.http.localserver.ServerTestBase;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.util.EntityUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestPoolingConnManager
extends ServerTestBase {
    @Test
    public void testParallelRequests() throws Exception {
        int i;
        int COUNT = 8;
        PoolingClientConnectionManager mgr = new PoolingClientConnectionManager();
        mgr.setMaxTotal(4);
        mgr.setDefaultMaxPerRoute(4);
        HttpHost target = this.getServerHttp();
        HttpRoute route = new HttpRoute(target, null, false);
        int rsplen = 8;
        String uri = "/random/8";
        ExecReqThread[] threads = new ExecReqThread[8];
        for (i = 0; i < 8; ++i) {
            BasicHttpRequest request = new BasicHttpRequest("GET", "/random/8", (ProtocolVersion)HttpVersion.HTTP_1_1);
            ExecReqThread.RequestSpec ertrs = new ExecReqThread.RequestSpec();
            ertrs.executor = this.httpExecutor;
            ertrs.processor = this.httpProcessor;
            ertrs.context = new BasicHttpContext(null);
            ertrs.params = this.defaultParams;
            ertrs.context.setAttribute("http.target_host", (Object)target);
            ertrs.context.setAttribute("http.request", (Object)request);
            threads[i] = new ExecReqThread((ClientConnectionManager)mgr, route, 5000L, ertrs);
        }
        for (i = 0; i < threads.length; ++i) {
            threads[i].start();
        }
        for (i = 0; i < threads.length; ++i) {
            threads[i].join(10000L);
            Assert.assertNull((String)("exception in thread " + i), (Object)threads[i].getException());
            Assert.assertNotNull((String)("no response in thread " + i), (Object)threads[i].getResponse());
            Assert.assertEquals((String)("wrong status code in thread " + i), (long)200L, (long)threads[i].getResponse().getStatusLine().getStatusCode());
            Assert.assertNotNull((String)("no response data in thread " + i), (Object)threads[i].getResponseData());
            Assert.assertEquals((String)("wrong length of data in thread" + i), (long)8L, (long)threads[i].getResponseData().length);
        }
        mgr.shutdown();
    }

    private static ManagedClientConnection getConnection(ClientConnectionManager mgr, HttpRoute route, long timeout, TimeUnit unit) throws ConnectionPoolTimeoutException, InterruptedException {
        ClientConnectionRequest connRequest = mgr.requestConnection(route, null);
        return connRequest.getConnection(timeout, unit);
    }

    private static ManagedClientConnection getConnection(ClientConnectionManager mgr, HttpRoute route) throws ConnectionPoolTimeoutException, InterruptedException {
        ClientConnectionRequest connRequest = mgr.requestConnection(route, null);
        return connRequest.getConnection(0L, null);
    }

    @Test
    public void testReleaseConnection() throws Exception {
        PoolingClientConnectionManager mgr = new PoolingClientConnectionManager();
        mgr.setMaxTotal(1);
        HttpHost target = this.getServerHttp();
        HttpRoute route = new HttpRoute(target, null, false);
        int rsplen = 8;
        String uri = "/random/8";
        BasicHttpRequest request = new BasicHttpRequest("GET", "/random/8", (ProtocolVersion)HttpVersion.HTTP_1_1);
        ManagedClientConnection conn = TestPoolingConnManager.getConnection((ClientConnectionManager)mgr, route);
        conn.open(route, (HttpContext)this.httpContext, this.defaultParams);
        HttpResponse response = Helper.execute((HttpRequest)request, (HttpClientConnection)conn, target, this.httpExecutor, (HttpProcessor)this.httpProcessor, this.defaultParams, (HttpContext)this.httpContext);
        Assert.assertEquals((String)"wrong status in first response", (long)200L, (long)response.getStatusLine().getStatusCode());
        byte[] data = EntityUtils.toByteArray((HttpEntity)response.getEntity());
        Assert.assertEquals((String)"wrong length of first response entity", (long)8L, (long)data.length);
        try {
            TestPoolingConnManager.getConnection((ClientConnectionManager)mgr, route, 10L, TimeUnit.MILLISECONDS);
            Assert.fail((String)"ConnectionPoolTimeoutException should have been thrown");
        }
        catch (ConnectionPoolTimeoutException e) {
            // empty catch block
        }
        mgr.releaseConnection(conn, -1L, null);
        conn = TestPoolingConnManager.getConnection((ClientConnectionManager)mgr, route);
        Assert.assertFalse((String)"connection should have been closed", (boolean)conn.isOpen());
        conn.open(route, (HttpContext)this.httpContext, this.defaultParams);
        this.httpContext.setAttribute("http.connection", (Object)conn);
        response = this.httpExecutor.execute((HttpRequest)request, (HttpClientConnection)conn, (HttpContext)this.httpContext);
        this.httpExecutor.postProcess(response, (HttpProcessor)this.httpProcessor, (HttpContext)this.httpContext);
        Assert.assertEquals((String)"wrong status in second response", (long)200L, (long)response.getStatusLine().getStatusCode());
        data = EntityUtils.toByteArray((HttpEntity)response.getEntity());
        Assert.assertEquals((String)"wrong length of second response entity", (long)8L, (long)data.length);
        conn.markReusable();
        mgr.releaseConnection(conn, -1L, null);
        conn = TestPoolingConnManager.getConnection((ClientConnectionManager)mgr, route);
        Assert.assertTrue((String)"connection should have been open", (boolean)conn.isOpen());
        this.httpContext.setAttribute("http.connection", (Object)conn);
        response = this.httpExecutor.execute((HttpRequest)request, (HttpClientConnection)conn, (HttpContext)this.httpContext);
        this.httpExecutor.postProcess(response, (HttpProcessor)this.httpProcessor, (HttpContext)this.httpContext);
        Assert.assertEquals((String)"wrong status in third response", (long)200L, (long)response.getStatusLine().getStatusCode());
        data = EntityUtils.toByteArray((HttpEntity)response.getEntity());
        Assert.assertEquals((String)"wrong length of third response entity", (long)8L, (long)data.length);
        mgr.releaseConnection(conn, -1L, null);
        mgr.shutdown();
    }

    @Test
    public void testReleaseConnectionWithTimeLimits() throws Exception {
        PoolingClientConnectionManager mgr = new PoolingClientConnectionManager();
        mgr.setMaxTotal(1);
        HttpHost target = this.getServerHttp();
        HttpRoute route = new HttpRoute(target, null, false);
        int rsplen = 8;
        String uri = "/random/8";
        BasicHttpRequest request = new BasicHttpRequest("GET", "/random/8", (ProtocolVersion)HttpVersion.HTTP_1_1);
        ManagedClientConnection conn = TestPoolingConnManager.getConnection((ClientConnectionManager)mgr, route);
        conn.open(route, (HttpContext)this.httpContext, this.defaultParams);
        HttpResponse response = Helper.execute((HttpRequest)request, (HttpClientConnection)conn, target, this.httpExecutor, (HttpProcessor)this.httpProcessor, this.defaultParams, (HttpContext)this.httpContext);
        Assert.assertEquals((String)"wrong status in first response", (long)200L, (long)response.getStatusLine().getStatusCode());
        byte[] data = EntityUtils.toByteArray((HttpEntity)response.getEntity());
        Assert.assertEquals((String)"wrong length of first response entity", (long)8L, (long)data.length);
        try {
            TestPoolingConnManager.getConnection((ClientConnectionManager)mgr, route, 10L, TimeUnit.MILLISECONDS);
            Assert.fail((String)"ConnectionPoolTimeoutException should have been thrown");
        }
        catch (ConnectionPoolTimeoutException e) {
            // empty catch block
        }
        mgr.releaseConnection(conn, 100L, TimeUnit.MILLISECONDS);
        conn = TestPoolingConnManager.getConnection((ClientConnectionManager)mgr, route);
        Assert.assertFalse((String)"connection should have been closed", (boolean)conn.isOpen());
        conn.open(route, (HttpContext)this.httpContext, this.defaultParams);
        this.httpContext.setAttribute("http.connection", (Object)conn);
        response = this.httpExecutor.execute((HttpRequest)request, (HttpClientConnection)conn, (HttpContext)this.httpContext);
        this.httpExecutor.postProcess(response, (HttpProcessor)this.httpProcessor, (HttpContext)this.httpContext);
        Assert.assertEquals((String)"wrong status in second response", (long)200L, (long)response.getStatusLine().getStatusCode());
        data = EntityUtils.toByteArray((HttpEntity)response.getEntity());
        Assert.assertEquals((String)"wrong length of second response entity", (long)8L, (long)data.length);
        conn.markReusable();
        mgr.releaseConnection(conn, 100L, TimeUnit.MILLISECONDS);
        conn = TestPoolingConnManager.getConnection((ClientConnectionManager)mgr, route);
        Assert.assertTrue((String)"connection should have been open", (boolean)conn.isOpen());
        this.httpContext.setAttribute("http.connection", (Object)conn);
        response = this.httpExecutor.execute((HttpRequest)request, (HttpClientConnection)conn, (HttpContext)this.httpContext);
        this.httpExecutor.postProcess(response, (HttpProcessor)this.httpProcessor, (HttpContext)this.httpContext);
        Assert.assertEquals((String)"wrong status in third response", (long)200L, (long)response.getStatusLine().getStatusCode());
        data = EntityUtils.toByteArray((HttpEntity)response.getEntity());
        Assert.assertEquals((String)"wrong length of third response entity", (long)8L, (long)data.length);
        conn.markReusable();
        mgr.releaseConnection(conn, 100L, TimeUnit.MILLISECONDS);
        Thread.sleep(150L);
        conn = TestPoolingConnManager.getConnection((ClientConnectionManager)mgr, route);
        Assert.assertTrue((String)"connection should have been closed", (!conn.isOpen() ? 1 : 0) != 0);
        conn.open(route, (HttpContext)this.httpContext, this.defaultParams);
        this.httpContext.setAttribute("http.connection", (Object)conn);
        response = this.httpExecutor.execute((HttpRequest)request, (HttpClientConnection)conn, (HttpContext)this.httpContext);
        this.httpExecutor.postProcess(response, (HttpProcessor)this.httpProcessor, (HttpContext)this.httpContext);
        Assert.assertEquals((String)"wrong status in third response", (long)200L, (long)response.getStatusLine().getStatusCode());
        data = EntityUtils.toByteArray((HttpEntity)response.getEntity());
        Assert.assertEquals((String)"wrong length of fourth response entity", (long)8L, (long)data.length);
        mgr.shutdown();
    }

    @Test
    public void testCloseExpiredIdleConnections() throws Exception {
        PoolingClientConnectionManager mgr = new PoolingClientConnectionManager();
        mgr.setMaxTotal(1);
        HttpHost target = this.getServerHttp();
        HttpRoute route = new HttpRoute(target, null, false);
        ManagedClientConnection conn = TestPoolingConnManager.getConnection((ClientConnectionManager)mgr, route);
        conn.open(route, (HttpContext)this.httpContext, this.defaultParams);
        Assert.assertEquals((long)1L, (long)mgr.getTotalStats().getLeased());
        Assert.assertEquals((long)1L, (long)mgr.getStats(route).getLeased());
        conn.markReusable();
        mgr.releaseConnection(conn, 100L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)1L, (long)mgr.getTotalStats().getAvailable());
        Assert.assertEquals((long)1L, (long)mgr.getStats(route).getAvailable());
        mgr.closeExpiredConnections();
        Assert.assertEquals((long)1L, (long)mgr.getTotalStats().getAvailable());
        Assert.assertEquals((long)1L, (long)mgr.getStats(route).getAvailable());
        Thread.sleep(150L);
        mgr.closeExpiredConnections();
        Assert.assertEquals((long)0L, (long)mgr.getTotalStats().getAvailable());
        Assert.assertEquals((long)0L, (long)mgr.getStats(route).getAvailable());
        mgr.shutdown();
    }

    @Test
    public void testCloseExpiredTTLConnections() throws Exception {
        PoolingClientConnectionManager mgr = new PoolingClientConnectionManager(SchemeRegistryFactory.createDefault(), 100L, TimeUnit.MILLISECONDS);
        mgr.setMaxTotal(1);
        HttpHost target = this.getServerHttp();
        HttpRoute route = new HttpRoute(target, null, false);
        ManagedClientConnection conn = TestPoolingConnManager.getConnection((ClientConnectionManager)mgr, route);
        conn.open(route, (HttpContext)this.httpContext, this.defaultParams);
        Assert.assertEquals((long)1L, (long)mgr.getTotalStats().getLeased());
        Assert.assertEquals((long)1L, (long)mgr.getStats(route).getLeased());
        conn.markReusable();
        mgr.releaseConnection(conn, -1L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)1L, (long)mgr.getTotalStats().getAvailable());
        Assert.assertEquals((long)1L, (long)mgr.getStats(route).getAvailable());
        mgr.closeExpiredConnections();
        Assert.assertEquals((long)1L, (long)mgr.getTotalStats().getAvailable());
        Assert.assertEquals((long)1L, (long)mgr.getStats(route).getAvailable());
        Thread.sleep(150L);
        mgr.closeExpiredConnections();
        Assert.assertEquals((long)0L, (long)mgr.getTotalStats().getAvailable());
        Assert.assertEquals((long)0L, (long)mgr.getStats(route).getAvailable());
        mgr.shutdown();
    }

    @Test
    public void testReleaseConnectionOnAbort() throws Exception {
        PoolingClientConnectionManager mgr = new PoolingClientConnectionManager();
        mgr.setMaxTotal(1);
        HttpHost target = this.getServerHttp();
        HttpRoute route = new HttpRoute(target, null, false);
        int rsplen = 8;
        String uri = "/random/8";
        BasicHttpRequest request = new BasicHttpRequest("GET", "/random/8", (ProtocolVersion)HttpVersion.HTTP_1_1);
        ManagedClientConnection conn = TestPoolingConnManager.getConnection((ClientConnectionManager)mgr, route);
        conn.open(route, (HttpContext)this.httpContext, this.defaultParams);
        HttpResponse response = Helper.execute((HttpRequest)request, (HttpClientConnection)conn, target, this.httpExecutor, (HttpProcessor)this.httpProcessor, this.defaultParams, (HttpContext)this.httpContext);
        Assert.assertEquals((String)"wrong status in first response", (long)200L, (long)response.getStatusLine().getStatusCode());
        try {
            TestPoolingConnManager.getConnection((ClientConnectionManager)mgr, route, 100L, TimeUnit.MILLISECONDS);
            Assert.fail((String)"ConnectionPoolTimeoutException should have been thrown");
        }
        catch (ConnectionPoolTimeoutException e) {
            // empty catch block
        }
        Assert.assertTrue((boolean)(conn instanceof ManagedClientConnection));
        conn.abortConnection();
        conn = TestPoolingConnManager.getConnection((ClientConnectionManager)mgr, route, 5L, TimeUnit.SECONDS);
        Assert.assertFalse((String)"connection should have been closed", (boolean)conn.isOpen());
        mgr.releaseConnection(conn, -1L, null);
        mgr.shutdown();
    }

    @Test
    public void testAbortDuringConnecting() throws Exception {
        final CountDownLatch connectLatch = new CountDownLatch(1);
        final StallingSocketFactory stallingSocketFactory = new StallingSocketFactory(connectLatch, WaitPolicy.BEFORE_CONNECT, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory());
        Scheme scheme = new Scheme("http", 80, (SchemeSocketFactory)stallingSocketFactory);
        SchemeRegistry registry = new SchemeRegistry();
        registry.register(scheme);
        PoolingClientConnectionManager mgr = new PoolingClientConnectionManager(registry);
        mgr.setMaxTotal(1);
        HttpHost target = this.getServerHttp();
        HttpRoute route = new HttpRoute(target, null, false);
        final ManagedClientConnection conn = TestPoolingConnManager.getConnection((ClientConnectionManager)mgr, route);
        final AtomicReference throwRef = new AtomicReference();
        Thread abortingThread = new Thread(new Runnable(){

            public void run() {
                try {
                    stallingSocketFactory.waitForState();
                    conn.abortConnection();
                    connectLatch.countDown();
                }
                catch (Throwable e) {
                    throwRef.set(e);
                }
            }
        });
        abortingThread.start();
        try {
            conn.open(route, (HttpContext)this.httpContext, this.defaultParams);
            Assert.fail((String)"expected SocketException");
        }
        catch (SocketException expected) {
            // empty catch block
        }
        abortingThread.join(5000L);
        if (throwRef.get() != null) {
            throw new RuntimeException((Throwable)throwRef.get());
        }
        Assert.assertFalse((boolean)conn.isOpen());
        Assert.assertEquals((long)0L, (long)this.localServer.getAcceptedConnectionCount());
        ManagedClientConnection conn2 = TestPoolingConnManager.getConnection((ClientConnectionManager)mgr, route, 5L, TimeUnit.SECONDS);
        Assert.assertFalse((String)"connection should have been closed", (boolean)conn2.isOpen());
        mgr.releaseConnection(conn2, -1L, null);
        mgr.shutdown();
    }

    @Test
    public void testAbortBeforeSocketCreate() throws Exception {
        final CountDownLatch connectLatch = new CountDownLatch(1);
        final StallingSocketFactory stallingSocketFactory = new StallingSocketFactory(connectLatch, WaitPolicy.BEFORE_CREATE, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory());
        Scheme scheme = new Scheme("http", 80, (SchemeSocketFactory)stallingSocketFactory);
        SchemeRegistry registry = new SchemeRegistry();
        registry.register(scheme);
        PoolingClientConnectionManager mgr = new PoolingClientConnectionManager(registry);
        mgr.setMaxTotal(1);
        HttpHost target = this.getServerHttp();
        HttpRoute route = new HttpRoute(target, null, false);
        final ManagedClientConnection conn = TestPoolingConnManager.getConnection((ClientConnectionManager)mgr, route);
        final AtomicReference throwRef = new AtomicReference();
        Thread abortingThread = new Thread(new Runnable(){

            public void run() {
                try {
                    stallingSocketFactory.waitForState();
                    conn.abortConnection();
                    connectLatch.countDown();
                }
                catch (Throwable e) {
                    throwRef.set(e);
                }
            }
        });
        abortingThread.start();
        try {
            conn.open(route, (HttpContext)this.httpContext, this.defaultParams);
            Assert.fail((String)"expected exception");
        }
        catch (IOException expected) {
            Assert.assertEquals((Object)"Connection already shutdown", (Object)expected.getMessage());
        }
        abortingThread.join(5000L);
        if (throwRef.get() != null) {
            throw new RuntimeException((Throwable)throwRef.get());
        }
        Assert.assertFalse((boolean)conn.isOpen());
        Assert.assertEquals((long)0L, (long)this.localServer.getAcceptedConnectionCount());
        ManagedClientConnection conn2 = TestPoolingConnManager.getConnection((ClientConnectionManager)mgr, route, 5L, TimeUnit.SECONDS);
        Assert.assertFalse((String)"connection should have been closed", (boolean)conn2.isOpen());
        mgr.releaseConnection(conn2, -1L, null);
        mgr.shutdown();
    }

    @Test
    public void testAbortAfterSocketConnect() throws Exception {
        final CountDownLatch connectLatch = new CountDownLatch(1);
        final StallingSocketFactory stallingSocketFactory = new StallingSocketFactory(connectLatch, WaitPolicy.AFTER_CONNECT, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory());
        Scheme scheme = new Scheme("http", 80, (SchemeSocketFactory)stallingSocketFactory);
        SchemeRegistry registry = new SchemeRegistry();
        registry.register(scheme);
        PoolingClientConnectionManager mgr = new PoolingClientConnectionManager(registry);
        mgr.setMaxTotal(1);
        HttpHost target = this.getServerHttp();
        HttpRoute route = new HttpRoute(target, null, false);
        final ManagedClientConnection conn = TestPoolingConnManager.getConnection((ClientConnectionManager)mgr, route);
        final AtomicReference throwRef = new AtomicReference();
        Thread abortingThread = new Thread(new Runnable(){

            public void run() {
                try {
                    stallingSocketFactory.waitForState();
                    conn.abortConnection();
                    connectLatch.countDown();
                }
                catch (Throwable e) {
                    throwRef.set(e);
                }
            }
        });
        abortingThread.start();
        try {
            conn.open(route, (HttpContext)this.httpContext, this.defaultParams);
            Assert.fail((String)"expected SocketException");
        }
        catch (SocketException expected) {
            // empty catch block
        }
        abortingThread.join(5000L);
        if (throwRef.get() != null) {
            throw new RuntimeException((Throwable)throwRef.get());
        }
        Assert.assertFalse((boolean)conn.isOpen());
        for (int i = 0; i < 10 && this.localServer.getAcceptedConnectionCount() != 1; ++i) {
            Thread.sleep(100L);
        }
        Assert.assertEquals((long)1L, (long)this.localServer.getAcceptedConnectionCount());
        ManagedClientConnection conn2 = TestPoolingConnManager.getConnection((ClientConnectionManager)mgr, route, 5L, TimeUnit.SECONDS);
        Assert.assertFalse((String)"connection should have been closed", (boolean)conn2.isOpen());
        mgr.releaseConnection(conn2, -1L, null);
        mgr.shutdown();
    }

    @Test
    public void testAbortAfterOperatorOpen() throws Exception {
        final CountDownLatch connectLatch = new CountDownLatch(1);
        final AtomicReference operatorRef = new AtomicReference();
        PoolingClientConnectionManager mgr = new PoolingClientConnectionManager(){

            protected ClientConnectionOperator createConnectionOperator(SchemeRegistry schreg) {
                operatorRef.set(new StallingOperator(connectLatch, WaitPolicy.AFTER_OPEN, super.createConnectionOperator(schreg)));
                return (ClientConnectionOperator)operatorRef.get();
            }
        };
        mgr.setMaxTotal(1);
        Assert.assertNotNull(operatorRef.get());
        HttpHost target = this.getServerHttp();
        HttpRoute route = new HttpRoute(target, null, false);
        final ManagedClientConnection conn = TestPoolingConnManager.getConnection((ClientConnectionManager)mgr, route);
        final AtomicReference throwRef = new AtomicReference();
        Thread abortingThread = new Thread(new Runnable(){

            public void run() {
                try {
                    ((StallingOperator)operatorRef.get()).waitForState();
                    conn.abortConnection();
                    connectLatch.countDown();
                }
                catch (Throwable e) {
                    throwRef.set(e);
                }
            }
        });
        abortingThread.start();
        try {
            conn.open(route, (HttpContext)this.httpContext, this.defaultParams);
            Assert.fail((String)"expected exception");
        }
        catch (IOException iox) {
            // empty catch block
        }
        abortingThread.join(5000L);
        if (throwRef.get() != null) {
            throw new RuntimeException((Throwable)throwRef.get());
        }
        Assert.assertFalse((boolean)conn.isOpen());
        for (int i = 0; i < 10 && this.localServer.getAcceptedConnectionCount() != 1; ++i) {
            Thread.sleep(100L);
        }
        Assert.assertEquals((long)1L, (long)this.localServer.getAcceptedConnectionCount());
        ManagedClientConnection conn2 = TestPoolingConnManager.getConnection((ClientConnectionManager)mgr, route, 5L, TimeUnit.SECONDS);
        Assert.assertFalse((String)"connection should have been closed", (boolean)conn2.isOpen());
        mgr.releaseConnection(conn2, -1L, null);
        mgr.shutdown();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum WaitPolicy {
        BEFORE_CREATE,
        BEFORE_CONNECT,
        AFTER_CONNECT,
        AFTER_OPEN;

    }

    private static class StallingSocketFactory
    extends LatchSupport
    implements SchemeSocketFactory {
        private final SchemeSocketFactory delegate;

        public StallingSocketFactory(CountDownLatch continueLatch, WaitPolicy waitPolicy, SchemeSocketFactory delegate) {
            super(continueLatch, waitPolicy);
            this.delegate = delegate;
        }

        public Socket connectSocket(Socket sock, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
            if (this.waitPolicy == WaitPolicy.BEFORE_CONNECT) {
                this.latch();
            }
            Socket socket = this.delegate.connectSocket(sock, remoteAddress, localAddress, params);
            if (this.waitPolicy == WaitPolicy.AFTER_CONNECT) {
                this.latch();
            }
            return socket;
        }

        public Socket createSocket(HttpParams params) throws IOException {
            if (this.waitPolicy == WaitPolicy.BEFORE_CREATE) {
                this.latch();
            }
            return this.delegate.createSocket(params);
        }

        public boolean isSecure(Socket sock) throws IllegalArgumentException {
            return this.delegate.isSecure(sock);
        }
    }

    private static class StallingOperator
    extends LatchSupport
    implements ClientConnectionOperator {
        private final ClientConnectionOperator delegate;

        public StallingOperator(CountDownLatch continueLatch, WaitPolicy waitPolicy, ClientConnectionOperator delegate) {
            super(continueLatch, waitPolicy);
            this.delegate = delegate;
        }

        public OperatedClientConnection createConnection() {
            return this.delegate.createConnection();
        }

        public void openConnection(OperatedClientConnection conn, HttpHost target, InetAddress local, HttpContext context, HttpParams params) throws IOException {
            this.delegate.openConnection(conn, target, local, context, params);
            if (this.waitPolicy == WaitPolicy.AFTER_OPEN) {
                this.latch();
            }
        }

        public void updateSecureConnection(OperatedClientConnection conn, HttpHost target, HttpContext context, HttpParams params) throws IOException {
            this.delegate.updateSecureConnection(conn, target, context, params);
        }
    }

    private static class LatchSupport {
        private final CountDownLatch continueLatch;
        private final CountDownLatch waitLatch = new CountDownLatch(1);
        protected final WaitPolicy waitPolicy;

        LatchSupport(CountDownLatch continueLatch, WaitPolicy waitPolicy) {
            this.continueLatch = continueLatch;
            this.waitPolicy = waitPolicy;
        }

        void waitForState() throws InterruptedException {
            if (!this.waitLatch.await(1L, TimeUnit.SECONDS)) {
                throw new RuntimeException("waited too long");
            }
        }

        void latch() {
            this.waitLatch.countDown();
            try {
                if (!this.continueLatch.await(60L, TimeUnit.SECONDS)) {
                    throw new RuntimeException("waited too long!");
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

