/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn.tsccm;

import java.io.IOException;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpHost;
import org.apache.http.conn.ClientConnectionOperator;
import org.apache.http.conn.ConnectionPoolTimeoutException;
import org.apache.http.conn.OperatedClientConnection;
import org.apache.http.conn.params.ConnPerRoute;
import org.apache.http.conn.params.ConnPerRouteBean;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.conn.DefaultClientConnectionOperator;
import org.apache.http.impl.conn.tsccm.BasicPoolEntry;
import org.apache.http.impl.conn.tsccm.ConnPoolByRoute;
import org.apache.http.impl.conn.tsccm.PoolEntryRequest;
import org.apache.http.localserver.ServerTestBase;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
@Deprecated
public class TestConnPoolByRoute
extends ServerTestBase {
    private ConnPoolByRoute impl;
    private HttpRoute route = new HttpRoute(new HttpHost("localhost"));
    private HttpRoute route2 = new HttpRoute(new HttpHost("localhost:8080"));
    @Mock
    private OperatedClientConnection mockConnection;
    @Mock
    private OperatedClientConnection mockConnection2;
    @Mock
    private ClientConnectionOperator mockOperator;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.impl = new ConnPoolByRoute((ClientConnectionOperator)new DefaultClientConnectionOperator(this.supportedSchemes), (ConnPerRoute)new ConnPerRouteBean(), 1, -1L, TimeUnit.MILLISECONDS);
    }

    private void useMockOperator() {
        TestConnPoolByRoute.reset((Object[])new ClientConnectionOperator[]{this.mockOperator});
        this.impl = new ConnPoolByRoute(this.mockOperator, (ConnPerRoute)new ConnPerRouteBean(), 1, -1L, TimeUnit.MILLISECONDS);
        TestConnPoolByRoute.when((Object)this.mockOperator.createConnection()).thenReturn((Object)this.mockConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStatelessConnections() throws Exception {
        HttpHost target = this.getServerHttp();
        HttpRoute route = new HttpRoute(target, null, false);
        DefaultClientConnectionOperator operator = new DefaultClientConnectionOperator(this.supportedSchemes);
        ConnPerRouteBean connPerRoute = new ConnPerRouteBean(3);
        ConnPoolByRoute connPool = new ConnPoolByRoute((ClientConnectionOperator)operator, (ConnPerRoute)connPerRoute, 20);
        try {
            PoolEntryRequest r1 = connPool.requestPoolEntry(route, null);
            BasicPoolEntry e1 = r1.getPoolEntry(10L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)e1);
            PoolEntryRequest r2 = connPool.requestPoolEntry(route, null);
            BasicPoolEntry e2 = r2.getPoolEntry(10L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)e2);
            PoolEntryRequest r3 = connPool.requestPoolEntry(route, null);
            BasicPoolEntry e3 = r3.getPoolEntry(10L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)e3);
            PoolEntryRequest r4 = connPool.requestPoolEntry(route, null);
            try {
                r4.getPoolEntry(250L, TimeUnit.MICROSECONDS);
                Assert.fail((String)"ConnectionPoolTimeoutException should have been thrown");
            }
            catch (ConnectionPoolTimeoutException expected) {
                // empty catch block
            }
            connPool.freeEntry(e3, true, -1L, null);
            PoolEntryRequest r5 = connPool.requestPoolEntry(route, null);
            BasicPoolEntry e5 = r5.getPoolEntry(10L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)e5);
        }
        finally {
            connPool.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStatefullConnections() throws Exception {
        HttpHost target = this.getServerHttp();
        HttpRoute route = new HttpRoute(target, null, false);
        DefaultClientConnectionOperator operator = new DefaultClientConnectionOperator(this.supportedSchemes);
        ConnPerRouteBean connPerRoute = new ConnPerRouteBean(3);
        ConnPoolByRoute connPool = new ConnPoolByRoute((ClientConnectionOperator)operator, (ConnPerRoute)connPerRoute, 20);
        try {
            PoolEntryRequest r1 = connPool.requestPoolEntry(route, null);
            BasicPoolEntry e1 = r1.getPoolEntry(10L, TimeUnit.SECONDS);
            PoolEntryRequest r2 = connPool.requestPoolEntry(route, null);
            BasicPoolEntry e2 = r2.getPoolEntry(10L, TimeUnit.SECONDS);
            PoolEntryRequest r3 = connPool.requestPoolEntry(route, null);
            BasicPoolEntry e3 = r3.getPoolEntry(10L, TimeUnit.SECONDS);
            e1.setState((Object)1);
            e2.setState((Object)2);
            e3.setState((Object)3);
            connPool.freeEntry(e1, true, -1L, null);
            connPool.freeEntry(e2, true, -1L, null);
            connPool.freeEntry(e3, true, -1L, null);
            PoolEntryRequest r4 = connPool.requestPoolEntry(route, (Object)2);
            BasicPoolEntry e4 = r4.getPoolEntry(10L, TimeUnit.SECONDS);
            PoolEntryRequest r5 = connPool.requestPoolEntry(route, (Object)3);
            BasicPoolEntry e5 = r5.getPoolEntry(10L, TimeUnit.SECONDS);
            PoolEntryRequest r6 = connPool.requestPoolEntry(route, (Object)1);
            BasicPoolEntry e6 = r6.getPoolEntry(10L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)e4.getState());
            Assert.assertNotNull((Object)e5.getState());
            Assert.assertNotNull((Object)e6.getState());
            Assert.assertTrue((e4 == e2 ? 1 : 0) != 0);
            Assert.assertTrue((e5 == e3 ? 1 : 0) != 0);
            Assert.assertTrue((e6 == e1 ? 1 : 0) != 0);
            connPool.freeEntry(e4, true, -1L, null);
            connPool.freeEntry(e5, true, -1L, null);
            connPool.freeEntry(e6, true, -1L, null);
            PoolEntryRequest r7 = connPool.requestPoolEntry(route, (Object)4);
            BasicPoolEntry e7 = r7.getPoolEntry(10L, TimeUnit.SECONDS);
            Assert.assertFalse((boolean)e7.getConnection().isOpen());
            Assert.assertNull((Object)e7.getState());
        }
        finally {
            connPool.shutdown();
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void nullOperatorIsNotAllowed() {
        new ConnPoolByRoute(null, (ConnPerRoute)new ConnPerRouteBean(), 1, -1L, TimeUnit.MILLISECONDS);
    }

    @Test(expected=IllegalArgumentException.class)
    public void nullConnPerRouteIsNotAllowed() {
        new ConnPoolByRoute((ClientConnectionOperator)new DefaultClientConnectionOperator(this.supportedSchemes), null, 1, -1L, TimeUnit.MILLISECONDS);
    }

    @Test
    public void deprecatedConstructorIsStillSupported() {
        new ConnPoolByRoute((ClientConnectionOperator)new DefaultClientConnectionOperator(this.supportedSchemes), (HttpParams)new BasicHttpParams());
    }

    @Test
    public void emptyPoolHasNoConnections() {
        Assert.assertEquals((long)0L, (long)this.impl.getConnectionsInPool());
    }

    @Test
    public void poolHasOneConnectionAfterRequestingOne() throws Exception {
        this.useMockOperator();
        this.impl.requestPoolEntry(this.route, new Object()).getPoolEntry(-1L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)1L, (long)this.impl.getConnectionsInPool());
    }

    @Test
    public void emptyPoolHasNoRouteSpecificConnections() {
        Assert.assertEquals((long)0L, (long)this.impl.getConnectionsInPool(this.route));
    }

    @Test
    public void routeSpecificPoolHasOneConnectionAfterRequestingOne() throws Exception {
        this.useMockOperator();
        this.impl.requestPoolEntry(this.route, new Object()).getPoolEntry(-1L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)1L, (long)this.impl.getConnectionsInPool(this.route));
    }

    @Test
    public void abortingPoolEntryRequestEarlyDoesNotCreateConnection() {
        PoolEntryRequest req = this.impl.requestPoolEntry(this.route, new Object());
        req.abortRequest();
        Assert.assertEquals((long)0L, (long)this.impl.getConnectionsInPool(this.route));
    }

    @Test(expected=IllegalStateException.class)
    public void cannotAcquireConnectionIfPoolShutdown() throws Exception {
        this.impl.shutdown();
        this.impl.requestPoolEntry(this.route, new Object()).getPoolEntry(-1L, TimeUnit.MILLISECONDS);
    }

    @Test
    public void multipleShutdownsAreOk() {
        this.impl.shutdown();
        this.impl.shutdown();
    }

    @Test
    public void canAcquirePoolEntry() throws Exception {
        this.impl.requestPoolEntry(this.route, new Object()).getPoolEntry(-1L, TimeUnit.MILLISECONDS);
    }

    @Test
    public void canRetrieveMaxTotalConnections() {
        int max = new Random().nextInt(10) + 2;
        this.impl.setMaxTotalConnections(max);
        Assert.assertEquals((long)max, (long)this.impl.getMaxTotalConnections());
    }

    @Test
    public void closesFreedConnectionsWhenShutdown() throws Exception {
        this.useMockOperator();
        BasicPoolEntry entry = this.impl.requestPoolEntry(this.route, new Object()).getPoolEntry(-1L, TimeUnit.MILLISECONDS);
        this.impl.shutdown();
        this.impl.freeEntry(entry, true, Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        ((OperatedClientConnection)TestConnPoolByRoute.verify((Object)this.mockConnection, (VerificationMode)TestConnPoolByRoute.atLeastOnce())).close();
    }

    @Test
    public void deleteClosedConnectionsReclaimsPoolSpace() throws Exception {
        this.useMockOperator();
        BasicPoolEntry entry = this.impl.requestPoolEntry(this.route, new Object()).getPoolEntry(-1L, TimeUnit.MILLISECONDS);
        this.impl.freeEntry(entry, true, Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        Assert.assertFalse((boolean)this.impl.freeConnections.isEmpty());
        TestConnPoolByRoute.when((Object)this.mockConnection.isOpen()).thenReturn((Object)false);
        this.impl.deleteClosedConnections();
        Assert.assertTrue((boolean)this.impl.freeConnections.isEmpty());
        Assert.assertEquals((long)0L, (long)this.impl.numConnections);
    }

    @Test
    public void deleteClosedConnectionsDoesNotReclaimOpenConnections() throws Exception {
        this.useMockOperator();
        BasicPoolEntry entry = this.impl.requestPoolEntry(this.route, new Object()).getPoolEntry(-1L, TimeUnit.MILLISECONDS);
        this.impl.freeEntry(entry, true, Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        Assert.assertFalse((boolean)this.impl.freeConnections.isEmpty());
        TestConnPoolByRoute.when((Object)this.mockConnection.isOpen()).thenReturn((Object)true);
        this.impl.deleteClosedConnections();
        Assert.assertFalse((boolean)this.impl.freeConnections.isEmpty());
        Assert.assertEquals((long)1L, (long)this.impl.numConnections);
    }

    @Test
    public void closeIdleConnectionsClosesThoseThatHaveTimedOut() throws Exception {
        this.useMockOperator();
        BasicPoolEntry entry = this.impl.requestPoolEntry(this.route, new Object()).getPoolEntry(-1L, TimeUnit.MILLISECONDS);
        this.impl.freeEntry(entry, true, Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        Thread.sleep(200L);
        this.impl.closeIdleConnections(1L, TimeUnit.MILLISECONDS);
        ((OperatedClientConnection)TestConnPoolByRoute.verify((Object)this.mockConnection, (VerificationMode)TestConnPoolByRoute.atLeastOnce())).close();
    }

    @Test
    public void closeIdleConnectionsDoesNotCloseThoseThatHaveNotTimedOut() throws Exception {
        this.useMockOperator();
        BasicPoolEntry entry = this.impl.requestPoolEntry(this.route, new Object()).getPoolEntry(-1L, TimeUnit.MILLISECONDS);
        this.impl.freeEntry(entry, true, Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        this.impl.closeIdleConnections(3L, TimeUnit.SECONDS);
        ((OperatedClientConnection)TestConnPoolByRoute.verify((Object)this.mockConnection, (VerificationMode)TestConnPoolByRoute.never())).close();
    }

    @Test
    public void closeExpiredConnectionsClosesExpiredOnes() throws Exception {
        this.useMockOperator();
        BasicPoolEntry entry = this.impl.requestPoolEntry(this.route, new Object()).getPoolEntry(-1L, TimeUnit.MILLISECONDS);
        this.impl.freeEntry(entry, true, 1L, TimeUnit.MILLISECONDS);
        Thread.sleep(200L);
        this.impl.closeExpiredConnections();
        ((OperatedClientConnection)TestConnPoolByRoute.verify((Object)this.mockConnection, (VerificationMode)TestConnPoolByRoute.atLeastOnce())).close();
    }

    @Test
    public void closeExpiredConnectionsDoesNotCloseUnexpiredOnes() throws Exception {
        this.useMockOperator();
        BasicPoolEntry entry = this.impl.requestPoolEntry(this.route, new Object()).getPoolEntry(-1L, TimeUnit.MILLISECONDS);
        this.impl.freeEntry(entry, true, 10L, TimeUnit.SECONDS);
        Thread.sleep(200L);
        this.impl.closeExpiredConnections();
        ((OperatedClientConnection)TestConnPoolByRoute.verify((Object)this.mockConnection, (VerificationMode)TestConnPoolByRoute.never())).close();
    }

    @Test
    public void closesNonReusableConnections() throws Exception {
        this.useMockOperator();
        BasicPoolEntry entry = this.impl.requestPoolEntry(this.route, new Object()).getPoolEntry(-1L, TimeUnit.MILLISECONDS);
        this.impl.freeEntry(entry, false, 0L, TimeUnit.MILLISECONDS);
        ((OperatedClientConnection)TestConnPoolByRoute.verify((Object)this.mockConnection, (VerificationMode)TestConnPoolByRoute.atLeastOnce())).close();
    }

    @Test
    public void handlesExceptionsWhenClosingConnections() throws Exception {
        this.useMockOperator();
        BasicPoolEntry entry = this.impl.requestPoolEntry(this.route, new Object()).getPoolEntry(-1L, TimeUnit.MILLISECONDS);
        ((OperatedClientConnection)TestConnPoolByRoute.doThrow((Throwable)new IOException()).when((Object)this.mockConnection)).close();
        this.impl.freeEntry(entry, false, 0L, TimeUnit.MILLISECONDS);
    }

    @Test
    public void wakesUpWaitingThreadsWhenEntryAvailable() throws Exception {
        this.useMockOperator();
        TestConnPoolByRoute.when((Object)this.mockOperator.createConnection()).thenReturn((Object)this.mockConnection);
        this.impl.setMaxTotalConnections(1);
        BasicPoolEntry entry = this.impl.requestPoolEntry(this.route, new Object()).getPoolEntry(-1L, TimeUnit.MILLISECONDS);
        final Flag f = new Flag(false);
        Thread t = new Thread(new Runnable(){

            public void run() {
                try {
                    TestConnPoolByRoute.this.impl.requestPoolEntry(TestConnPoolByRoute.this.route, new Object()).getPoolEntry(-1L, TimeUnit.MILLISECONDS);
                    f.flag = true;
                }
                catch (ConnectionPoolTimeoutException e) {
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        t.start();
        Thread.sleep(100L);
        this.impl.freeEntry(entry, true, 1000L, TimeUnit.MILLISECONDS);
        Thread.sleep(100L);
        Assert.assertTrue((boolean)f.flag);
    }

    @Test
    public void wakesUpWaitingThreadsOnOtherRoutesWhenEntryAvailable() throws Exception {
        this.useMockOperator();
        TestConnPoolByRoute.when((Object)this.mockOperator.createConnection()).thenReturn((Object)this.mockConnection);
        this.impl.setMaxTotalConnections(1);
        BasicPoolEntry entry = this.impl.requestPoolEntry(this.route, new Object()).getPoolEntry(-1L, TimeUnit.MILLISECONDS);
        final Flag f = new Flag(false);
        Thread t = new Thread(new Runnable(){

            public void run() {
                try {
                    TestConnPoolByRoute.this.impl.requestPoolEntry(TestConnPoolByRoute.this.route2, new Object()).getPoolEntry(-1L, TimeUnit.MILLISECONDS);
                    f.flag = true;
                }
                catch (ConnectionPoolTimeoutException e) {
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        t.start();
        Thread.sleep(100L);
        this.impl.freeEntry(entry, true, 1000L, TimeUnit.MILLISECONDS);
        Thread.sleep(100L);
        Assert.assertTrue((boolean)f.flag);
    }

    @Test
    public void doesNotRecycleExpiredConnections() throws Exception {
        this.useMockOperator();
        TestConnPoolByRoute.when((Object)this.mockOperator.createConnection()).thenReturn((Object)this.mockConnection, (Object[])new OperatedClientConnection[]{this.mockConnection2});
        BasicPoolEntry entry = this.impl.requestPoolEntry(this.route, new Object()).getPoolEntry(-1L, TimeUnit.MILLISECONDS);
        this.impl.freeEntry(entry, true, 1L, TimeUnit.MILLISECONDS);
        Thread.sleep(200L);
        BasicPoolEntry entry2 = this.impl.requestPoolEntry(this.route, new Object()).getPoolEntry(-1L, TimeUnit.MILLISECONDS);
        Assert.assertNotSame((Object)this.mockConnection, (Object)entry2.getConnection());
    }

    @Test
    public void closesExpiredConnectionsWhenNotReusingThem() throws Exception {
        this.useMockOperator();
        TestConnPoolByRoute.when((Object)this.mockOperator.createConnection()).thenReturn((Object)this.mockConnection, (Object[])new OperatedClientConnection[]{this.mockConnection2});
        BasicPoolEntry entry = this.impl.requestPoolEntry(this.route, new Object()).getPoolEntry(-1L, TimeUnit.MILLISECONDS);
        this.impl.freeEntry(entry, true, 1L, TimeUnit.MILLISECONDS);
        Thread.sleep(200L);
        this.impl.requestPoolEntry(this.route, new Object()).getPoolEntry(-1L, TimeUnit.MILLISECONDS);
        ((OperatedClientConnection)TestConnPoolByRoute.verify((Object)this.mockConnection, (VerificationMode)TestConnPoolByRoute.atLeastOnce())).close();
    }

    @Test
    public void wakesUpWaitingThreadsOnShutdown() throws Exception {
        this.useMockOperator();
        TestConnPoolByRoute.when((Object)this.mockOperator.createConnection()).thenReturn((Object)this.mockConnection);
        TestConnPoolByRoute.when((Object)this.mockOperator.createConnection()).thenReturn((Object)this.mockConnection);
        this.impl.setMaxTotalConnections(1);
        this.impl.requestPoolEntry(this.route, new Object()).getPoolEntry(-1L, TimeUnit.MILLISECONDS);
        final Flag f = new Flag(false);
        Thread t = new Thread(new Runnable(){

            public void run() {
                try {
                    TestConnPoolByRoute.this.impl.requestPoolEntry(TestConnPoolByRoute.this.route, new Object()).getPoolEntry(-1L, TimeUnit.MILLISECONDS);
                }
                catch (IllegalStateException expected) {
                    f.flag = true;
                }
                catch (ConnectionPoolTimeoutException e) {
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        t.start();
        Thread.sleep(1L);
        this.impl.shutdown();
        Thread.sleep(1L);
        Assert.assertTrue((boolean)f.flag);
    }

    private static class Flag {
        public boolean flag;

        public Flag(boolean init) {
            this.flag = init;
        }
    }
}

