/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.conn.ssl;

import java.io.InputStream;
import java.net.URL;
import java.security.KeyStore;
import java.security.UnrecoverableKeyException;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.junit.Test;

public class TestSSLContextBuilder {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyStore load(String res, char[] passwd) throws Exception {
        KeyStore keystore = KeyStore.getInstance("jks");
        ClassLoader cl = TestSSLContextBuilder.class.getClassLoader();
        URL url = cl.getResource(res);
        InputStream instream = url.openStream();
        try {
            keystore.load(instream, passwd);
        }
        finally {
            instream.close();
        }
        return keystore;
    }

    @Test
    public void testBuildDefault() throws Exception {
        new SSLContextBuilder().build();
    }

    @Test
    public void testBuildAllNull() throws Exception {
        new SSLContextBuilder().useProtocol(null).setSecureRandom(null).loadTrustMaterial(null).loadKeyMaterial(null, null).build();
    }

    @Test
    public void testLoadTrustMultipleMaterial() throws Exception {
        KeyStore truststore1 = TestSSLContextBuilder.load("hc-test-1.truststore", "nopassword".toCharArray());
        KeyStore truststore2 = TestSSLContextBuilder.load("hc-test-2.truststore", "nopassword".toCharArray());
        new SSLContextBuilder().loadTrustMaterial(truststore1).loadTrustMaterial(truststore2).build();
    }

    @Test
    public void testKeyWithAlternatePassword() throws Exception {
        KeyStore keystore = TestSSLContextBuilder.load("test-keypasswd.keystore", "nopassword".toCharArray());
        String keyPassword = "password";
        new SSLContextBuilder().loadKeyMaterial(keystore, "password" != null ? "password".toCharArray() : null).loadTrustMaterial(keystore).build();
    }

    @Test(expected=UnrecoverableKeyException.class)
    public void testKeyWithAlternatePasswordInvalid() throws Exception {
        KeyStore keystore = TestSSLContextBuilder.load("test-keypasswd.keystore", "nopassword".toCharArray());
        String keyPassword = "!password";
        new SSLContextBuilder().loadKeyMaterial(keystore, "!password" != null ? "!password".toCharArray() : null).loadTrustMaterial(keystore).build();
    }
}

