/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn;

import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.SchemePortResolver;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.conn.DefaultRoutePlanner;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestDefaultRoutePlanner {
    private SchemePortResolver schemePortResolver;
    private DefaultRoutePlanner routePlanner;

    @Before
    public void setup() {
        this.schemePortResolver = (SchemePortResolver)Mockito.mock(SchemePortResolver.class);
        this.routePlanner = new DefaultRoutePlanner(this.schemePortResolver);
    }

    @Test
    public void testDirect() throws Exception {
        HttpHost target = new HttpHost("somehost", 80, "http");
        BasicHttpRequest request = new BasicHttpRequest("GET", "/", (ProtocolVersion)HttpVersion.HTTP_1_1);
        BasicHttpContext context = new BasicHttpContext();
        HttpRoute route = this.routePlanner.determineRoute(target, (HttpRequest)request, (HttpContext)context);
        Assert.assertEquals((Object)target, (Object)route.getTargetHost());
        Assert.assertEquals((long)1L, (long)route.getHopCount());
        Assert.assertFalse((boolean)route.isSecure());
        ((SchemePortResolver)Mockito.verify((Object)this.schemePortResolver, (VerificationMode)Mockito.never())).resolve((HttpHost)Mockito.any());
    }

    @Test
    public void testDirectDefaultPort() throws Exception {
        HttpHost target = new HttpHost("somehost", -1, "https");
        Mockito.when((Object)this.schemePortResolver.resolve(target)).thenReturn((Object)443);
        BasicHttpRequest request = new BasicHttpRequest("GET", "/", (ProtocolVersion)HttpVersion.HTTP_1_1);
        BasicHttpContext context = new BasicHttpContext();
        HttpRoute route = this.routePlanner.determineRoute(target, (HttpRequest)request, (HttpContext)context);
        Assert.assertEquals((Object)new HttpHost("somehost", 443, "https"), (Object)route.getTargetHost());
        Assert.assertEquals((long)1L, (long)route.getHopCount());
        Assert.assertTrue((boolean)route.isSecure());
    }

    @Test
    public void testViaProxy() throws Exception {
        HttpHost target = new HttpHost("somehost", 80, "http");
        HttpHost proxy = new HttpHost("proxy", 8080);
        BasicHttpRequest request = new BasicHttpRequest("GET", "/", (ProtocolVersion)HttpVersion.HTTP_1_1);
        HttpClientContext context = HttpClientContext.create();
        context.setRequestConfig(RequestConfig.custom().setProxy(proxy).build());
        HttpRoute route = this.routePlanner.determineRoute(target, (HttpRequest)request, (HttpContext)context);
        Assert.assertEquals((Object)target, (Object)route.getTargetHost());
        Assert.assertEquals((Object)proxy, (Object)route.getProxyHost());
        Assert.assertEquals((long)2L, (long)route.getHopCount());
        Assert.assertFalse((boolean)route.isSecure());
        ((SchemePortResolver)Mockito.verify((Object)this.schemePortResolver, (VerificationMode)Mockito.never())).resolve((HttpHost)Mockito.any());
    }
}

