/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.execchain;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import org.apache.http.HttpEntity;
import org.apache.http.impl.execchain.ConnectionHolder;
import org.apache.http.impl.execchain.ResponseEntityWrapper;
import org.apache.http.util.EntityUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestResponseEntityWrapper {
    private InputStream instream;
    private HttpEntity entity;
    private ConnectionHolder connHolder;
    private ResponseEntityWrapper wrapper;

    @Before
    public void setup() throws Exception {
        this.instream = (InputStream)Mockito.mock(InputStream.class);
        this.entity = (HttpEntity)Mockito.mock(HttpEntity.class);
        Mockito.when((Object)this.entity.getContent()).thenReturn((Object)this.instream);
        this.connHolder = (ConnectionHolder)Mockito.mock(ConnectionHolder.class);
        this.wrapper = new ResponseEntityWrapper(this.entity, this.connHolder);
    }

    @Test
    public void testReusableEntityStreamClosed() throws Exception {
        Mockito.when((Object)this.entity.isStreaming()).thenReturn((Object)true);
        Mockito.when((Object)this.connHolder.isReusable()).thenReturn((Object)true);
        EntityUtils.consume((HttpEntity)this.wrapper);
        ((InputStream)Mockito.verify((Object)this.instream, (VerificationMode)Mockito.times((int)1))).close();
        ((ConnectionHolder)Mockito.verify((Object)this.connHolder)).releaseConnection();
    }

    @Test
    public void testReusableEntityStreamClosedIOError() throws Exception {
        Mockito.when((Object)this.entity.isStreaming()).thenReturn((Object)true);
        Mockito.when((Object)this.connHolder.isReusable()).thenReturn((Object)true);
        ((InputStream)Mockito.doThrow((Throwable)new IOException()).when((Object)this.instream)).close();
        try {
            EntityUtils.consume((HttpEntity)this.wrapper);
            Assert.fail((String)"IOException expected");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ((ConnectionHolder)Mockito.verify((Object)this.connHolder)).abortConnection();
    }

    @Test
    public void testEntityStreamClosedIOErrorAlreadyReleased() throws Exception {
        Mockito.when((Object)this.entity.isStreaming()).thenReturn((Object)true);
        Mockito.when((Object)this.connHolder.isReusable()).thenReturn((Object)true);
        Mockito.when((Object)this.connHolder.isReleased()).thenReturn((Object)true);
        ((InputStream)Mockito.doThrow((Throwable)new SocketException()).when((Object)this.instream)).close();
        EntityUtils.consume((HttpEntity)this.wrapper);
        ((ConnectionHolder)Mockito.verify((Object)this.connHolder)).abortConnection();
    }

    @Test
    public void testReusableEntityWriteTo() throws Exception {
        OutputStream outstream = (OutputStream)Mockito.mock(OutputStream.class);
        Mockito.when((Object)this.entity.isStreaming()).thenReturn((Object)true);
        Mockito.when((Object)this.connHolder.isReusable()).thenReturn((Object)true);
        this.wrapper.writeTo(outstream);
        ((ConnectionHolder)Mockito.verify((Object)this.connHolder)).releaseConnection();
    }

    @Test
    public void testReusableEntityWriteToIOError() throws Exception {
        OutputStream outstream = (OutputStream)Mockito.mock(OutputStream.class);
        Mockito.when((Object)this.entity.isStreaming()).thenReturn((Object)true);
        Mockito.when((Object)this.connHolder.isReusable()).thenReturn((Object)true);
        ((HttpEntity)Mockito.doThrow((Throwable)new IOException()).when((Object)this.entity)).writeTo(outstream);
        try {
            this.wrapper.writeTo(outstream);
            Assert.fail((String)"IOException expected");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ((ConnectionHolder)Mockito.verify((Object)this.connHolder, (VerificationMode)Mockito.never())).releaseConnection();
        ((ConnectionHolder)Mockito.verify((Object)this.connHolder)).abortConnection();
    }

    @Test
    public void testReusableEntityEndOfStream() throws Exception {
        Mockito.when((Object)this.instream.read()).thenReturn((Object)-1);
        Mockito.when((Object)this.entity.isStreaming()).thenReturn((Object)true);
        Mockito.when((Object)this.connHolder.isReusable()).thenReturn((Object)true);
        InputStream content = this.wrapper.getContent();
        Assert.assertEquals((long)-1L, (long)content.read());
        ((InputStream)Mockito.verify((Object)this.instream)).close();
        ((ConnectionHolder)Mockito.verify((Object)this.connHolder)).releaseConnection();
    }

    @Test
    public void testReusableEntityEndOfStreamIOError() throws Exception {
        Mockito.when((Object)this.instream.read()).thenReturn((Object)-1);
        Mockito.when((Object)this.entity.isStreaming()).thenReturn((Object)true);
        Mockito.when((Object)this.connHolder.isReusable()).thenReturn((Object)true);
        ((InputStream)Mockito.doThrow((Throwable)new IOException()).when((Object)this.instream)).close();
        InputStream content = this.wrapper.getContent();
        try {
            content.read();
            Assert.fail((String)"IOException expected");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ((ConnectionHolder)Mockito.verify((Object)this.connHolder)).abortConnection();
    }
}

