/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.localserver;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpResponseFactory;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.HttpServerConnection;
import org.apache.http.impl.DefaultBHttpServerConnection;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.DefaultHttpResponseFactory;
import org.apache.http.localserver.EchoHandler;
import org.apache.http.localserver.RandomHandler;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpExpectationVerifier;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.protocol.HttpRequestHandlerMapper;
import org.apache.http.protocol.HttpService;
import org.apache.http.protocol.ImmutableHttpProcessor;
import org.apache.http.protocol.ResponseConnControl;
import org.apache.http.protocol.ResponseContent;
import org.apache.http.protocol.ResponseDate;
import org.apache.http.protocol.ResponseServer;
import org.apache.http.protocol.UriHttpRequestHandlerMapper;
import org.apache.http.util.Asserts;

public class LocalTestServer {
    public static final String ORIGIN = "LocalTestServer/1.1";
    public static final InetSocketAddress TEST_SERVER_ADDR = new InetSocketAddress("127.0.0.1", 0);
    private final UriHttpRequestHandlerMapper handlerRegistry;
    private final HttpService httpservice;
    private final SSLContext sslcontext;
    private final boolean forceSSLAuth;
    private volatile ServerSocket servicedSocket;
    private volatile ListenerThread listenerThread;
    private final Set<Worker> workers;
    private final AtomicInteger acceptedConnections = new AtomicInteger(0);
    private volatile int timeout;

    public LocalTestServer(HttpProcessor proc, ConnectionReuseStrategy reuseStrat, HttpResponseFactory responseFactory, HttpExpectationVerifier expectationVerifier, SSLContext sslcontext, boolean forceSSLAuth) {
        this.handlerRegistry = new UriHttpRequestHandlerMapper();
        this.workers = Collections.synchronizedSet(new HashSet());
        this.httpservice = new HttpService(proc != null ? proc : this.newProcessor(), reuseStrat != null ? reuseStrat : this.newConnectionReuseStrategy(), responseFactory != null ? responseFactory : this.newHttpResponseFactory(), (HttpRequestHandlerMapper)this.handlerRegistry, expectationVerifier);
        this.sslcontext = sslcontext;
        this.forceSSLAuth = forceSSLAuth;
    }

    public LocalTestServer(HttpProcessor proc, ConnectionReuseStrategy reuseStrat) {
        this(proc, reuseStrat, null, null, null, false);
    }

    public LocalTestServer(SSLContext sslcontext, boolean forceSSLAuth) {
        this(null, null, null, null, sslcontext, forceSSLAuth);
    }

    public LocalTestServer(SSLContext sslcontext) {
        this(null, null, null, null, sslcontext, false);
    }

    protected HttpProcessor newProcessor() {
        return new ImmutableHttpProcessor(new HttpResponseInterceptor[]{new ResponseDate(), new ResponseServer(ORIGIN), new ResponseContent(), new ResponseConnControl()});
    }

    protected ConnectionReuseStrategy newConnectionReuseStrategy() {
        return DefaultConnectionReuseStrategy.INSTANCE;
    }

    protected HttpResponseFactory newHttpResponseFactory() {
        return DefaultHttpResponseFactory.INSTANCE;
    }

    public int getAcceptedConnectionCount() {
        return this.acceptedConnections.get();
    }

    public void registerDefaultHandlers() {
        this.handlerRegistry.register("/echo/*", (HttpRequestHandler)new EchoHandler());
        this.handlerRegistry.register("/random/*", (HttpRequestHandler)new RandomHandler());
    }

    public void register(String pattern, HttpRequestHandler handler) {
        this.handlerRegistry.register(pattern, handler);
    }

    public void unregister(String pattern) {
        this.handlerRegistry.unregister(pattern);
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void start() throws Exception {
        ServerSocket ssock;
        Asserts.check((this.servicedSocket == null ? 1 : 0) != 0, (String)"Already running");
        if (this.sslcontext != null) {
            SSLServerSocketFactory sf = this.sslcontext.getServerSocketFactory();
            SSLServerSocket sslsock = (SSLServerSocket)sf.createServerSocket();
            if (this.forceSSLAuth) {
                sslsock.setNeedClientAuth(true);
            } else {
                sslsock.setWantClientAuth(true);
            }
            ssock = sslsock;
        } else {
            ssock = new ServerSocket();
        }
        ssock.setReuseAddress(true);
        ssock.bind(TEST_SERVER_ADDR);
        this.servicedSocket = ssock;
        this.listenerThread = new ListenerThread();
        this.listenerThread.setDaemon(false);
        this.listenerThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws Exception {
        if (this.servicedSocket == null) {
            return;
        }
        ListenerThread t = this.listenerThread;
        if (t != null) {
            t.shutdown();
        }
        Set<Worker> set = this.workers;
        synchronized (set) {
            for (Worker worker : this.workers) {
                worker.shutdown();
            }
        }
    }

    public void awaitTermination(long timeMs) throws InterruptedException {
        if (this.listenerThread != null) {
            this.listenerThread.join(timeMs);
        }
    }

    public String toString() {
        ServerSocket ssock = this.servicedSocket;
        StringBuilder sb = new StringBuilder(80);
        sb.append("LocalTestServer/");
        if (ssock == null) {
            sb.append("stopped");
        } else {
            sb.append(ssock.getLocalSocketAddress());
        }
        return sb.toString();
    }

    public InetSocketAddress getServiceAddress() {
        ServerSocket ssock = this.servicedSocket;
        Asserts.check((ssock != null ? 1 : 0) != 0, (String)"Not running");
        return (InetSocketAddress)ssock.getLocalSocketAddress();
    }

    protected DefaultBHttpServerConnection createHttpServerConnection() {
        return new DefaultBHttpServerConnection(8192);
    }

    class Worker
    extends Thread {
        private final HttpServerConnection conn;
        private volatile Exception exception;

        public Worker(HttpServerConnection conn) {
            this.conn = conn;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            BasicHttpContext context = new BasicHttpContext();
            try {
                while (this.conn.isOpen() && !Thread.interrupted()) {
                    LocalTestServer.this.httpservice.handleRequest(this.conn, (HttpContext)context);
                }
            }
            catch (Exception ex) {
                this.exception = ex;
            }
            finally {
                LocalTestServer.this.workers.remove(this);
                try {
                    this.conn.shutdown();
                }
                catch (IOException iOException) {}
            }
        }

        public void shutdown() {
            this.interrupt();
            try {
                this.conn.shutdown();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public Exception getException() {
            return this.exception;
        }
    }

    class ListenerThread
    extends Thread {
        private volatile Exception exception;

        ListenerThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (!ListenerThread.interrupted()) {
                    Socket socket = LocalTestServer.this.servicedSocket.accept();
                    LocalTestServer.this.acceptedConnections.incrementAndGet();
                    DefaultBHttpServerConnection conn = LocalTestServer.this.createHttpServerConnection();
                    conn.bind(socket);
                    conn.setSocketTimeout(LocalTestServer.this.timeout);
                    Worker worker = new Worker((HttpServerConnection)conn);
                    LocalTestServer.this.workers.add(worker);
                    worker.setDaemon(true);
                    worker.start();
                }
            }
            catch (Exception ex) {
                this.exception = ex;
            }
            finally {
                try {
                    LocalTestServer.this.servicedSocket.close();
                }
                catch (IOException iOException) {}
            }
        }

        public void shutdown() {
            this.interrupt();
            try {
                LocalTestServer.this.servicedSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public Exception getException() {
            return this.exception;
        }
    }
}

