/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.cookie;

import java.util.ArrayList;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.cookie.SetCookie2;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.impl.cookie.BasicClientCookie2;
import org.apache.http.impl.cookie.BestMatchSpec;
import org.apache.http.message.BasicHeader;
import org.junit.Assert;
import org.junit.Test;

public class TestCookieBestMatchSpec {
    @Test
    public void testCookieBrowserCompatParsing() throws Exception {
        BestMatchSpec cookiespec = new BestMatchSpec();
        CookieOrigin origin = new CookieOrigin("a.b.domain.com", 80, "/", false);
        BasicHeader header = new BasicHeader("Set-Cookie", "name=value;path=/;domain=domain.com");
        List cookies = cookiespec.parse((Header)header, origin);
        for (int i = 0; i < cookies.size(); ++i) {
            cookiespec.validate((Cookie)cookies.get(i), origin);
        }
    }

    @Test
    public void testNetscapeCookieParsing() throws Exception {
        BestMatchSpec cookiespec = new BestMatchSpec();
        CookieOrigin origin = new CookieOrigin("myhost.mydomain.com", 80, "/", false);
        BasicHeader header = new BasicHeader("Set-Cookie", "name=value; path=/; domain=.mydomain.com; expires=Thu, 01-Jan-2070 00:00:10 GMT; comment=no_comment");
        List cookies = cookiespec.parse((Header)header, origin);
        cookiespec.validate((Cookie)cookies.get(0), origin);
        Assert.assertEquals((long)1L, (long)cookies.size());
        header = new BasicHeader("Set-Cookie", "name=value; path=/; domain=.mydomain.com; expires=Thu, 01-Jan-2070 00:00:10 GMT; version=1");
        cookies = cookiespec.parse((Header)header, origin);
        cookiespec.validate((Cookie)cookies.get(0), origin);
        Assert.assertEquals((long)1L, (long)cookies.size());
    }

    @Test
    public void testCookieStandardCompliantParsing() throws Exception {
        int i;
        BestMatchSpec cookiespec = new BestMatchSpec();
        CookieOrigin origin = new CookieOrigin("a.b.domain.com", 80, "/", false);
        BasicHeader header = new BasicHeader("Set-Cookie2", "name=value;path=/;domain=b.domain.com; version=1");
        List cookies = cookiespec.parse((Header)header, origin);
        for (i = 0; i < cookies.size(); ++i) {
            cookiespec.validate((Cookie)cookies.get(i), origin);
        }
        header = new BasicHeader("Set-Cookie", "name=value;path=/;domain=.b.domain.com; version=1");
        cookies = cookiespec.parse((Header)header, origin);
        for (i = 0; i < cookies.size(); ++i) {
            cookiespec.validate((Cookie)cookies.get(i), origin);
        }
        header = new BasicHeader("Set-Cookie2", "name=value;path=/;domain=domain.com; version=1");
        try {
            cookies = cookiespec.parse((Header)header, origin);
            cookiespec.validate((Cookie)cookies.get(0), origin);
            Assert.fail((String)"MalformedCookieException exception should have been thrown");
        }
        catch (MalformedCookieException e) {
            // empty catch block
        }
    }

    @Test
    public void testCookieStandardCompliantParsingLocalHost() throws Exception {
        BestMatchSpec cookiespec = new BestMatchSpec();
        CookieOrigin origin = new CookieOrigin("localhost", 80, "/", false);
        BasicHeader header = new BasicHeader("Set-Cookie", "special=\"abcdigh\"; Version=1");
        List cookies = cookiespec.parse((Header)header, origin);
        for (int i = 0; i < cookies.size(); ++i) {
            Cookie cookie = (Cookie)cookies.get(i);
            cookiespec.validate(cookie, origin);
            Assert.assertEquals((Object)"localhost", (Object)cookie.getDomain());
            Assert.assertFalse((boolean)(cookie instanceof SetCookie2));
        }
    }

    @Test
    public void testCookieStandardCompliantParsingLocalHost2() throws Exception {
        BestMatchSpec cookiespec = new BestMatchSpec();
        CookieOrigin origin = new CookieOrigin("localhost", 80, "/", false);
        BasicHeader header = new BasicHeader("Set-Cookie2", "special=\"abcdigh\"; Version=1");
        List cookies = cookiespec.parse((Header)header, origin);
        for (int i = 0; i < cookies.size(); ++i) {
            Cookie cookie = (Cookie)cookies.get(i);
            cookiespec.validate(cookie, origin);
            Assert.assertEquals((Object)"localhost.local", (Object)cookie.getDomain());
            Assert.assertTrue((boolean)(cookie instanceof SetCookie2));
        }
    }

    @Test
    public void testCookieBrowserCompatMatch() throws Exception {
        BestMatchSpec cookiespec = new BestMatchSpec();
        CookieOrigin origin = new CookieOrigin("a.b.domain.com", 80, "/", false);
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        cookie.setDomain(".domain.com");
        cookie.setAttribute("domain", cookie.getDomain());
        cookie.setPath("/");
        cookie.setAttribute("path", cookie.getPath());
        Assert.assertTrue((boolean)cookiespec.match((Cookie)cookie, origin));
    }

    @Test
    public void testCookieStandardCompliantMatch() throws Exception {
        BestMatchSpec cookiespec = new BestMatchSpec();
        CookieOrigin origin = new CookieOrigin("a.b.domain.com", 80, "/", false);
        BasicClientCookie2 cookie = new BasicClientCookie2("name", "value");
        cookie.setVersion(1);
        cookie.setDomain(".domain.com");
        cookie.setAttribute("domain", cookie.getDomain());
        cookie.setPath("/");
        cookie.setAttribute("path", cookie.getPath());
        Assert.assertFalse((boolean)cookiespec.match((Cookie)cookie, origin));
        cookie.setDomain(".b.domain.com");
        Assert.assertTrue((boolean)cookiespec.match((Cookie)cookie, origin));
    }

    @Test
    public void testCookieBrowserCompatFormatting() throws Exception {
        BestMatchSpec cookiespec = new BestMatchSpec();
        BasicClientCookie cookie1 = new BasicClientCookie("name1", "value1");
        cookie1.setDomain(".domain.com");
        cookie1.setAttribute("domain", cookie1.getDomain());
        cookie1.setPath("/");
        cookie1.setAttribute("path", cookie1.getPath());
        BasicClientCookie cookie2 = new BasicClientCookie("name2", "value2");
        cookie2.setVersion(1);
        cookie2.setDomain(".domain.com");
        cookie2.setAttribute("domain", cookie2.getDomain());
        cookie2.setPath("/");
        cookie2.setAttribute("path", cookie2.getPath());
        ArrayList<BasicClientCookie> cookies = new ArrayList<BasicClientCookie>();
        cookies.add(cookie1);
        cookies.add(cookie2);
        List headers = cookiespec.formatCookies(cookies);
        Assert.assertNotNull((Object)headers);
        Assert.assertEquals((long)1L, (long)headers.size());
        Header header = (Header)headers.get(0);
        Assert.assertEquals((Object)"name1=value1; name2=value2", (Object)header.getValue());
    }

    @Test
    public void testCookieStandardCompliantFormatting() throws Exception {
        BestMatchSpec cookiespec = new BestMatchSpec(null, true);
        BasicClientCookie cookie1 = new BasicClientCookie("name1", "value1");
        cookie1.setVersion(1);
        cookie1.setDomain(".domain.com");
        cookie1.setAttribute("domain", cookie1.getDomain());
        cookie1.setPath("/");
        cookie1.setAttribute("path", cookie1.getPath());
        BasicClientCookie cookie2 = new BasicClientCookie("name2", "value2");
        cookie2.setVersion(1);
        cookie2.setDomain(".domain.com");
        cookie2.setAttribute("domain", cookie2.getDomain());
        cookie2.setPath("/");
        cookie2.setAttribute("path", cookie2.getPath());
        ArrayList<BasicClientCookie> cookies = new ArrayList<BasicClientCookie>();
        cookies.add(cookie1);
        cookies.add(cookie2);
        List headers = cookiespec.formatCookies(cookies);
        Assert.assertNotNull((Object)headers);
        Assert.assertEquals((long)1L, (long)headers.size());
        Header header = (Header)headers.get(0);
        Assert.assertEquals((Object)"$Version=1; name1=\"value1\"; $Path=\"/\"; $Domain=\".domain.com\"; name2=\"value2\"; $Path=\"/\"; $Domain=\".domain.com\"", (Object)header.getValue());
    }

    @Test
    public void testInvalidInput() throws Exception {
        BestMatchSpec cookiespec = new BestMatchSpec();
        try {
            cookiespec.parse(null, null);
            Assert.fail((String)"IllegalArgumentException must have been thrown");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            cookiespec.parse((Header)new BasicHeader("Set-Cookie", "name=value"), null);
            Assert.fail((String)"IllegalArgumentException must have been thrown");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            cookiespec.formatCookies(null);
            Assert.fail((String)"IllegalArgumentException must have been thrown");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            ArrayList cookies = new ArrayList();
            cookiespec.formatCookies(cookies);
            Assert.fail((String)"IllegalArgumentException must have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

