/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.protocol;

import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthProtocolState;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.protocol.RequestAuthCache;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.protocol.HttpContext;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestRequestAuthCache {
    private HttpHost target;
    private HttpHost proxy;
    private Credentials creds1;
    private Credentials creds2;
    private AuthScope authscope1;
    private AuthScope authscope2;
    private BasicScheme authscheme1;
    private BasicScheme authscheme2;
    private BasicCredentialsProvider credProvider;
    private AuthState targetState;
    private AuthState proxyState;

    @Before
    public void setUp() {
        this.target = new HttpHost("localhost", 80);
        this.proxy = new HttpHost("localhost", 8080);
        this.credProvider = new BasicCredentialsProvider();
        this.creds1 = new UsernamePasswordCredentials("user1", "secret1");
        this.creds2 = new UsernamePasswordCredentials("user2", "secret2");
        this.authscope1 = new AuthScope(this.target);
        this.authscope2 = new AuthScope(this.proxy);
        this.authscheme1 = new BasicScheme();
        this.authscheme2 = new BasicScheme();
        this.credProvider.setCredentials(this.authscope1, this.creds1);
        this.credProvider.setCredentials(this.authscope2, this.creds2);
        this.targetState = new AuthState();
        this.proxyState = new AuthState();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRequestParameterCheck() throws Exception {
        HttpClientContext context = HttpClientContext.create();
        RequestAuthCache interceptor = new RequestAuthCache();
        interceptor.process(null, (HttpContext)context);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testContextParameterCheck() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        RequestAuthCache interceptor = new RequestAuthCache();
        interceptor.process((HttpRequest)request, null);
    }

    @Test
    public void testPreemptiveTargetAndProxyAuth() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        HttpClientContext context = HttpClientContext.create();
        context.setAttribute("http.auth.credentials-provider", (Object)this.credProvider);
        context.setAttribute("http.target_host", (Object)this.target);
        context.setAttribute("http.route", (Object)new HttpRoute(this.target, null, this.proxy, false));
        context.setAttribute("http.auth.target-scope", (Object)this.targetState);
        context.setAttribute("http.auth.proxy-scope", (Object)this.proxyState);
        BasicAuthCache authCache = new BasicAuthCache();
        authCache.put(this.target, (AuthScheme)this.authscheme1);
        authCache.put(this.proxy, (AuthScheme)this.authscheme2);
        context.setAttribute("http.auth.auth-cache", (Object)authCache);
        RequestAuthCache interceptor = new RequestAuthCache();
        interceptor.process((HttpRequest)request, (HttpContext)context);
        Assert.assertSame((Object)this.authscheme1, (Object)this.targetState.getAuthScheme());
        Assert.assertSame((Object)this.creds1, (Object)this.targetState.getCredentials());
        Assert.assertSame((Object)this.authscheme2, (Object)this.proxyState.getAuthScheme());
        Assert.assertSame((Object)this.creds2, (Object)this.proxyState.getCredentials());
    }

    @Test
    public void testCredentialsProviderNotSet() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        HttpClientContext context = HttpClientContext.create();
        context.setAttribute("http.auth.credentials-provider", null);
        context.setAttribute("http.target_host", (Object)this.target);
        context.setAttribute("http.route", (Object)new HttpRoute(this.target, null, this.proxy, false));
        context.setAttribute("http.auth.target-scope", (Object)this.targetState);
        context.setAttribute("http.auth.proxy-scope", (Object)this.proxyState);
        BasicAuthCache authCache = new BasicAuthCache();
        authCache.put(this.target, (AuthScheme)this.authscheme1);
        authCache.put(this.proxy, (AuthScheme)this.authscheme2);
        context.setAttribute("http.auth.auth-cache", (Object)authCache);
        RequestAuthCache interceptor = new RequestAuthCache();
        interceptor.process((HttpRequest)request, (HttpContext)context);
        Assert.assertNull((Object)this.targetState.getAuthScheme());
        Assert.assertNull((Object)this.targetState.getCredentials());
        Assert.assertNull((Object)this.proxyState.getAuthScheme());
        Assert.assertNull((Object)this.proxyState.getCredentials());
    }

    @Test
    public void testAuthCacheNotSet() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        HttpClientContext context = HttpClientContext.create();
        context.setAttribute("http.auth.credentials-provider", (Object)this.credProvider);
        context.setAttribute("http.target_host", (Object)this.target);
        context.setAttribute("http.route", (Object)new HttpRoute(this.target, null, this.proxy, false));
        context.setAttribute("http.auth.target-scope", (Object)this.targetState);
        context.setAttribute("http.auth.proxy-scope", (Object)this.proxyState);
        context.setAttribute("http.auth.auth-cache", null);
        RequestAuthCache interceptor = new RequestAuthCache();
        interceptor.process((HttpRequest)request, (HttpContext)context);
        Assert.assertNull((Object)this.targetState.getAuthScheme());
        Assert.assertNull((Object)this.targetState.getCredentials());
        Assert.assertNull((Object)this.proxyState.getAuthScheme());
        Assert.assertNull((Object)this.proxyState.getCredentials());
    }

    @Test
    public void testAuthCacheEmpty() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        HttpClientContext context = HttpClientContext.create();
        context.setAttribute("http.auth.credentials-provider", (Object)this.credProvider);
        context.setAttribute("http.target_host", (Object)this.target);
        context.setAttribute("http.route", (Object)new HttpRoute(this.target, null, this.proxy, false));
        context.setAttribute("http.auth.target-scope", (Object)this.targetState);
        context.setAttribute("http.auth.proxy-scope", (Object)this.proxyState);
        BasicAuthCache authCache = new BasicAuthCache();
        context.setAttribute("http.auth.auth-cache", (Object)authCache);
        RequestAuthCache interceptor = new RequestAuthCache();
        interceptor.process((HttpRequest)request, (HttpContext)context);
        Assert.assertNull((Object)this.targetState.getAuthScheme());
        Assert.assertNull((Object)this.targetState.getCredentials());
        Assert.assertNull((Object)this.proxyState.getAuthScheme());
        Assert.assertNull((Object)this.proxyState.getCredentials());
    }

    @Test
    public void testNoMatchingCredentials() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        this.credProvider.clear();
        HttpClientContext context = HttpClientContext.create();
        context.setAttribute("http.auth.credentials-provider", (Object)this.credProvider);
        context.setAttribute("http.target_host", (Object)this.target);
        context.setAttribute("http.route", (Object)new HttpRoute(this.target, null, this.proxy, false));
        context.setAttribute("http.auth.target-scope", (Object)this.targetState);
        context.setAttribute("http.auth.proxy-scope", (Object)this.proxyState);
        BasicAuthCache authCache = new BasicAuthCache();
        authCache.put(this.target, (AuthScheme)this.authscheme1);
        authCache.put(this.proxy, (AuthScheme)this.authscheme2);
        context.setAttribute("http.auth.auth-cache", (Object)authCache);
        RequestAuthCache interceptor = new RequestAuthCache();
        interceptor.process((HttpRequest)request, (HttpContext)context);
        Assert.assertNull((Object)this.targetState.getAuthScheme());
        Assert.assertNull((Object)this.targetState.getCredentials());
        Assert.assertNull((Object)this.proxyState.getAuthScheme());
        Assert.assertNull((Object)this.proxyState.getCredentials());
    }

    @Test
    public void testAuthSchemeAlreadySet() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        HttpClientContext context = HttpClientContext.create();
        context.setAttribute("http.auth.credentials-provider", (Object)this.credProvider);
        context.setAttribute("http.target_host", (Object)this.target);
        context.setAttribute("http.route", (Object)new HttpRoute(this.target, null, this.proxy, false));
        context.setAttribute("http.auth.target-scope", (Object)this.targetState);
        context.setAttribute("http.auth.proxy-scope", (Object)this.proxyState);
        BasicAuthCache authCache = new BasicAuthCache();
        authCache.put(this.target, (AuthScheme)this.authscheme1);
        authCache.put(this.proxy, (AuthScheme)this.authscheme2);
        context.setAttribute("http.auth.auth-cache", (Object)authCache);
        this.targetState.setState(AuthProtocolState.CHALLENGED);
        this.targetState.update((AuthScheme)new BasicScheme(), (Credentials)new UsernamePasswordCredentials("user3", "secret3"));
        this.proxyState.setState(AuthProtocolState.CHALLENGED);
        this.proxyState.update((AuthScheme)new BasicScheme(), (Credentials)new UsernamePasswordCredentials("user4", "secret4"));
        RequestAuthCache interceptor = new RequestAuthCache();
        interceptor.process((HttpRequest)request, (HttpContext)context);
        Assert.assertNotSame((Object)this.authscheme1, (Object)this.targetState.getAuthScheme());
        Assert.assertNotSame((Object)this.creds1, (Object)this.targetState.getCredentials());
        Assert.assertNotSame((Object)this.authscheme2, (Object)this.proxyState.getAuthScheme());
        Assert.assertNotSame((Object)this.creds2, (Object)this.proxyState.getCredentials());
    }
}

