/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.entity;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.Checksum;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.DecompressingEntity;
import org.apache.http.client.entity.InputStreamFactory;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestDecompressingEntity {
    @Test
    public void testNonStreaming() throws Exception {
        CRC32 crc32 = new CRC32();
        StringEntity wrapped = new StringEntity("1234567890", "ASCII");
        ChecksumEntity entity = new ChecksumEntity((HttpEntity)wrapped, crc32);
        Assert.assertFalse((boolean)entity.isStreaming());
        String s = EntityUtils.toString((HttpEntity)entity);
        Assert.assertEquals((Object)"1234567890", (Object)s);
        Assert.assertEquals((long)639479525L, (long)crc32.getValue());
        InputStream in1 = entity.getContent();
        InputStream in2 = entity.getContent();
        Assert.assertTrue((in1 != in2 ? 1 : 0) != 0);
    }

    @Test
    public void testStreaming() throws Exception {
        CRC32 crc32 = new CRC32();
        ByteArrayInputStream in = new ByteArrayInputStream("1234567890".getBytes(Consts.ASCII));
        InputStreamEntity wrapped = new InputStreamEntity((InputStream)in, -1L);
        ChecksumEntity entity = new ChecksumEntity((HttpEntity)wrapped, crc32);
        Assert.assertTrue((boolean)entity.isStreaming());
        String s = EntityUtils.toString((HttpEntity)entity);
        Assert.assertEquals((Object)"1234567890", (Object)s);
        Assert.assertEquals((long)639479525L, (long)crc32.getValue());
        InputStream in1 = entity.getContent();
        InputStream in2 = entity.getContent();
        Assert.assertTrue((in1 == in2 ? 1 : 0) != 0);
        EntityUtils.consume((HttpEntity)entity);
        EntityUtils.consume((HttpEntity)entity);
    }

    @Test
    public void testWriteToStream() throws Exception {
        CRC32 crc32 = new CRC32();
        StringEntity wrapped = new StringEntity("1234567890", "ASCII");
        ChecksumEntity entity = new ChecksumEntity((HttpEntity)wrapped, crc32);
        Assert.assertFalse((boolean)entity.isStreaming());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        entity.writeTo(out);
        String s = new String(out.toByteArray(), "ASCII");
        Assert.assertEquals((Object)"1234567890", (Object)s);
        Assert.assertEquals((long)639479525L, (long)crc32.getValue());
    }

    static class ChecksumEntity
    extends DecompressingEntity {
        public ChecksumEntity(HttpEntity wrapped, final Checksum checksum) {
            super(wrapped, new InputStreamFactory(){

                public InputStream create(InputStream instream) throws IOException {
                    return new CheckedInputStream(instream, checksum);
                }
            });
        }
    }
}

