/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.entity;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.GzipCompressingEntity;
import org.apache.http.client.entity.GzipDecompressingEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestGZip {
    @Test
    public void testBasic() throws Exception {
        String s = "some kind of text";
        StringEntity e = new StringEntity("some kind of text", ContentType.TEXT_PLAIN);
        e.setChunked(false);
        GzipCompressingEntity gzipe = new GzipCompressingEntity((HttpEntity)e);
        Assert.assertTrue((boolean)gzipe.isChunked());
        Assert.assertEquals((long)-1L, (long)gzipe.getContentLength());
        Assert.assertNotNull((Object)gzipe.getContentEncoding());
        Assert.assertEquals((Object)"gzip", (Object)gzipe.getContentEncoding().getValue());
    }

    @Test
    public void testCompressionDecompression() throws Exception {
        StringEntity in = new StringEntity("some kind of text", ContentType.TEXT_PLAIN);
        GzipCompressingEntity gzipe = new GzipCompressingEntity((HttpEntity)in);
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        gzipe.writeTo((OutputStream)buf);
        ByteArrayEntity out = new ByteArrayEntity(buf.toByteArray());
        GzipDecompressingEntity gunzipe = new GzipDecompressingEntity((HttpEntity)out);
        Assert.assertEquals((Object)"some kind of text", (Object)EntityUtils.toString((HttpEntity)gunzipe, (Charset)Consts.ASCII));
    }

    @Test
    public void testGzipDecompressingEntityDoesNotCrashInConstructorAndLeaveInputStreamOpen() throws Exception {
        final AtomicBoolean inputStreamIsClosed = new AtomicBoolean(false);
        InputStreamEntity in = new InputStreamEntity(new InputStream(){

            @Override
            public int read() throws IOException {
                throw new IOException("An exception occurred");
            }

            @Override
            public void close() throws IOException {
                inputStreamIsClosed.set(true);
            }
        }, 123L);
        GzipDecompressingEntity gunzipe = new GzipDecompressingEntity((HttpEntity)in);
        try {
            gunzipe.getContent();
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)inputStreamIsClosed.get());
        }
    }

    @Test
    public void testCompressionIOExceptionLeavesOutputStreamOpen() throws Exception {
        HttpEntity in = (HttpEntity)Mockito.mock(HttpEntity.class);
        ((HttpEntity)Mockito.doThrow((Throwable)new IOException("Ooopsie")).when((Object)in)).writeTo((OutputStream)Mockito.any());
        GzipCompressingEntity gzipe = new GzipCompressingEntity(in);
        OutputStream out = (OutputStream)Mockito.mock(OutputStream.class);
        try {
            gzipe.writeTo(out);
        }
        catch (IOException ex) {
            ((OutputStream)Mockito.verify((Object)out, (VerificationMode)Mockito.never())).close();
        }
    }
}

