/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.methods;

import java.net.URI;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.HttpVersion;
import org.apache.http.NameValuePair;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.Configurable;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestRequestBuilder {
    @Test
    public void testBasicGet() throws Exception {
        HttpUriRequest request = RequestBuilder.get().build();
        Assert.assertNotNull((Object)request);
        Assert.assertEquals((Object)"GET", (Object)request.getMethod());
        Assert.assertEquals((Object)URI.create("/"), (Object)request.getURI());
        Assert.assertEquals((Object)HttpVersion.HTTP_1_1, (Object)request.getProtocolVersion());
        Assert.assertFalse((boolean)(request instanceof HttpEntityEnclosingRequest));
    }

    @Test
    public void testArbitraryMethod() throws Exception {
        HttpUriRequest request = RequestBuilder.create((String)"Whatever").build();
        Assert.assertNotNull((Object)request);
        Assert.assertEquals((Object)"Whatever", (Object)request.getMethod());
        Assert.assertEquals((Object)URI.create("/"), (Object)request.getURI());
        Assert.assertEquals((Object)HttpVersion.HTTP_1_1, (Object)request.getProtocolVersion());
    }

    @Test
    public void testBasicWithEntity() throws Exception {
        BasicHttpEntity entity = new BasicHttpEntity();
        HttpUriRequest request = RequestBuilder.post().setEntity((HttpEntity)entity).build();
        Assert.assertNotNull((Object)request);
        Assert.assertEquals((Object)"POST", (Object)request.getMethod());
        Assert.assertEquals((Object)URI.create("/"), (Object)request.getURI());
        Assert.assertEquals((Object)HttpVersion.HTTP_1_1, (Object)request.getProtocolVersion());
        Assert.assertTrue((boolean)(request instanceof HttpEntityEnclosingRequest));
        Assert.assertSame((Object)entity, (Object)((HttpEntityEnclosingRequest)request).getEntity());
    }

    @Test
    public void testGetWithEntity() throws Exception {
        BasicHttpEntity entity = new BasicHttpEntity();
        HttpUriRequest request = RequestBuilder.get().setEntity((HttpEntity)entity).build();
        Assert.assertNotNull((Object)request);
        Assert.assertEquals((Object)"GET", (Object)request.getMethod());
        Assert.assertEquals((Object)URI.create("/"), (Object)request.getURI());
        Assert.assertEquals((Object)HttpVersion.HTTP_1_1, (Object)request.getProtocolVersion());
        Assert.assertTrue((boolean)(request instanceof HttpEntityEnclosingRequest));
        Assert.assertSame((Object)entity, (Object)((HttpEntityEnclosingRequest)request).getEntity());
    }

    @Test
    public void testAddParameters1() throws Exception {
        HttpUriRequest request = RequestBuilder.get().addParameter("p1", "this").addParameter("p2", "that").build();
        Assert.assertFalse((boolean)(request instanceof HttpEntityEnclosingRequest));
        Assert.assertEquals((Object)new URI("/?p1=this&p2=that"), (Object)request.getURI());
    }

    @Test
    public void testAddParameters2() throws Exception {
        HttpUriRequest request = RequestBuilder.get().addParameter("p1", "this").addParameters(new NameValuePair[]{new BasicNameValuePair("p2", "that")}).build();
        Assert.assertFalse((boolean)(request instanceof HttpEntityEnclosingRequest));
        Assert.assertEquals((Object)new URI("/?p1=this&p2=that"), (Object)request.getURI());
    }

    @Test
    public void testAddParameters3() throws Exception {
        HttpUriRequest request = RequestBuilder.post().addParameter("p1", "this").addParameter("p2", "that").build();
        Assert.assertTrue((boolean)(request instanceof HttpEntityEnclosingRequest));
        HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
        Assert.assertNotNull((Object)entity);
        Assert.assertEquals((Object)new URI("/"), (Object)request.getURI());
        Assert.assertEquals((Object)"p1=this&p2=that", (Object)EntityUtils.toString((HttpEntity)entity));
    }

    @Test
    public void testAddParameters4() throws Exception {
        HttpUriRequest request = RequestBuilder.post().setUri("http://targethost/?blah").addParameter("p1", "this").addParameter("p2", "that").setEntity((HttpEntity)new StringEntity("blah")).build();
        Assert.assertTrue((boolean)(request instanceof HttpEntityEnclosingRequest));
        Assert.assertEquals((Object)new URI("http://targethost/?blah&p1=this&p2=that"), (Object)request.getURI());
    }

    @Test
    public void testCopy() throws Exception {
        StringEntity entity = new StringEntity("stuff");
        RequestConfig config = RequestConfig.custom().build();
        HttpUriRequest request = RequestBuilder.put().setUri(URI.create("/stuff")).setVersion((ProtocolVersion)HttpVersion.HTTP_1_0).addHeader("header1", "stuff").setHeader("header2", "more stuff").setEntity((HttpEntity)entity).setConfig(config).build();
        Assert.assertNotNull((Object)request);
        Assert.assertEquals((Object)"PUT", (Object)request.getMethod());
        Assert.assertEquals((Object)URI.create("/stuff"), (Object)request.getURI());
        Assert.assertEquals((Object)HttpVersion.HTTP_1_0, (Object)request.getProtocolVersion());
        Assert.assertTrue((boolean)(request instanceof HttpEntityEnclosingRequest));
        HttpUriRequest copy = RequestBuilder.copy((HttpRequest)request).setUri("/other-stuff").build();
        Assert.assertEquals((Object)"PUT", (Object)copy.getMethod());
        Assert.assertEquals((Object)URI.create("/other-stuff"), (Object)copy.getURI());
        Assert.assertTrue((boolean)(copy instanceof HttpEntityEnclosingRequest));
        Assert.assertSame((Object)entity, (Object)((HttpEntityEnclosingRequest)copy).getEntity());
        Assert.assertTrue((boolean)(copy instanceof Configurable));
        Assert.assertSame((Object)config, (Object)((Configurable)copy).getConfig());
    }

    @Test
    public void testCopyWithQueryParams() throws Exception {
        HttpGet get = new HttpGet("/stuff?p1=this&p2=that");
        RequestBuilder builder = RequestBuilder.copy((HttpRequest)get);
        List parameters = builder.getParameters();
        Assert.assertNotNull((Object)parameters);
        Assert.assertEquals((long)2L, (long)parameters.size());
        Assert.assertEquals((Object)new BasicNameValuePair("p1", "this"), parameters.get(0));
        Assert.assertEquals((Object)new BasicNameValuePair("p2", "that"), parameters.get(1));
        Assert.assertEquals((Object)new URI("/stuff"), (Object)builder.getUri());
    }

    @Test
    public void testCopyWithFormParams() throws Exception {
        HttpPost post = new HttpPost("/stuff?p1=wtf");
        post.setEntity((HttpEntity)new StringEntity("p1=this&p2=that", ContentType.APPLICATION_FORM_URLENCODED));
        RequestBuilder builder = RequestBuilder.copy((HttpRequest)post);
        List parameters = builder.getParameters();
        Assert.assertNotNull((Object)parameters);
        Assert.assertEquals((long)2L, (long)parameters.size());
        Assert.assertEquals((Object)new BasicNameValuePair("p1", "this"), parameters.get(0));
        Assert.assertEquals((Object)new BasicNameValuePair("p2", "that"), parameters.get(1));
        Assert.assertEquals((Object)new URI("/stuff?p1=wtf"), (Object)builder.getUri());
        Assert.assertNull((Object)builder.getEntity());
    }

    @Test
    public void testCopyWithStringEntity() throws Exception {
        HttpPost post = new HttpPost("/stuff?p1=wtf");
        StringEntity entity = new StringEntity("p1=this&p2=that", ContentType.TEXT_PLAIN);
        post.setEntity((HttpEntity)entity);
        RequestBuilder builder = RequestBuilder.copy((HttpRequest)post);
        List parameters = builder.getParameters();
        Assert.assertNotNull((Object)parameters);
        Assert.assertEquals((long)1L, (long)parameters.size());
        Assert.assertEquals((Object)new BasicNameValuePair("p1", "wtf"), parameters.get(0));
        Assert.assertEquals((Object)new URI("/stuff"), (Object)builder.getUri());
        Assert.assertSame((Object)entity, (Object)builder.getEntity());
    }

    @Test
    public void testGettersAndMutators() throws Exception {
        StringEntity entity = new StringEntity("stuff");
        RequestConfig config = RequestConfig.custom().build();
        BasicHeader h1 = new BasicHeader("header1", "stuff");
        BasicHeader h2 = new BasicHeader("header1", "more-stuff");
        RequestBuilder builder = RequestBuilder.put().setUri("/stuff").setVersion((ProtocolVersion)HttpVersion.HTTP_1_0).addHeader((Header)h1).addHeader((Header)h2).setEntity((HttpEntity)entity).setConfig(config);
        Assert.assertEquals((Object)"PUT", (Object)builder.getMethod());
        Assert.assertEquals((Object)URI.create("/stuff"), (Object)builder.getUri());
        Assert.assertEquals((Object)HttpVersion.HTTP_1_0, (Object)builder.getVersion());
        Assert.assertSame((Object)h1, (Object)builder.getFirstHeader("header1"));
        Assert.assertSame((Object)h2, (Object)builder.getLastHeader("header1"));
        Assert.assertEquals((long)2L, (long)builder.getHeaders("header1").length);
        Assert.assertSame((Object)entity, (Object)builder.getEntity());
        Assert.assertSame((Object)config, (Object)builder.getConfig());
        builder.setUri((String)null).setVersion(null).removeHeader((Header)h1).removeHeaders("header1").removeHeader((Header)h2).setEntity(null).setConfig(null);
        Assert.assertEquals(null, (Object)builder.getUri());
        Assert.assertEquals(null, (Object)builder.getVersion());
        Assert.assertSame(null, (Object)builder.getFirstHeader("header1"));
        Assert.assertSame(null, (Object)builder.getLastHeader("header1"));
        Assert.assertEquals((long)0L, (long)builder.getHeaders("header1").length);
        Assert.assertSame(null, (Object)builder.getEntity());
        Assert.assertSame(null, (Object)builder.getConfig());
        builder.setHeader((Header)h2).setHeader("header1", "a-lot-more-stuff");
        Assert.assertSame((Object)"a-lot-more-stuff", (Object)builder.getLastHeader("header1").getValue());
        Assert.assertEquals((long)1L, (long)builder.getHeaders("header1").length);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCopyNull() throws Exception {
        RequestBuilder.copy(null);
    }
}

