/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.protocol;

import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.protocol.RequestClientConnControl;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.routing.RouteInfo;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.protocol.HttpContext;
import org.junit.Assert;
import org.junit.Test;

public class TestRequestClientConnControl {
    @Test(expected=IllegalArgumentException.class)
    public void testRequestParameterCheck() throws Exception {
        HttpClientContext context = HttpClientContext.create();
        RequestClientConnControl interceptor = new RequestClientConnControl();
        interceptor.process(null, (HttpContext)context);
    }

    @Test
    public void testConnectionKeepAliveForConnectRequest() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("CONNECT", "www.somedomain.com");
        HttpClientContext context = HttpClientContext.create();
        RequestClientConnControl interceptor = new RequestClientConnControl();
        interceptor.process((HttpRequest)request, (HttpContext)context);
        Header header1 = request.getFirstHeader("Proxy-Connection");
        Assert.assertNotNull((Object)header1);
        Assert.assertEquals((Object)"Keep-Alive", (Object)header1.getValue());
        Header header2 = request.getFirstHeader("Connection");
        Assert.assertNull((Object)header2);
    }

    @Test
    public void testConnectionKeepAliveForDirectRequests() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        HttpClientContext context = HttpClientContext.create();
        HttpHost target = new HttpHost("localhost", 80, "http");
        HttpRoute route = new HttpRoute(target, null, false);
        context.setAttribute("http.route", (Object)route);
        RequestClientConnControl interceptor = new RequestClientConnControl();
        interceptor.process((HttpRequest)request, (HttpContext)context);
        Header header1 = request.getFirstHeader("Connection");
        Assert.assertNotNull((Object)header1);
        Assert.assertEquals((Object)"Keep-Alive", (Object)header1.getValue());
        Header header2 = request.getFirstHeader("Proxy-Connection");
        Assert.assertNull((Object)header2);
    }

    @Test
    public void testConnectionKeepAliveForTunneledRequests() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        HttpClientContext context = HttpClientContext.create();
        HttpHost target = new HttpHost("localhost", 443, "https");
        HttpHost proxy = new HttpHost("localhost", 8080);
        HttpRoute route = new HttpRoute(target, null, proxy, true, RouteInfo.TunnelType.TUNNELLED, RouteInfo.LayerType.LAYERED);
        context.setAttribute("http.route", (Object)route);
        RequestClientConnControl interceptor = new RequestClientConnControl();
        interceptor.process((HttpRequest)request, (HttpContext)context);
        Header header1 = request.getFirstHeader("Connection");
        Assert.assertNotNull((Object)header1);
        Assert.assertEquals((Object)"Keep-Alive", (Object)header1.getValue());
        Header header2 = request.getFirstHeader("Proxy-Connection");
        Assert.assertNull((Object)header2);
    }

    @Test
    public void testProxyConnectionKeepAliveForRequestsOverProxy() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        HttpClientContext context = HttpClientContext.create();
        HttpHost target = new HttpHost("localhost", 80, "http");
        HttpHost proxy = new HttpHost("localhost", 8080);
        HttpRoute route = new HttpRoute(target, null, proxy, false, RouteInfo.TunnelType.PLAIN, RouteInfo.LayerType.PLAIN);
        context.setAttribute("http.route", (Object)route);
        RequestClientConnControl interceptor = new RequestClientConnControl();
        interceptor.process((HttpRequest)request, (HttpContext)context);
        Header header1 = request.getFirstHeader("Proxy-Connection");
        Assert.assertNotNull((Object)header1);
        Assert.assertEquals((Object)"Keep-Alive", (Object)header1.getValue());
        Header header2 = request.getFirstHeader("Connection");
        Assert.assertNull((Object)header2);
    }

    @Test
    public void testPreserveCustomConnectionHeader() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        request.addHeader("Connection", "Close");
        HttpClientContext context = HttpClientContext.create();
        HttpHost target = new HttpHost("localhost", 443, "https");
        HttpHost proxy = new HttpHost("localhost", 8080);
        HttpRoute route = new HttpRoute(target, null, proxy, true, RouteInfo.TunnelType.TUNNELLED, RouteInfo.LayerType.LAYERED);
        context.setAttribute("http.route", (Object)route);
        RequestClientConnControl interceptor = new RequestClientConnControl();
        interceptor.process((HttpRequest)request, (HttpContext)context);
        Header header1 = request.getFirstHeader("Connection");
        Assert.assertNotNull((Object)header1);
        Assert.assertEquals((Object)"Close", (Object)header1.getValue());
        Header header2 = request.getFirstHeader("Proxy-Connection");
        Assert.assertNull((Object)header2);
    }

    @Test
    public void testPreserveCustomProxyConnectionHeader() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        request.addHeader("Proxy-Connection", "Close");
        HttpClientContext context = HttpClientContext.create();
        HttpHost target = new HttpHost("localhost", 80, "http");
        HttpHost proxy = new HttpHost("localhost", 8080);
        HttpRoute route = new HttpRoute(target, null, proxy, false, RouteInfo.TunnelType.PLAIN, RouteInfo.LayerType.PLAIN);
        context.setAttribute("http.route", (Object)route);
        RequestClientConnControl interceptor = new RequestClientConnControl();
        interceptor.process((HttpRequest)request, (HttpContext)context);
        Header header1 = request.getFirstHeader("Proxy-Connection");
        Assert.assertNotNull((Object)header1);
        Assert.assertEquals((Object)"Close", (Object)header1.getValue());
    }
}

