/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.conn.ssl;

import java.io.ByteArrayInputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.net.ssl.SSLException;
import org.apache.http.conn.ssl.CertificatesToPlayWith;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.util.PublicSuffixMatcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestDefaultHostnameVerifier {
    private DefaultHostnameVerifier impl;
    private PublicSuffixMatcher publicSuffixMatcher;
    private DefaultHostnameVerifier implWithPublicSuffixCheck;

    @Before
    public void setup() {
        this.impl = new DefaultHostnameVerifier();
        this.publicSuffixMatcher = new PublicSuffixMatcher(Arrays.asList("com", "co.jp", "gov.uk"), null);
        this.implWithPublicSuffixCheck = new DefaultHostnameVerifier(this.publicSuffixMatcher);
    }

    @Test
    public void testVerify() throws Exception {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream in = new ByteArrayInputStream(CertificatesToPlayWith.X509_FOO);
        X509Certificate x509 = (X509Certificate)cf.generateCertificate(in);
        this.impl.verify("foo.com", x509);
        this.exceptionPlease(this.impl, "a.foo.com", x509);
        this.exceptionPlease(this.impl, "bar.com", x509);
        in = new ByteArrayInputStream(CertificatesToPlayWith.X509_HANAKO);
        x509 = (X509Certificate)cf.generateCertificate(in);
        this.impl.verify("\u82b1\u5b50.co.jp", x509);
        this.exceptionPlease(this.impl, "a.\u82b1\u5b50.co.jp", x509);
        in = new ByteArrayInputStream(CertificatesToPlayWith.X509_FOO_BAR);
        x509 = (X509Certificate)cf.generateCertificate(in);
        this.exceptionPlease(this.impl, "foo.com", x509);
        this.exceptionPlease(this.impl, "a.foo.com", x509);
        this.impl.verify("bar.com", x509);
        this.exceptionPlease(this.impl, "a.bar.com", x509);
        in = new ByteArrayInputStream(CertificatesToPlayWith.X509_FOO_BAR_HANAKO);
        x509 = (X509Certificate)cf.generateCertificate(in);
        this.exceptionPlease(this.impl, "foo.com", x509);
        this.exceptionPlease(this.impl, "a.foo.com", x509);
        this.impl.verify("bar.com", x509);
        this.exceptionPlease(this.impl, "a.bar.com", x509);
        this.exceptionPlease(this.impl, "a.\u82b1\u5b50.co.jp", x509);
        in = new ByteArrayInputStream(CertificatesToPlayWith.X509_NO_CNS_FOO);
        x509 = (X509Certificate)cf.generateCertificate(in);
        this.impl.verify("foo.com", x509);
        this.exceptionPlease(this.impl, "a.foo.com", x509);
        in = new ByteArrayInputStream(CertificatesToPlayWith.X509_NO_CNS_FOO);
        x509 = (X509Certificate)cf.generateCertificate(in);
        this.impl.verify("foo.com", x509);
        this.exceptionPlease(this.impl, "a.foo.com", x509);
        in = new ByteArrayInputStream(CertificatesToPlayWith.X509_THREE_CNS_FOO_BAR_HANAKO);
        x509 = (X509Certificate)cf.generateCertificate(in);
        this.exceptionPlease(this.impl, "foo.com", x509);
        this.exceptionPlease(this.impl, "a.foo.com", x509);
        this.exceptionPlease(this.impl, "bar.com", x509);
        this.exceptionPlease(this.impl, "a.bar.com", x509);
        this.impl.verify("\u82b1\u5b50.co.jp", x509);
        this.exceptionPlease(this.impl, "a.\u82b1\u5b50.co.jp", x509);
        in = new ByteArrayInputStream(CertificatesToPlayWith.X509_WILD_FOO);
        x509 = (X509Certificate)cf.generateCertificate(in);
        this.exceptionPlease(this.impl, "foo.com", x509);
        this.impl.verify("www.foo.com", x509);
        this.impl.verify("\u82b1\u5b50.foo.com", x509);
        this.exceptionPlease(this.impl, "a.b.foo.com", x509);
        in = new ByteArrayInputStream(CertificatesToPlayWith.X509_WILD_CO_JP);
        x509 = (X509Certificate)cf.generateCertificate(in);
        this.impl.verify("*.co.jp", x509);
        this.impl.verify("foo.co.jp", x509);
        this.impl.verify("\u82b1\u5b50.co.jp", x509);
        this.exceptionPlease(this.implWithPublicSuffixCheck, "foo.co.jp", x509);
        this.exceptionPlease(this.implWithPublicSuffixCheck, "\u82b1\u5b50.co.jp", x509);
        in = new ByteArrayInputStream(CertificatesToPlayWith.X509_WILD_FOO_BAR_HANAKO);
        x509 = (X509Certificate)cf.generateCertificate(in);
        this.exceptionPlease(this.impl, "foo.com", x509);
        this.exceptionPlease(this.impl, "www.foo.com", x509);
        this.exceptionPlease(this.impl, "\u82b1\u5b50.foo.com", x509);
        this.exceptionPlease(this.impl, "a.b.foo.com", x509);
        this.exceptionPlease(this.impl, "bar.com", x509);
        this.impl.verify("www.bar.com", x509);
        this.impl.verify("\u82b1\u5b50.bar.com", x509);
        this.exceptionPlease(this.impl, "a.b.bar.com", x509);
        in = new ByteArrayInputStream(CertificatesToPlayWith.X509_MULTIPLE_VALUE_AVA);
        x509 = (X509Certificate)cf.generateCertificate(in);
        this.impl.verify("repository.infonotary.com", x509);
    }

    @Test
    public void testSubjectAlt() throws Exception {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream in = new ByteArrayInputStream(CertificatesToPlayWith.X509_MULTIPLE_SUBJECT_ALT);
        X509Certificate x509 = (X509Certificate)cf.generateCertificate(in);
        Assert.assertEquals((Object)"CN=localhost, OU=Unknown, O=Unknown, L=Unknown, ST=Unknown, C=CH", (Object)x509.getSubjectDN().getName());
        this.impl.verify("localhost.localdomain", x509);
        this.impl.verify("127.0.0.1", x509);
        try {
            this.impl.verify("localhost", x509);
            Assert.fail((String)"SSLException should have been thrown");
        }
        catch (SSLException ex) {
            // empty catch block
        }
        try {
            this.impl.verify("local.host", x509);
            Assert.fail((String)"SSLException should have been thrown");
        }
        catch (SSLException ex) {
            // empty catch block
        }
        try {
            this.impl.verify("127.0.0.2", x509);
            Assert.fail((String)"SSLException should have been thrown");
        }
        catch (SSLException ex) {
            // empty catch block
        }
    }

    public void exceptionPlease(DefaultHostnameVerifier hv, String host, X509Certificate x509) {
        try {
            hv.verify(host, x509);
            Assert.fail((String)("HostnameVerifier shouldn't allow [" + host + "]"));
        }
        catch (SSLException e) {
            // empty catch block
        }
    }

    @Test
    public void testDomainRootMatching() {
        Assert.assertFalse((boolean)DefaultHostnameVerifier.matchDomainRoot((String)"a.b.c", null));
        Assert.assertTrue((boolean)DefaultHostnameVerifier.matchDomainRoot((String)"a.b.c", (String)"a.b.c"));
        Assert.assertFalse((boolean)DefaultHostnameVerifier.matchDomainRoot((String)"aa.b.c", (String)"a.b.c"));
        Assert.assertFalse((boolean)DefaultHostnameVerifier.matchDomainRoot((String)"a.b.c", (String)"aa.b.c"));
        Assert.assertTrue((boolean)DefaultHostnameVerifier.matchDomainRoot((String)"a.a.b.c", (String)"a.b.c"));
    }

    @Test
    public void testIdentityMatching() {
        Assert.assertTrue((boolean)DefaultHostnameVerifier.matchIdentity((String)"a.b.c", (String)"*.b.c"));
        Assert.assertTrue((boolean)DefaultHostnameVerifier.matchIdentityStrict((String)"a.b.c", (String)"*.b.c"));
        Assert.assertTrue((boolean)DefaultHostnameVerifier.matchIdentity((String)"s.a.b.c", (String)"*.b.c"));
        Assert.assertFalse((boolean)DefaultHostnameVerifier.matchIdentityStrict((String)"s.a.b.c", (String)"*.b.c"));
        Assert.assertFalse((boolean)DefaultHostnameVerifier.matchIdentity((String)"a.gov.uk", (String)"*.gov.uk", (PublicSuffixMatcher)this.publicSuffixMatcher));
        Assert.assertFalse((boolean)DefaultHostnameVerifier.matchIdentityStrict((String)"a.gov.uk", (String)"*.gov.uk", (PublicSuffixMatcher)this.publicSuffixMatcher));
        Assert.assertTrue((boolean)DefaultHostnameVerifier.matchIdentity((String)"s.a.gov.uk", (String)"*.a.gov.uk", (PublicSuffixMatcher)this.publicSuffixMatcher));
        Assert.assertTrue((boolean)DefaultHostnameVerifier.matchIdentityStrict((String)"s.a.gov.uk", (String)"*.a.gov.uk", (PublicSuffixMatcher)this.publicSuffixMatcher));
        Assert.assertFalse((boolean)DefaultHostnameVerifier.matchIdentity((String)"s.a.gov.uk", (String)"*.gov.uk", (PublicSuffixMatcher)this.publicSuffixMatcher));
        Assert.assertFalse((boolean)DefaultHostnameVerifier.matchIdentityStrict((String)"s.a.gov.uk", (String)"*.gov.uk", (PublicSuffixMatcher)this.publicSuffixMatcher));
        Assert.assertTrue((boolean)DefaultHostnameVerifier.matchIdentity((String)"a.gov.com", (String)"*.gov.com", (PublicSuffixMatcher)this.publicSuffixMatcher));
        Assert.assertTrue((boolean)DefaultHostnameVerifier.matchIdentityStrict((String)"a.gov.com", (String)"*.gov.com", (PublicSuffixMatcher)this.publicSuffixMatcher));
        Assert.assertTrue((boolean)DefaultHostnameVerifier.matchIdentity((String)"s.a.gov.com", (String)"*.gov.com", (PublicSuffixMatcher)this.publicSuffixMatcher));
        Assert.assertFalse((boolean)DefaultHostnameVerifier.matchIdentityStrict((String)"s.a.gov.com", (String)"*.gov.com", (PublicSuffixMatcher)this.publicSuffixMatcher));
        Assert.assertFalse((boolean)DefaultHostnameVerifier.matchIdentity((String)"a.gov.uk", (String)"a*.gov.uk", (PublicSuffixMatcher)this.publicSuffixMatcher));
        Assert.assertFalse((boolean)DefaultHostnameVerifier.matchIdentityStrict((String)"a.gov.uk", (String)"a*.gov.uk", (PublicSuffixMatcher)this.publicSuffixMatcher));
        Assert.assertFalse((boolean)DefaultHostnameVerifier.matchIdentity((String)"s.a.gov.uk", (String)"a*.gov.uk", (PublicSuffixMatcher)this.publicSuffixMatcher));
        Assert.assertFalse((boolean)DefaultHostnameVerifier.matchIdentityStrict((String)"s.a.gov.uk", (String)"a*.gov.uk", (PublicSuffixMatcher)this.publicSuffixMatcher));
        Assert.assertFalse((boolean)DefaultHostnameVerifier.matchIdentity((String)"a.b.c", (String)"*.b.*"));
        Assert.assertFalse((boolean)DefaultHostnameVerifier.matchIdentityStrict((String)"a.b.c", (String)"*.b.*"));
        Assert.assertFalse((boolean)DefaultHostnameVerifier.matchIdentity((String)"a.b.c", (String)"*.*.c"));
        Assert.assertFalse((boolean)DefaultHostnameVerifier.matchIdentityStrict((String)"a.b.c", (String)"*.*.c"));
    }

    @Test
    public void testHTTPCLIENT_1097() {
        Assert.assertTrue((boolean)DefaultHostnameVerifier.matchIdentity((String)"a.b.c", (String)"a*.b.c"));
        Assert.assertTrue((boolean)DefaultHostnameVerifier.matchIdentityStrict((String)"a.b.c", (String)"a*.b.c"));
        Assert.assertTrue((boolean)DefaultHostnameVerifier.matchIdentity((String)"a.a.b.c", (String)"a*.b.c"));
        Assert.assertFalse((boolean)DefaultHostnameVerifier.matchIdentityStrict((String)"a.a.b.c", (String)"a*.b.c"));
    }

    @Test
    public void testHTTPCLIENT_1255() {
        Assert.assertTrue((boolean)DefaultHostnameVerifier.matchIdentity((String)"mail.a.b.c.com", (String)"m*.a.b.c.com"));
        Assert.assertTrue((boolean)DefaultHostnameVerifier.matchIdentityStrict((String)"mail.a.b.c.com", (String)"m*.a.b.c.com"));
    }

    @Test
    public void testHTTPCLIENT_1316() throws Exception {
        String host1 = "2001:0db8:aaaa:bbbb:cccc:0:0:0001";
        DefaultHostnameVerifier.matchIPv6Address((String)"2001:0db8:aaaa:bbbb:cccc:0:0:0001", Arrays.asList("2001:0db8:aaaa:bbbb:cccc:0:0:0001"));
        DefaultHostnameVerifier.matchIPv6Address((String)"2001:0db8:aaaa:bbbb:cccc:0:0:0001", Arrays.asList("2001:0db8:aaaa:bbbb:cccc::1"));
        try {
            DefaultHostnameVerifier.matchIPv6Address((String)"2001:0db8:aaaa:bbbb:cccc:0:0:0001", Arrays.asList("2001:0db8:aaaa:bbbb:cccc::10"));
            Assert.fail((String)"SSLException expected");
        }
        catch (SSLException expected) {
            // empty catch block
        }
        String host2 = "2001:0db8:aaaa:bbbb:cccc::1";
        DefaultHostnameVerifier.matchIPv6Address((String)"2001:0db8:aaaa:bbbb:cccc::1", Arrays.asList("2001:0db8:aaaa:bbbb:cccc:0:0:0001"));
        DefaultHostnameVerifier.matchIPv6Address((String)"2001:0db8:aaaa:bbbb:cccc::1", Arrays.asList("2001:0db8:aaaa:bbbb:cccc::1"));
        try {
            DefaultHostnameVerifier.matchIPv6Address((String)"2001:0db8:aaaa:bbbb:cccc::1", Arrays.asList("2001:0db8:aaaa:bbbb:cccc::10"));
            Assert.fail((String)"SSLException expected");
        }
        catch (SSLException sSLException) {
            // empty catch block
        }
    }

    @Test
    public void testExtractCN() throws Exception {
        Assert.assertEquals((Object)"blah", (Object)DefaultHostnameVerifier.extractCN((String)"cn=blah, ou=blah, o=blah"));
        Assert.assertEquals((Object)"blah", (Object)DefaultHostnameVerifier.extractCN((String)"cn=blah, cn=yada, cn=booh"));
        Assert.assertEquals((Object)"blah", (Object)DefaultHostnameVerifier.extractCN((String)"c = pampa ,  cn  =    blah    , ou = blah , o = blah"));
        Assert.assertEquals((Object)"blah", (Object)DefaultHostnameVerifier.extractCN((String)"cn=\"blah\", ou=blah, o=blah"));
        Assert.assertEquals((Object)"blah  blah", (Object)DefaultHostnameVerifier.extractCN((String)"cn=\"blah  blah\", ou=blah, o=blah"));
        Assert.assertEquals((Object)"blah, blah", (Object)DefaultHostnameVerifier.extractCN((String)"cn=\"blah, blah\", ou=blah, o=blah"));
        Assert.assertEquals((Object)"blah, blah", (Object)DefaultHostnameVerifier.extractCN((String)"cn=blah\\, blah, ou=blah, o=blah"));
        Assert.assertEquals((Object)"blah", (Object)DefaultHostnameVerifier.extractCN((String)"c = cn=uuh, cn=blah, ou=blah, o=blah"));
        try {
            DefaultHostnameVerifier.extractCN((String)"blah,blah");
            Assert.fail((String)"SSLException expected");
        }
        catch (SSLException expected) {
            // empty catch block
        }
        try {
            DefaultHostnameVerifier.extractCN((String)"cn,o=blah");
            Assert.fail((String)"SSLException expected");
        }
        catch (SSLException sSLException) {
            // empty catch block
        }
    }
}

