/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.conn.util;

import org.apache.http.conn.util.InetAddressUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestInetAddressUtils {
    @Test
    public void testValidIPv4Address() {
        Assert.assertTrue((boolean)InetAddressUtils.isIPv4Address((String)"127.0.0.1"));
        Assert.assertTrue((boolean)InetAddressUtils.isIPv4Address((String)"192.168.0.0"));
        Assert.assertTrue((boolean)InetAddressUtils.isIPv4Address((String)"255.255.255.255"));
    }

    @Test
    public void testInvalidIPv4Address() {
        Assert.assertFalse((boolean)InetAddressUtils.isIPv4Address((String)" 127.0.0.1 "));
        Assert.assertFalse((boolean)InetAddressUtils.isIPv4Address((String)"g.ar.ba.ge"));
        Assert.assertFalse((boolean)InetAddressUtils.isIPv4Address((String)"192.168.0"));
        Assert.assertFalse((boolean)InetAddressUtils.isIPv4Address((String)"256.255.255.255"));
    }

    @Test
    public void testValidIPv6Address() {
        Assert.assertTrue((boolean)InetAddressUtils.isIPv6StdAddress((String)"2001:0db8:0000:0000:0000:0000:1428:57ab"));
        Assert.assertTrue((boolean)InetAddressUtils.isIPv6StdAddress((String)"2001:db8:0:0:0:0:1428:57ab"));
        Assert.assertTrue((boolean)InetAddressUtils.isIPv6StdAddress((String)"0:0:0:0:0:0:0:0"));
        Assert.assertTrue((boolean)InetAddressUtils.isIPv6StdAddress((String)"0:0:0:0:0:0:0:1"));
        Assert.assertTrue((boolean)InetAddressUtils.isIPv6HexCompressedAddress((String)"2001:0db8:0:0::1428:57ab"));
        Assert.assertTrue((boolean)InetAddressUtils.isIPv6HexCompressedAddress((String)"2001:0db8::1428:57ab"));
        Assert.assertTrue((boolean)InetAddressUtils.isIPv6HexCompressedAddress((String)"2001:db8::1428:57ab"));
        Assert.assertTrue((boolean)InetAddressUtils.isIPv6HexCompressedAddress((String)"::1"));
        Assert.assertTrue((boolean)InetAddressUtils.isIPv6HexCompressedAddress((String)"::"));
    }

    @Test
    public void testInvalidIPv6Address() {
        Assert.assertFalse((boolean)InetAddressUtils.isIPv6Address((String)"2001:0db8:0000:garb:age0:0000:1428:57ab"));
        Assert.assertFalse((boolean)InetAddressUtils.isIPv6Address((String)"2001:0gb8:0000:0000:0000:0000:1428:57ab"));
        Assert.assertFalse((boolean)InetAddressUtils.isIPv6StdAddress((String)"0:0:0:0:0:0:0:0:0"));
        Assert.assertFalse((boolean)InetAddressUtils.isIPv6StdAddress((String)"0:0:0:0:0:0:0"));
        Assert.assertFalse((boolean)InetAddressUtils.isIPv6HexCompressedAddress((String)":1"));
        Assert.assertFalse((boolean)InetAddressUtils.isIPv6Address((String)"2001:0db8::0000::57ab"));
        Assert.assertFalse((boolean)InetAddressUtils.isIPv6HexCompressedAddress((String)"1:2:3:4:5:6:7::9"));
        Assert.assertFalse((boolean)InetAddressUtils.isIPv6HexCompressedAddress((String)"1::3:4:5:6:7:8:9"));
        Assert.assertFalse((boolean)InetAddressUtils.isIPv6HexCompressedAddress((String)"::3:4:5:6:7:8:9"));
        Assert.assertFalse((boolean)InetAddressUtils.isIPv6Address((String)""));
    }

    @Test
    public void testInvalidIPv6AddressIncorrectGroupCount() {
        Assert.assertFalse((boolean)InetAddressUtils.isIPv6HexCompressedAddress((String)"1:2::4:5:6:7:8:9"));
        Assert.assertFalse((boolean)InetAddressUtils.isIPv6HexCompressedAddress((String)"1:2:3:4:5:6::8:9"));
    }

    @Test
    public void testValidIPv4MappedIPv6Address() {
        Assert.assertTrue((boolean)InetAddressUtils.isIPv4MappedIPv64Address((String)"::FFFF:1.2.3.4"));
        Assert.assertTrue((boolean)InetAddressUtils.isIPv4MappedIPv64Address((String)"::ffff:255.255.255.255"));
    }

    @Test
    public void testInValidIPv4MappedIPv6Address() {
        Assert.assertFalse((boolean)InetAddressUtils.isIPv4MappedIPv64Address((String)"2001:0db8:0000:0000:0000:0000:1428:57ab"));
        Assert.assertFalse((boolean)InetAddressUtils.isIPv4MappedIPv64Address((String)"::ffff:1:2:3:4"));
    }
}

