/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.conn.util;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import org.apache.http.Consts;
import org.apache.http.conn.util.PublicSuffixList;
import org.apache.http.conn.util.PublicSuffixListParser;
import org.junit.Assert;
import org.junit.Test;

public class TestPublicSuffixListParser {
    private static final String SOURCE_FILE = "suffixlist.txt";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testParse() throws Exception {
        PublicSuffixList suffixList;
        ClassLoader classLoader = this.getClass().getClassLoader();
        InputStream in = classLoader.getResourceAsStream(SOURCE_FILE);
        Assert.assertNotNull((Object)in);
        try {
            PublicSuffixListParser parser = new PublicSuffixListParser();
            suffixList = parser.parse((Reader)new InputStreamReader(in, Consts.UTF_8));
        }
        finally {
            in.close();
        }
        Assert.assertNotNull((Object)suffixList);
        Assert.assertEquals(Arrays.asList("jp", "ac.jp", "*.tokyo.jp", "no", "h\u00e5.no", "xx"), (Object)suffixList.getRules());
        Assert.assertEquals(Arrays.asList("metro.tokyo.jp"), (Object)suffixList.getExceptions());
    }
}

