/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client;

import java.io.IOException;
import java.io.InputStream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.HttpResponseException;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.AbstractResponseHandler;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.message.BasicStatusLine;
import org.apache.http.util.EntityUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestAbstractResponseHandler {
    @Test
    public void testSuccessfulResponse() throws Exception {
        BasicStatusLine sl = new BasicStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        HttpResponse response = (HttpResponse)Mockito.mock(HttpResponse.class);
        StringEntity entity = new StringEntity("42");
        Mockito.when((Object)response.getStatusLine()).thenReturn((Object)sl);
        Mockito.when((Object)response.getEntity()).thenReturn((Object)entity);
        AbstractResponseHandler<Integer> handler = new AbstractResponseHandler<Integer>(){

            public Integer handleEntity(HttpEntity entity) throws IOException {
                return Integer.valueOf(EntityUtils.toString((HttpEntity)entity));
            }
        };
        Integer number = (Integer)handler.handleResponse(response);
        Assert.assertEquals((long)42L, (long)number.intValue());
    }

    @Test
    public void testUnsuccessfulResponse() throws Exception {
        InputStream instream = (InputStream)Mockito.mock(InputStream.class);
        HttpEntity entity = (HttpEntity)Mockito.mock(HttpEntity.class);
        Mockito.when((Object)entity.isStreaming()).thenReturn((Object)true);
        Mockito.when((Object)entity.getContent()).thenReturn((Object)instream);
        BasicStatusLine sl = new BasicStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, 404, "Not Found");
        HttpResponse response = (HttpResponse)Mockito.mock(HttpResponse.class);
        Mockito.when((Object)response.getStatusLine()).thenReturn((Object)sl);
        Mockito.when((Object)response.getEntity()).thenReturn((Object)entity);
        BasicResponseHandler handler = new BasicResponseHandler();
        try {
            handler.handleResponse(response);
            Assert.fail((String)"HttpResponseException expected");
        }
        catch (HttpResponseException ex) {
            Assert.assertEquals((long)404L, (long)ex.getStatusCode());
            Assert.assertEquals((Object)"Not Found", (Object)ex.getMessage());
        }
        ((HttpEntity)Mockito.verify((Object)entity)).getContent();
        ((InputStream)Mockito.verify((Object)instream)).close();
    }
}

