/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpHost;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.Lookup;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.ConnectionPoolTimeoutException;
import org.apache.http.conn.ConnectionRequest;
import org.apache.http.conn.DnsResolver;
import org.apache.http.conn.ManagedHttpClientConnection;
import org.apache.http.conn.SchemePortResolver;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.impl.conn.CPool;
import org.apache.http.impl.conn.CPoolEntry;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.pool.PoolEntry;
import org.apache.http.protocol.HttpContext;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class TestPoolingHttpClientConnectionManager {
    @Mock
    private ManagedHttpClientConnection conn;
    @Mock
    private Lookup<ConnectionSocketFactory> socketFactoryRegistry;
    @Mock
    private ConnectionSocketFactory plainSocketFactory;
    @Mock
    private ConnectionSocketFactory sslSocketFactory;
    @Mock
    private Socket socket;
    @Mock
    private SchemePortResolver schemePortResolver;
    @Mock
    private DnsResolver dnsResolver;
    @Mock
    private Future<CPoolEntry> future;
    @Mock
    private CPool pool;
    private PoolingHttpClientConnectionManager mgr;

    @Before
    public void setup() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.mgr = new PoolingHttpClientConnectionManager(this.pool, this.socketFactoryRegistry, this.schemePortResolver, this.dnsResolver);
    }

    @Test
    public void testLeaseRelease() throws Exception {
        HttpHost target = new HttpHost("localhost", 80);
        HttpRoute route = new HttpRoute(target);
        CPoolEntry entry = new CPoolEntry(LogFactory.getLog(this.getClass()), "id", route, this.conn, -1L, TimeUnit.MILLISECONDS);
        entry.markRouteComplete();
        Mockito.when((Object)this.future.isCancelled()).thenReturn((Object)Boolean.FALSE);
        Mockito.when((Object)this.socketFactoryRegistry.lookup("http")).thenReturn((Object)this.plainSocketFactory);
        Mockito.when((Object)this.schemePortResolver.resolve(target)).thenReturn((Object)80);
        Mockito.when((Object)this.plainSocketFactory.createSocket((HttpContext)Mockito.any())).thenReturn((Object)this.socket);
        Mockito.when((Object)this.conn.isOpen()).thenReturn((Object)true);
        Mockito.when((Object)this.future.isCancelled()).thenReturn((Object)false);
        Mockito.when((Object)this.future.get(1L, TimeUnit.SECONDS)).thenReturn((Object)entry);
        Mockito.when((Object)this.pool.lease((Object)route, null, null)).thenReturn(this.future);
        ConnectionRequest connRequest1 = this.mgr.requestConnection(route, null);
        HttpClientConnection conn1 = connRequest1.get(1L, TimeUnit.SECONDS);
        Assert.assertNotNull((Object)conn1);
        Assert.assertNotSame((Object)this.conn, (Object)conn1);
        this.mgr.releaseConnection(conn1, null, 0L, TimeUnit.MILLISECONDS);
        ((CPool)Mockito.verify((Object)this.pool)).release((PoolEntry)entry, true);
    }

    @Test
    public void testReleaseRouteIncomplete() throws Exception {
        HttpHost target = new HttpHost("localhost", 80);
        HttpRoute route = new HttpRoute(target);
        CPoolEntry entry = new CPoolEntry(LogFactory.getLog(this.getClass()), "id", route, this.conn, -1L, TimeUnit.MILLISECONDS);
        Mockito.when((Object)this.future.isCancelled()).thenReturn((Object)Boolean.FALSE);
        Mockito.when((Object)this.socketFactoryRegistry.lookup("http")).thenReturn((Object)this.plainSocketFactory);
        Mockito.when((Object)this.schemePortResolver.resolve(target)).thenReturn((Object)80);
        Mockito.when((Object)this.plainSocketFactory.createSocket((HttpContext)Mockito.any())).thenReturn((Object)this.socket);
        Mockito.when((Object)this.conn.isOpen()).thenReturn((Object)true);
        Mockito.when((Object)this.future.isCancelled()).thenReturn((Object)false);
        Mockito.when((Object)this.future.get(1L, TimeUnit.SECONDS)).thenReturn((Object)entry);
        Mockito.when((Object)this.pool.lease((Object)route, null, null)).thenReturn(this.future);
        ConnectionRequest connRequest1 = this.mgr.requestConnection(route, null);
        HttpClientConnection conn1 = connRequest1.get(1L, TimeUnit.SECONDS);
        Assert.assertNotNull((Object)conn1);
        Assert.assertNotSame((Object)this.conn, (Object)conn1);
        this.mgr.releaseConnection(conn1, null, 0L, TimeUnit.MILLISECONDS);
        ((CPool)Mockito.verify((Object)this.pool)).release((PoolEntry)entry, false);
    }

    @Test(expected=InterruptedException.class)
    public void testLeaseFutureCancelled() throws Exception {
        HttpHost target = new HttpHost("localhost", 80);
        HttpRoute route = new HttpRoute(target);
        CPoolEntry entry = new CPoolEntry(LogFactory.getLog(this.getClass()), "id", route, this.conn, -1L, TimeUnit.MILLISECONDS);
        entry.markRouteComplete();
        Mockito.when((Object)this.future.isCancelled()).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)this.future.get(1L, TimeUnit.SECONDS)).thenReturn((Object)entry);
        Mockito.when((Object)this.pool.lease((Object)route, null, null)).thenReturn(this.future);
        ConnectionRequest connRequest1 = this.mgr.requestConnection(route, null);
        connRequest1.get(1L, TimeUnit.SECONDS);
    }

    @Test(expected=ConnectionPoolTimeoutException.class)
    public void testLeaseFutureTimeout() throws Exception {
        HttpHost target = new HttpHost("localhost", 80);
        HttpRoute route = new HttpRoute(target);
        Mockito.when((Object)this.future.isCancelled()).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)this.future.get(1L, TimeUnit.SECONDS)).thenThrow(new Throwable[]{new TimeoutException()});
        Mockito.when((Object)this.pool.lease((Object)route, null, null)).thenReturn(this.future);
        ConnectionRequest connRequest1 = this.mgr.requestConnection(route, null);
        connRequest1.get(1L, TimeUnit.SECONDS);
    }

    @Test
    public void testReleaseReusable() throws Exception {
        HttpHost target = new HttpHost("localhost", 80);
        HttpRoute route = new HttpRoute(target);
        CPoolEntry entry = (CPoolEntry)Mockito.spy((Object)new CPoolEntry(LogFactory.getLog(this.getClass()), "id", route, this.conn, -1L, TimeUnit.MILLISECONDS));
        entry.markRouteComplete();
        Mockito.when((Object)this.future.isCancelled()).thenReturn((Object)Boolean.FALSE);
        Mockito.when((Object)this.future.get(1L, TimeUnit.SECONDS)).thenReturn((Object)entry);
        Mockito.when((Object)this.pool.lease((Object)route, null, null)).thenReturn(this.future);
        Mockito.when((Object)this.conn.isOpen()).thenReturn((Object)Boolean.TRUE);
        ConnectionRequest connRequest1 = this.mgr.requestConnection(route, null);
        HttpClientConnection conn1 = connRequest1.get(1L, TimeUnit.SECONDS);
        Assert.assertNotNull((Object)conn1);
        Assert.assertTrue((boolean)conn1.isOpen());
        this.mgr.releaseConnection(conn1, (Object)"some state", 0L, TimeUnit.MILLISECONDS);
        ((CPool)Mockito.verify((Object)this.pool)).release((PoolEntry)entry, true);
        ((CPoolEntry)Mockito.verify((Object)entry)).setState((Object)"some state");
        ((CPoolEntry)Mockito.verify((Object)entry)).updateExpiry(Mockito.anyLong(), (TimeUnit)((Object)Mockito.eq((Object)((Object)TimeUnit.MILLISECONDS))));
    }

    @Test
    public void testReleaseNonReusable() throws Exception {
        HttpHost target = new HttpHost("localhost", 80);
        HttpRoute route = new HttpRoute(target);
        CPoolEntry entry = (CPoolEntry)Mockito.spy((Object)new CPoolEntry(LogFactory.getLog(this.getClass()), "id", route, this.conn, -1L, TimeUnit.MILLISECONDS));
        entry.markRouteComplete();
        Mockito.when((Object)this.future.isCancelled()).thenReturn((Object)Boolean.FALSE);
        Mockito.when((Object)this.future.get(1L, TimeUnit.SECONDS)).thenReturn((Object)entry);
        Mockito.when((Object)this.pool.lease((Object)route, null, null)).thenReturn(this.future);
        Mockito.when((Object)this.conn.isOpen()).thenReturn((Object)Boolean.FALSE);
        ConnectionRequest connRequest1 = this.mgr.requestConnection(route, null);
        HttpClientConnection conn1 = connRequest1.get(1L, TimeUnit.SECONDS);
        Assert.assertNotNull((Object)conn1);
        Assert.assertFalse((boolean)conn1.isOpen());
        this.mgr.releaseConnection(conn1, (Object)"some state", 0L, TimeUnit.MILLISECONDS);
        ((CPool)Mockito.verify((Object)this.pool)).release((PoolEntry)entry, false);
        ((CPoolEntry)Mockito.verify((Object)entry, (VerificationMode)Mockito.never())).setState(Mockito.anyObject());
        ((CPoolEntry)Mockito.verify((Object)entry, (VerificationMode)Mockito.never())).updateExpiry(Mockito.anyLong(), (TimeUnit)((Object)Mockito.eq((Object)((Object)TimeUnit.MILLISECONDS))));
    }

    @Test
    public void testTargetConnect() throws Exception {
        HttpHost target = new HttpHost("somehost", 443, "https");
        InetAddress remote = InetAddress.getByAddress(new byte[]{10, 0, 0, 1});
        InetAddress local = InetAddress.getByAddress(new byte[]{127, 0, 0, 1});
        HttpRoute route = new HttpRoute(target, local, true);
        CPoolEntry entry = new CPoolEntry(LogFactory.getLog(this.getClass()), "id", route, this.conn, -1L, TimeUnit.MILLISECONDS);
        entry.markRouteComplete();
        Mockito.when((Object)this.future.isCancelled()).thenReturn((Object)Boolean.FALSE);
        Mockito.when((Object)this.conn.isOpen()).thenReturn((Object)true);
        Mockito.when((Object)this.future.isCancelled()).thenReturn((Object)false);
        Mockito.when((Object)this.future.get(1L, TimeUnit.SECONDS)).thenReturn((Object)entry);
        Mockito.when((Object)this.pool.lease((Object)route, null, null)).thenReturn(this.future);
        ConnectionRequest connRequest1 = this.mgr.requestConnection(route, null);
        HttpClientConnection conn1 = connRequest1.get(1L, TimeUnit.SECONDS);
        Assert.assertNotNull((Object)conn1);
        HttpClientContext context = HttpClientContext.create();
        SocketConfig sconfig = SocketConfig.custom().build();
        this.mgr.setDefaultSocketConfig(sconfig);
        Mockito.when((Object)this.dnsResolver.resolve("somehost")).thenReturn((Object)new InetAddress[]{remote});
        Mockito.when((Object)this.schemePortResolver.resolve(target)).thenReturn((Object)8443);
        Mockito.when((Object)this.socketFactoryRegistry.lookup("https")).thenReturn((Object)this.plainSocketFactory);
        Mockito.when((Object)this.plainSocketFactory.createSocket((HttpContext)Mockito.any())).thenReturn((Object)this.socket);
        Mockito.when((Object)this.plainSocketFactory.connectSocket(Mockito.anyInt(), (Socket)Mockito.eq((Object)this.socket), (HttpHost)Mockito.any(), (InetSocketAddress)Mockito.any(), (InetSocketAddress)Mockito.any(), (HttpContext)Mockito.any())).thenReturn((Object)this.socket);
        this.mgr.connect(conn1, route, 123, (HttpContext)context);
        ((DnsResolver)Mockito.verify((Object)this.dnsResolver, (VerificationMode)Mockito.times((int)1))).resolve("somehost");
        ((SchemePortResolver)Mockito.verify((Object)this.schemePortResolver, (VerificationMode)Mockito.times((int)1))).resolve(target);
        ((ConnectionSocketFactory)Mockito.verify((Object)this.plainSocketFactory, (VerificationMode)Mockito.times((int)1))).createSocket((HttpContext)context);
        ((ConnectionSocketFactory)Mockito.verify((Object)this.plainSocketFactory, (VerificationMode)Mockito.times((int)1))).connectSocket(123, this.socket, target, new InetSocketAddress(remote, 8443), new InetSocketAddress(local, 0), (HttpContext)context);
        this.mgr.routeComplete(conn1, route, (HttpContext)context);
    }

    @Test
    public void testProxyConnectAndUpgrade() throws Exception {
        HttpHost target = new HttpHost("somehost", 443, "https");
        HttpHost proxy = new HttpHost("someproxy", 8080);
        InetAddress remote = InetAddress.getByAddress(new byte[]{10, 0, 0, 1});
        InetAddress local = InetAddress.getByAddress(new byte[]{127, 0, 0, 1});
        HttpRoute route = new HttpRoute(target, local, proxy, true);
        CPoolEntry entry = new CPoolEntry(LogFactory.getLog(this.getClass()), "id", route, this.conn, -1L, TimeUnit.MILLISECONDS);
        entry.markRouteComplete();
        Mockito.when((Object)this.future.isCancelled()).thenReturn((Object)Boolean.FALSE);
        Mockito.when((Object)this.conn.isOpen()).thenReturn((Object)true);
        Mockito.when((Object)this.future.isCancelled()).thenReturn((Object)false);
        Mockito.when((Object)this.future.get(1L, TimeUnit.SECONDS)).thenReturn((Object)entry);
        Mockito.when((Object)this.pool.lease((Object)route, null, null)).thenReturn(this.future);
        ConnectionRequest connRequest1 = this.mgr.requestConnection(route, null);
        HttpClientConnection conn1 = connRequest1.get(1L, TimeUnit.SECONDS);
        Assert.assertNotNull((Object)conn1);
        ConnectionSocketFactory plainsf = (ConnectionSocketFactory)Mockito.mock(ConnectionSocketFactory.class);
        LayeredConnectionSocketFactory sslsf = (LayeredConnectionSocketFactory)Mockito.mock(LayeredConnectionSocketFactory.class);
        Socket mockSock = (Socket)Mockito.mock(Socket.class);
        HttpClientContext context = HttpClientContext.create();
        SocketConfig sconfig = SocketConfig.custom().build();
        ConnectionConfig cconfig = ConnectionConfig.custom().build();
        this.mgr.setDefaultSocketConfig(sconfig);
        this.mgr.setDefaultConnectionConfig(cconfig);
        Mockito.when((Object)this.dnsResolver.resolve("someproxy")).thenReturn((Object)new InetAddress[]{remote});
        Mockito.when((Object)this.schemePortResolver.resolve(proxy)).thenReturn((Object)8080);
        Mockito.when((Object)this.schemePortResolver.resolve(target)).thenReturn((Object)8443);
        Mockito.when((Object)this.socketFactoryRegistry.lookup("http")).thenReturn((Object)plainsf);
        Mockito.when((Object)this.socketFactoryRegistry.lookup("https")).thenReturn((Object)sslsf);
        Mockito.when((Object)plainsf.createSocket((HttpContext)Mockito.any())).thenReturn((Object)mockSock);
        Mockito.when((Object)plainsf.connectSocket(Mockito.anyInt(), (Socket)Mockito.eq((Object)mockSock), (HttpHost)Mockito.any(), (InetSocketAddress)Mockito.any(), (InetSocketAddress)Mockito.any(), (HttpContext)Mockito.any())).thenReturn((Object)mockSock);
        this.mgr.connect(conn1, route, 123, (HttpContext)context);
        ((DnsResolver)Mockito.verify((Object)this.dnsResolver, (VerificationMode)Mockito.times((int)1))).resolve("someproxy");
        ((SchemePortResolver)Mockito.verify((Object)this.schemePortResolver, (VerificationMode)Mockito.times((int)1))).resolve(proxy);
        ((ConnectionSocketFactory)Mockito.verify((Object)plainsf, (VerificationMode)Mockito.times((int)1))).createSocket((HttpContext)context);
        ((ConnectionSocketFactory)Mockito.verify((Object)plainsf, (VerificationMode)Mockito.times((int)1))).connectSocket(123, mockSock, proxy, new InetSocketAddress(remote, 8080), new InetSocketAddress(local, 0), (HttpContext)context);
        Mockito.when((Object)this.conn.getSocket()).thenReturn((Object)mockSock);
        this.mgr.upgrade(conn1, route, (HttpContext)context);
        ((SchemePortResolver)Mockito.verify((Object)this.schemePortResolver, (VerificationMode)Mockito.times((int)1))).resolve(target);
        ((LayeredConnectionSocketFactory)Mockito.verify((Object)sslsf, (VerificationMode)Mockito.times((int)1))).createLayeredSocket(mockSock, "somehost", 8443, (HttpContext)context);
        this.mgr.routeComplete(conn1, route, (HttpContext)context);
    }
}

