/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.cookie;

import java.util.Arrays;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.cookie.ClientCookie;
import org.apache.http.cookie.CommonCookieAttributeHandler;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.cookie.SetCookie;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.impl.cookie.RFC6265CookieSpecBase;
import org.apache.http.message.BasicHeader;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestRFC6265CookieSpecBase {
    @Test
    public void testParseCookieBasics() throws Exception {
        CommonCookieAttributeHandler h1 = (CommonCookieAttributeHandler)Mockito.mock(CommonCookieAttributeHandler.class);
        Mockito.when((Object)h1.getAttributeName()).thenReturn((Object)"this");
        CommonCookieAttributeHandler h2 = (CommonCookieAttributeHandler)Mockito.mock(CommonCookieAttributeHandler.class);
        Mockito.when((Object)h2.getAttributeName()).thenReturn((Object)"that");
        RFC6265CookieSpecBase cookiespec = new RFC6265CookieSpecBase(new CommonCookieAttributeHandler[]{h1, h2});
        BasicHeader header = new BasicHeader("Set-Cookie", "name = value ; this = stuff;");
        CookieOrigin origin = new CookieOrigin("host", 80, "/path/", true);
        List cookies = cookiespec.parse((Header)header, origin);
        Assert.assertEquals((long)1L, (long)cookies.size());
        Cookie cookie = (Cookie)cookies.get(0);
        Assert.assertEquals((Object)"name", (Object)cookie.getName());
        Assert.assertEquals((Object)"value", (Object)cookie.getValue());
        Assert.assertEquals((Object)"/path", (Object)cookie.getPath());
        Assert.assertEquals((Object)"host", (Object)cookie.getDomain());
        Assert.assertTrue((boolean)(cookie instanceof ClientCookie));
        ClientCookie clientCookie = (ClientCookie)cookie;
        Assert.assertEquals((Object)"stuff", (Object)clientCookie.getAttribute("this"));
        Assert.assertEquals(null, (Object)clientCookie.getAttribute("that"));
        ((CommonCookieAttributeHandler)Mockito.verify((Object)h1)).parse((SetCookie)Mockito.any(), (String)Mockito.eq((Object)"stuff"));
        ((CommonCookieAttributeHandler)Mockito.verify((Object)h2, (VerificationMode)Mockito.never())).parse((SetCookie)Mockito.any(), Mockito.anyString());
    }

    @Test
    public void testParseCookieQuotedValue() throws Exception {
        RFC6265CookieSpecBase cookiespec = new RFC6265CookieSpecBase(new CommonCookieAttributeHandler[0]);
        BasicHeader header = new BasicHeader("Set-Cookie", "name = \" one, two, three; four \" ; this = stuff;");
        CookieOrigin origin = new CookieOrigin("host", 80, "/path/", true);
        List cookies = cookiespec.parse((Header)header, origin);
        Assert.assertEquals((long)1L, (long)cookies.size());
        Cookie cookie = (Cookie)cookies.get(0);
        Assert.assertEquals((Object)"name", (Object)cookie.getName());
        Assert.assertEquals((Object)" one, two, three; four ", (Object)cookie.getValue());
        Assert.assertTrue((boolean)(cookie instanceof ClientCookie));
        ClientCookie clientCookie = (ClientCookie)cookie;
        Assert.assertEquals((Object)"stuff", (Object)clientCookie.getAttribute("this"));
    }

    @Test(expected=MalformedCookieException.class)
    public void testParseCookieWrongHeader() throws Exception {
        RFC6265CookieSpecBase cookiespec = new RFC6265CookieSpecBase(new CommonCookieAttributeHandler[0]);
        BasicHeader header = new BasicHeader("Set-Cookie2", "blah");
        CookieOrigin origin = new CookieOrigin("host", 80, "/path/", true);
        cookiespec.parse((Header)header, origin);
    }

    @Test(expected=MalformedCookieException.class)
    public void testParseCookieMissingName() throws Exception {
        RFC6265CookieSpecBase cookiespec = new RFC6265CookieSpecBase(new CommonCookieAttributeHandler[0]);
        BasicHeader header = new BasicHeader("Set-Cookie", "=blah ; this = stuff;");
        CookieOrigin origin = new CookieOrigin("host", 80, "/path/", true);
        cookiespec.parse((Header)header, origin);
    }

    @Test(expected=MalformedCookieException.class)
    public void testParseCookieMissingValue1() throws Exception {
        RFC6265CookieSpecBase cookiespec = new RFC6265CookieSpecBase(new CommonCookieAttributeHandler[0]);
        BasicHeader header = new BasicHeader("Set-Cookie", "blah");
        CookieOrigin origin = new CookieOrigin("host", 80, "/path/", true);
        cookiespec.parse((Header)header, origin);
    }

    @Test(expected=MalformedCookieException.class)
    public void testParseCookieMissingValue2() throws Exception {
        RFC6265CookieSpecBase cookiespec = new RFC6265CookieSpecBase(new CommonCookieAttributeHandler[0]);
        BasicHeader header = new BasicHeader("Set-Cookie", "blah;");
        CookieOrigin origin = new CookieOrigin("host", 80, "/path/", true);
        cookiespec.parse((Header)header, origin);
    }

    @Test
    public void testParseCookieEmptyValue() throws Exception {
        RFC6265CookieSpecBase cookiespec = new RFC6265CookieSpecBase(new CommonCookieAttributeHandler[0]);
        BasicHeader header = new BasicHeader("Set-Cookie", "blah=;");
        CookieOrigin origin = new CookieOrigin("host", 80, "/path/", true);
        List cookies = cookiespec.parse((Header)header, origin);
        Assert.assertEquals((long)1L, (long)cookies.size());
        Cookie cookie = (Cookie)cookies.get(0);
        Assert.assertEquals((Object)"blah", (Object)cookie.getName());
        Assert.assertEquals((Object)"", (Object)cookie.getValue());
    }

    @Test
    public void testParseCookieWithAttributes() throws Exception {
        CommonCookieAttributeHandler h1 = (CommonCookieAttributeHandler)Mockito.mock(CommonCookieAttributeHandler.class);
        Mockito.when((Object)h1.getAttributeName()).thenReturn((Object)"this");
        CommonCookieAttributeHandler h2 = (CommonCookieAttributeHandler)Mockito.mock(CommonCookieAttributeHandler.class);
        Mockito.when((Object)h2.getAttributeName()).thenReturn((Object)"that");
        RFC6265CookieSpecBase cookiespec = new RFC6265CookieSpecBase(new CommonCookieAttributeHandler[]{h1, h2});
        BasicHeader header = new BasicHeader("Set-Cookie", "name = value ; p1 = v ; p2 = v,0; p3 ; p4");
        CookieOrigin origin = new CookieOrigin("host", 80, "/path/", true);
        List cookies = cookiespec.parse((Header)header, origin);
        Assert.assertEquals((long)1L, (long)cookies.size());
        Cookie cookie = (Cookie)cookies.get(0);
        Assert.assertEquals((Object)"name", (Object)cookie.getName());
        Assert.assertEquals((Object)"value", (Object)cookie.getValue());
        Assert.assertTrue((boolean)(cookie instanceof ClientCookie));
        ClientCookie clientCookie = (ClientCookie)cookie;
        Assert.assertEquals((Object)"v", (Object)clientCookie.getAttribute("p1"));
        Assert.assertEquals((Object)"v,0", (Object)clientCookie.getAttribute("p2"));
        Assert.assertTrue((boolean)clientCookie.containsAttribute("p3"));
        Assert.assertTrue((boolean)clientCookie.containsAttribute("p4"));
        Assert.assertFalse((boolean)clientCookie.containsAttribute("p5"));
    }

    @Test
    public void testParseCookieWithAttributes2() throws Exception {
        CommonCookieAttributeHandler h1 = (CommonCookieAttributeHandler)Mockito.mock(CommonCookieAttributeHandler.class);
        Mockito.when((Object)h1.getAttributeName()).thenReturn((Object)"this");
        CommonCookieAttributeHandler h2 = (CommonCookieAttributeHandler)Mockito.mock(CommonCookieAttributeHandler.class);
        Mockito.when((Object)h2.getAttributeName()).thenReturn((Object)"that");
        RFC6265CookieSpecBase cookiespec = new RFC6265CookieSpecBase(new CommonCookieAttributeHandler[]{h1, h2});
        BasicHeader header = new BasicHeader("Set-Cookie", "name = value ; p1 = v");
        CookieOrigin origin = new CookieOrigin("host", 80, "/path/", true);
        List cookies = cookiespec.parse((Header)header, origin);
        Assert.assertEquals((long)1L, (long)cookies.size());
        Cookie cookie = (Cookie)cookies.get(0);
        Assert.assertEquals((Object)"name", (Object)cookie.getName());
        Assert.assertEquals((Object)"value", (Object)cookie.getValue());
        Assert.assertTrue((boolean)(cookie instanceof ClientCookie));
        ClientCookie clientCookie = (ClientCookie)cookie;
        Assert.assertEquals((Object)"v", (Object)clientCookie.getAttribute("p1"));
    }

    @Test
    public void testParseCookieWithAttributes3() throws Exception {
        CommonCookieAttributeHandler h1 = (CommonCookieAttributeHandler)Mockito.mock(CommonCookieAttributeHandler.class);
        Mockito.when((Object)h1.getAttributeName()).thenReturn((Object)"this");
        CommonCookieAttributeHandler h2 = (CommonCookieAttributeHandler)Mockito.mock(CommonCookieAttributeHandler.class);
        Mockito.when((Object)h2.getAttributeName()).thenReturn((Object)"that");
        RFC6265CookieSpecBase cookiespec = new RFC6265CookieSpecBase(new CommonCookieAttributeHandler[]{h1, h2});
        BasicHeader header = new BasicHeader("Set-Cookie", "name = value ; p1 =");
        CookieOrigin origin = new CookieOrigin("host", 80, "/path/", true);
        List cookies = cookiespec.parse((Header)header, origin);
        Assert.assertEquals((long)1L, (long)cookies.size());
        Cookie cookie = (Cookie)cookies.get(0);
        Assert.assertEquals((Object)"name", (Object)cookie.getName());
        Assert.assertEquals((Object)"value", (Object)cookie.getValue());
        Assert.assertTrue((boolean)(cookie instanceof ClientCookie));
        ClientCookie clientCookie = (ClientCookie)cookie;
        Assert.assertEquals((Object)"", (Object)clientCookie.getAttribute("p1"));
    }

    @Test
    public void testValidateCookieBasics() throws Exception {
        CommonCookieAttributeHandler h1 = (CommonCookieAttributeHandler)Mockito.mock(CommonCookieAttributeHandler.class);
        Mockito.when((Object)h1.getAttributeName()).thenReturn((Object)"this");
        CommonCookieAttributeHandler h2 = (CommonCookieAttributeHandler)Mockito.mock(CommonCookieAttributeHandler.class);
        Mockito.when((Object)h2.getAttributeName()).thenReturn((Object)"that");
        RFC6265CookieSpecBase cookiespec = new RFC6265CookieSpecBase(new CommonCookieAttributeHandler[]{h1, h2});
        CookieOrigin origin = new CookieOrigin("host", 80, "/path/", true);
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        cookiespec.validate((Cookie)cookie, origin);
        ((CommonCookieAttributeHandler)Mockito.verify((Object)h1)).validate((Cookie)cookie, origin);
        ((CommonCookieAttributeHandler)Mockito.verify((Object)h2)).validate((Cookie)cookie, origin);
    }

    @Test
    public void testMatchCookie() throws Exception {
        CommonCookieAttributeHandler h1 = (CommonCookieAttributeHandler)Mockito.mock(CommonCookieAttributeHandler.class);
        Mockito.when((Object)h1.getAttributeName()).thenReturn((Object)"this");
        CommonCookieAttributeHandler h2 = (CommonCookieAttributeHandler)Mockito.mock(CommonCookieAttributeHandler.class);
        Mockito.when((Object)h2.getAttributeName()).thenReturn((Object)"that");
        RFC6265CookieSpecBase cookiespec = new RFC6265CookieSpecBase(new CommonCookieAttributeHandler[]{h1, h2});
        CookieOrigin origin = new CookieOrigin("host", 80, "/path/", true);
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        Mockito.when((Object)h1.match((Cookie)cookie, origin)).thenReturn((Object)true);
        Mockito.when((Object)h2.match((Cookie)cookie, origin)).thenReturn((Object)true);
        Assert.assertTrue((boolean)cookiespec.match((Cookie)cookie, origin));
        ((CommonCookieAttributeHandler)Mockito.verify((Object)h1)).match((Cookie)cookie, origin);
        ((CommonCookieAttributeHandler)Mockito.verify((Object)h2)).match((Cookie)cookie, origin);
    }

    @Test
    public void testMatchCookieNoMatch() throws Exception {
        CommonCookieAttributeHandler h1 = (CommonCookieAttributeHandler)Mockito.mock(CommonCookieAttributeHandler.class);
        Mockito.when((Object)h1.getAttributeName()).thenReturn((Object)"this");
        CommonCookieAttributeHandler h2 = (CommonCookieAttributeHandler)Mockito.mock(CommonCookieAttributeHandler.class);
        Mockito.when((Object)h2.getAttributeName()).thenReturn((Object)"that");
        RFC6265CookieSpecBase cookiespec = new RFC6265CookieSpecBase(new CommonCookieAttributeHandler[]{h1, h2});
        CookieOrigin origin = new CookieOrigin("host", 80, "/path/", true);
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        Mockito.when((Object)h1.match((Cookie)cookie, origin)).thenReturn((Object)false);
        Mockito.when((Object)h2.match((Cookie)cookie, origin)).thenReturn((Object)false);
        Assert.assertFalse((boolean)cookiespec.match((Cookie)cookie, origin));
        ((CommonCookieAttributeHandler)Mockito.verify((Object)h1)).match((Cookie)cookie, origin);
        ((CommonCookieAttributeHandler)Mockito.verify((Object)h2, (VerificationMode)Mockito.never())).match((Cookie)cookie, origin);
    }

    @Test
    public void testLegacy() throws Exception {
        RFC6265CookieSpecBase cookiespec = new RFC6265CookieSpecBase(new CommonCookieAttributeHandler[0]);
        Assert.assertEquals((long)0L, (long)cookiespec.getVersion());
        Assert.assertEquals(null, (Object)cookiespec.getVersionHeader());
    }

    @Test
    public void testFormatCookiesBasics() throws Exception {
        BasicClientCookie cookie1 = new BasicClientCookie("name1", "value");
        RFC6265CookieSpecBase cookiespec = new RFC6265CookieSpecBase(new CommonCookieAttributeHandler[0]);
        List headers = cookiespec.formatCookies(Arrays.asList(cookie1));
        Assert.assertNotNull((Object)headers);
        Assert.assertEquals((long)1L, (long)headers.size());
        Header header = (Header)headers.get(0);
        Assert.assertEquals((Object)"Cookie", (Object)header.getName());
        Assert.assertEquals((Object)"name1=value", (Object)header.getValue());
    }

    @Test
    public void testFormatCookiesIllegalCharsInValue() throws Exception {
        BasicClientCookie cookie1 = new BasicClientCookie("name1", "value");
        BasicClientCookie cookie2 = new BasicClientCookie("name2", "some value");
        BasicClientCookie cookie3 = new BasicClientCookie("name3", "\"\\\"");
        RFC6265CookieSpecBase cookiespec = new RFC6265CookieSpecBase(new CommonCookieAttributeHandler[0]);
        List headers = cookiespec.formatCookies(Arrays.asList(cookie1, cookie2, cookie3));
        Assert.assertNotNull((Object)headers);
        Assert.assertEquals((long)1L, (long)headers.size());
        Header header = (Header)headers.get(0);
        Assert.assertEquals((Object)"Cookie", (Object)header.getName());
        Assert.assertEquals((Object)"name1=value; name2=\"some value\"; name3=\"\\\"\\\\\\\"\"", (Object)header.getValue());
    }

    @Test
    public void testParseCookieMultipleAttributes() throws Exception {
        CommonCookieAttributeHandler h1 = (CommonCookieAttributeHandler)Mockito.mock(CommonCookieAttributeHandler.class);
        Mockito.when((Object)h1.getAttributeName()).thenReturn((Object)"this");
        RFC6265CookieSpecBase cookiespec = new RFC6265CookieSpecBase(new CommonCookieAttributeHandler[]{h1});
        BasicHeader header = new BasicHeader("Set-Cookie", "name = value ; this = stuff; this = morestuff;");
        CookieOrigin origin = new CookieOrigin("host", 80, "/path/", true);
        cookiespec.parse((Header)header, origin);
        ((CommonCookieAttributeHandler)Mockito.verify((Object)h1)).parse((SetCookie)Mockito.any(), (String)Mockito.eq((Object)"morestuff"));
        ((CommonCookieAttributeHandler)Mockito.verify((Object)h1, (VerificationMode)Mockito.times((int)1))).parse((SetCookie)Mockito.any(), Mockito.anyString());
    }

    @Test
    public void testParseCookieMaxAgeOverExpires() throws Exception {
        CommonCookieAttributeHandler h1 = (CommonCookieAttributeHandler)Mockito.mock(CommonCookieAttributeHandler.class);
        Mockito.when((Object)h1.getAttributeName()).thenReturn((Object)"Expires");
        CommonCookieAttributeHandler h2 = (CommonCookieAttributeHandler)Mockito.mock(CommonCookieAttributeHandler.class);
        Mockito.when((Object)h2.getAttributeName()).thenReturn((Object)"Max-Age");
        RFC6265CookieSpecBase cookiespec = new RFC6265CookieSpecBase(new CommonCookieAttributeHandler[]{h1, h2});
        BasicHeader header = new BasicHeader("Set-Cookie", "name = value ; expires = stuff; max-age = otherstuff;");
        CookieOrigin origin = new CookieOrigin("host", 80, "/path/", true);
        cookiespec.parse((Header)header, origin);
        ((CommonCookieAttributeHandler)Mockito.verify((Object)h1, (VerificationMode)Mockito.never())).parse((SetCookie)Mockito.any(), Mockito.anyString());
        ((CommonCookieAttributeHandler)Mockito.verify((Object)h2)).parse((SetCookie)Mockito.any(), (String)Mockito.eq((Object)"otherstuff"));
    }
}

