/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.conn.util;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import org.apache.http.Consts;
import org.apache.http.conn.util.PublicSuffixList;
import org.apache.http.conn.util.PublicSuffixListParser;
import org.apache.http.conn.util.PublicSuffixMatcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestPublicSuffixMatcher {
    private static final String SOURCE_FILE = "suffixlist.txt";
    private PublicSuffixMatcher matcher;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Before
    public void setUp() throws Exception {
        PublicSuffixList suffixList;
        ClassLoader classLoader = this.getClass().getClassLoader();
        InputStream in = classLoader.getResourceAsStream(SOURCE_FILE);
        Assert.assertNotNull((Object)in);
        try {
            PublicSuffixListParser parser = new PublicSuffixListParser();
            suffixList = parser.parse((Reader)new InputStreamReader(in, Consts.UTF_8));
        }
        finally {
            in.close();
        }
        this.matcher = new PublicSuffixMatcher((Collection)suffixList.getRules(), (Collection)suffixList.getExceptions());
    }

    @Test
    public void testGetDomainRoot() throws Exception {
        Assert.assertEquals((Object)"example.xx", (Object)this.matcher.getDomainRoot("example.XX"));
        Assert.assertEquals((Object)"example.xx", (Object)this.matcher.getDomainRoot("www.example.XX"));
        Assert.assertEquals((Object)"example.xx", (Object)this.matcher.getDomainRoot("www.blah.blah.example.XX"));
        Assert.assertEquals(null, (Object)this.matcher.getDomainRoot("xx"));
        Assert.assertEquals(null, (Object)this.matcher.getDomainRoot("jp"));
        Assert.assertEquals(null, (Object)this.matcher.getDomainRoot("ac.jp"));
        Assert.assertEquals(null, (Object)this.matcher.getDomainRoot("any.tokyo.jp"));
        Assert.assertEquals((Object)"metro.tokyo.jp", (Object)this.matcher.getDomainRoot("metro.tokyo.jp"));
        Assert.assertEquals((Object)"blah.blah.tokyo.jp", (Object)this.matcher.getDomainRoot("blah.blah.tokyo.jp"));
        Assert.assertEquals((Object)"blah.ac.jp", (Object)this.matcher.getDomainRoot("blah.blah.ac.jp"));
        Assert.assertEquals((Object)"garbage", (Object)this.matcher.getDomainRoot("garbage"));
        Assert.assertEquals((Object)"garbage", (Object)this.matcher.getDomainRoot("garbage.garbage"));
        Assert.assertEquals((Object)"garbage", (Object)this.matcher.getDomainRoot("*.garbage.garbage"));
        Assert.assertEquals((Object)"garbage", (Object)this.matcher.getDomainRoot("*.garbage.garbage.garbage"));
    }

    @Test
    public void testMatch() throws Exception {
        Assert.assertTrue((boolean)this.matcher.matches(".jp"));
        Assert.assertTrue((boolean)this.matcher.matches(".ac.jp"));
        Assert.assertTrue((boolean)this.matcher.matches(".any.tokyo.jp"));
        Assert.assertFalse((boolean)this.matcher.matches(".metro.tokyo.jp"));
    }

    @Test
    public void testMatchUnicode() throws Exception {
        Assert.assertTrue((boolean)this.matcher.matches(".h\u00e5.no"));
        Assert.assertTrue((boolean)this.matcher.matches(".xn--h-2fa.no"));
        Assert.assertTrue((boolean)this.matcher.matches(".h\u00e5.no"));
        Assert.assertTrue((boolean)this.matcher.matches(".xn--h-2fa.no"));
    }
}

