/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client.integration;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.zip.Deflater;
import java.util.zip.GZIPOutputStream;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.localserver.LocalServerTestBase;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.util.EntityUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestContentCodings
extends LocalServerTestBase {
    @Test
    public void testResponseWithNoContent() throws Exception {
        this.serverBootstrap.registerHandler("*", new HttpRequestHandler(){

            public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
                response.setStatusCode(204);
            }
        });
        HttpHost target = this.start();
        HttpGet request = new HttpGet("/some-resource");
        CloseableHttpResponse response = this.httpclient.execute(target, (HttpRequest)request);
        Assert.assertEquals((long)204L, (long)response.getStatusLine().getStatusCode());
        Assert.assertNull((Object)response.getEntity());
    }

    @Test
    public void testDeflateSupportForServerReturningRfc1950Stream() throws Exception {
        String entityText = "Hello, this is some plain text coming back.";
        this.serverBootstrap.registerHandler("*", this.createDeflateEncodingRequestHandler("Hello, this is some plain text coming back.", false));
        HttpHost target = this.start();
        HttpGet request = new HttpGet("/some-resource");
        CloseableHttpResponse response = this.httpclient.execute(target, (HttpRequest)request);
        Assert.assertEquals((String)"The entity text is correctly transported", (Object)"Hello, this is some plain text coming back.", (Object)EntityUtils.toString((HttpEntity)response.getEntity()));
    }

    @Test
    public void testDeflateSupportForServerReturningRfc1951Stream() throws Exception {
        String entityText = "Hello, this is some plain text coming back.";
        this.serverBootstrap.registerHandler("*", this.createDeflateEncodingRequestHandler("Hello, this is some plain text coming back.", true));
        HttpHost target = this.start();
        HttpGet request = new HttpGet("/some-resource");
        CloseableHttpResponse response = this.httpclient.execute(target, (HttpRequest)request);
        Assert.assertEquals((String)"The entity text is correctly transported", (Object)"Hello, this is some plain text coming back.", (Object)EntityUtils.toString((HttpEntity)response.getEntity()));
    }

    @Test
    public void testGzipSupport() throws Exception {
        String entityText = "Hello, this is some plain text coming back.";
        this.serverBootstrap.registerHandler("*", this.createGzipEncodingRequestHandler("Hello, this is some plain text coming back."));
        HttpHost target = this.start();
        HttpGet request = new HttpGet("/some-resource");
        CloseableHttpResponse response = this.httpclient.execute(target, (HttpRequest)request);
        Assert.assertEquals((String)"The entity text is correctly transported", (Object)"Hello, this is some plain text coming back.", (Object)EntityUtils.toString((HttpEntity)response.getEntity()));
    }

    @Test
    public void testThreadSafetyOfContentCodings() throws Exception {
        String entityText = "Hello, this is some plain text coming back.";
        this.serverBootstrap.registerHandler("*", this.createGzipEncodingRequestHandler("Hello, this is some plain text coming back."));
        int clients = 100;
        this.connManager.setMaxTotal(100);
        HttpHost target = this.start();
        ExecutorService executor = Executors.newFixedThreadPool(100);
        CountDownLatch startGate = new CountDownLatch(1);
        CountDownLatch endGate = new CountDownLatch(100);
        ArrayList<WorkerTask> workers = new ArrayList<WorkerTask>();
        for (int i = 0; i < 100; ++i) {
            workers.add(new WorkerTask((HttpClient)this.httpclient, target, i % 2 == 0, startGate, endGate));
        }
        for (WorkerTask workerTask : workers) {
            executor.execute(workerTask);
        }
        startGate.countDown();
        endGate.await();
        for (WorkerTask workerTask : workers) {
            if (workerTask.isFailed()) {
                Assert.fail((String)"A worker failed");
            }
            Assert.assertEquals((Object)"Hello, this is some plain text coming back.", (Object)workerTask.getText());
        }
    }

    @Test
    public void testHttpEntityWriteToForGzip() throws Exception {
        String entityText = "Hello, this is some plain text coming back.";
        this.serverBootstrap.registerHandler("*", this.createGzipEncodingRequestHandler("Hello, this is some plain text coming back."));
        HttpHost target = this.start();
        HttpGet request = new HttpGet("/some-resource");
        CloseableHttpResponse response = this.httpclient.execute(target, (HttpRequest)request);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        response.getEntity().writeTo((OutputStream)out);
        Assert.assertEquals((Object)"Hello, this is some plain text coming back.", (Object)out.toString("utf-8"));
    }

    @Test
    public void testHttpEntityWriteToForDeflate() throws Exception {
        String entityText = "Hello, this is some plain text coming back.";
        this.serverBootstrap.registerHandler("*", this.createDeflateEncodingRequestHandler("Hello, this is some plain text coming back.", true));
        HttpHost target = this.start();
        HttpGet request = new HttpGet("/some-resource");
        CloseableHttpResponse response = this.httpclient.execute(target, (HttpRequest)request);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        response.getEntity().writeTo((OutputStream)out);
        Assert.assertEquals((Object)"Hello, this is some plain text coming back.", (Object)out.toString("utf-8"));
    }

    @Test
    public void gzipResponsesWorkWithBasicResponseHandler() throws Exception {
        String entityText = "Hello, this is some plain text coming back.";
        this.serverBootstrap.registerHandler("*", this.createGzipEncodingRequestHandler("Hello, this is some plain text coming back."));
        HttpHost target = this.start();
        HttpGet request = new HttpGet("/some-resource");
        String response = (String)this.httpclient.execute(target, (HttpRequest)request, (ResponseHandler)new BasicResponseHandler());
        Assert.assertEquals((String)"The entity text is correctly transported", (Object)"Hello, this is some plain text coming back.", (Object)response);
    }

    @Test
    public void deflateResponsesWorkWithBasicResponseHandler() throws Exception {
        String entityText = "Hello, this is some plain text coming back.";
        this.serverBootstrap.registerHandler("*", this.createDeflateEncodingRequestHandler("Hello, this is some plain text coming back.", false));
        HttpHost target = this.start();
        HttpGet request = new HttpGet("/some-resource");
        String response = (String)this.httpclient.execute(target, (HttpRequest)request, (ResponseHandler)new BasicResponseHandler());
        Assert.assertEquals((String)"The entity text is correctly transported", (Object)"Hello, this is some plain text coming back.", (Object)response);
    }

    private HttpRequestHandler createDeflateEncodingRequestHandler(final String entityText, final boolean rfc1951) {
        return new HttpRequestHandler(){

            public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
                Header[] acceptEncodings;
                response.setEntity((HttpEntity)new StringEntity(entityText));
                response.addHeader("Content-Type", "text/plain");
                for (Header header : acceptEncodings = request.getHeaders("Accept-Encoding")) {
                    for (HeaderElement element : header.getElements()) {
                        if (!"deflate".equalsIgnoreCase(element.getName())) continue;
                        response.addHeader("Content-Encoding", "deflate");
                        byte[] uncompressed = entityText.getBytes(Consts.UTF_8);
                        Deflater compressor = new Deflater(-1, rfc1951);
                        compressor.setInput(uncompressed);
                        compressor.finish();
                        byte[] output = new byte[100];
                        int compressedLength = compressor.deflate(output);
                        byte[] compressed = new byte[compressedLength];
                        System.arraycopy(output, 0, compressed, 0, compressedLength);
                        response.setEntity((HttpEntity)new InputStreamEntity((InputStream)new ByteArrayInputStream(compressed), (long)compressedLength));
                        return;
                    }
                }
            }
        };
    }

    private HttpRequestHandler createGzipEncodingRequestHandler(final String entityText) {
        return new HttpRequestHandler(){

            public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
                Header[] acceptEncodings;
                response.setEntity((HttpEntity)new StringEntity(entityText));
                response.addHeader("Content-Type", "text/plain");
                for (Header header : acceptEncodings = request.getHeaders("Accept-Encoding")) {
                    for (HeaderElement element : header.getElements()) {
                        int n;
                        if (!"gzip".equalsIgnoreCase(element.getName())) continue;
                        response.addHeader("Content-Encoding", "gzip");
                        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                        GZIPOutputStream out = new GZIPOutputStream(bytes);
                        ByteArrayInputStream uncompressed = new ByteArrayInputStream(entityText.getBytes(Consts.UTF_8));
                        byte[] buf = new byte[60];
                        while ((n = uncompressed.read(buf)) != -1) {
                            ((OutputStream)out).write(buf, 0, n);
                        }
                        ((OutputStream)out).close();
                        byte[] arr = bytes.toByteArray();
                        response.setEntity((HttpEntity)new InputStreamEntity((InputStream)new ByteArrayInputStream(arr), (long)arr.length));
                        return;
                    }
                }
            }
        };
    }

    class WorkerTask
    implements Runnable {
        private final HttpClient client;
        private final HttpHost target;
        private final HttpGet request;
        private final CountDownLatch startGate;
        private final CountDownLatch endGate;
        private boolean failed = false;
        private String text;

        WorkerTask(HttpClient client, HttpHost target, boolean identity, CountDownLatch startGate, CountDownLatch endGate) {
            this.client = client;
            this.target = target;
            this.request = new HttpGet("/some-resource");
            if (identity) {
                this.request.addHeader("Accept-Encoding", "identity");
            }
            this.startGate = startGate;
            this.endGate = endGate;
        }

        public String getText() {
            return this.text;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.startGate.await();
                try {
                    HttpResponse response = this.client.execute(this.target, (HttpRequest)this.request);
                    this.text = EntityUtils.toString((HttpEntity)response.getEntity());
                }
                catch (Exception e) {
                    this.failed = true;
                }
                finally {
                    this.endGate.countDown();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        boolean isFailed() {
            return this.failed;
        }
    }
}

