/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn;

import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.NoHttpResponseException;
import org.apache.http.ProtocolException;
import org.apache.http.impl.conn.DefaultHttpResponseParser;
import org.apache.http.impl.conn.SessionInputBufferMock;
import org.apache.http.io.SessionInputBuffer;
import org.apache.http.util.CharArrayBuffer;
import org.junit.Assert;
import org.junit.Test;

public class TestDefaultHttpResponseParser {
    @Test
    public void testResponseParsingWithSomeGarbage() throws Exception {
        String s = "garbage\r\ngarbage\r\nmore garbage\r\nHTTP/1.1 200 OK\r\nheader1: value1\r\nheader2: value2\r\n\r\n";
        SessionInputBufferMock inBuffer = new SessionInputBufferMock("garbage\r\ngarbage\r\nmore garbage\r\nHTTP/1.1 200 OK\r\nheader1: value1\r\nheader2: value2\r\n\r\n", Consts.ASCII);
        DefaultHttpResponseParser parser = new DefaultHttpResponseParser((SessionInputBuffer)inBuffer);
        HttpResponse response = (HttpResponse)parser.parse();
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)HttpVersion.HTTP_1_1, (Object)response.getProtocolVersion());
        Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        Header[] headers = response.getAllHeaders();
        Assert.assertNotNull((Object)headers);
        Assert.assertEquals((long)2L, (long)headers.length);
        Assert.assertEquals((Object)"header1", (Object)headers[0].getName());
        Assert.assertEquals((Object)"header2", (Object)headers[1].getName());
    }

    @Test(expected=ProtocolException.class)
    public void testResponseParsingWithTooMuchGarbage() throws Exception {
        String s = "garbage\r\ngarbage\r\nmore garbage\r\nHTTP/1.1 200 OK\r\nheader1: value1\r\nheader2: value2\r\n\r\n";
        SessionInputBufferMock inBuffer = new SessionInputBufferMock("garbage\r\ngarbage\r\nmore garbage\r\nHTTP/1.1 200 OK\r\nheader1: value1\r\nheader2: value2\r\n\r\n", Consts.ASCII);
        DefaultHttpResponseParser parser = new DefaultHttpResponseParser((SessionInputBuffer)inBuffer){

            protected boolean reject(CharArrayBuffer line, int count) {
                return count >= 2;
            }
        };
        parser.parse();
    }

    @Test(expected=NoHttpResponseException.class)
    public void testResponseParsingNoResponse() throws Exception {
        SessionInputBufferMock inBuffer = new SessionInputBufferMock("", Consts.ASCII);
        DefaultHttpResponseParser parser = new DefaultHttpResponseParser((SessionInputBuffer)inBuffer);
        parser.parse();
    }

    @Test(expected=ProtocolException.class)
    public void testResponseParsingOnlyGarbage() throws Exception {
        String s = "garbage\r\ngarbage\r\nmore garbage\r\na lot more garbage\r\n";
        SessionInputBufferMock inBuffer = new SessionInputBufferMock("garbage\r\ngarbage\r\nmore garbage\r\na lot more garbage\r\n", Consts.ASCII);
        DefaultHttpResponseParser parser = new DefaultHttpResponseParser((SessionInputBuffer)inBuffer);
        parser.parse();
    }
}

