/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.entity;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.GzipCompressingEntity;
import org.apache.http.client.entity.GzipDecompressingEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestGZip {
    @Test
    public void testBasic() throws Exception {
        String s = "some kind of text";
        StringEntity e = new StringEntity("some kind of text", ContentType.TEXT_PLAIN);
        e.setChunked(false);
        GzipCompressingEntity gzipe = new GzipCompressingEntity((HttpEntity)e);
        Assert.assertTrue((boolean)gzipe.isChunked());
        Assert.assertEquals((long)-1L, (long)gzipe.getContentLength());
        Assert.assertNotNull((Object)gzipe.getContentEncoding());
        Assert.assertEquals((Object)"gzip", (Object)gzipe.getContentEncoding().getValue());
    }

    @Test
    public void testCompressionDecompression() throws Exception {
        StringEntity in = new StringEntity("some kind of text", ContentType.TEXT_PLAIN);
        GzipCompressingEntity gzipe = new GzipCompressingEntity((HttpEntity)in);
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        gzipe.writeTo((OutputStream)buf);
        ByteArrayEntity out = new ByteArrayEntity(buf.toByteArray());
        GzipDecompressingEntity gunzipe = new GzipDecompressingEntity((HttpEntity)out);
        Assert.assertEquals((Object)"some kind of text", (Object)EntityUtils.toString((HttpEntity)gunzipe, (Charset)Consts.ASCII));
    }

    @Test
    public void testCompressionIOExceptionLeavesOutputStreamOpen() throws Exception {
        HttpEntity in = (HttpEntity)Mockito.mock(HttpEntity.class);
        ((HttpEntity)Mockito.doThrow((Throwable)new IOException("Ooopsie")).when((Object)in)).writeTo((OutputStream)Matchers.any());
        GzipCompressingEntity gzipe = new GzipCompressingEntity(in);
        OutputStream out = (OutputStream)Mockito.mock(OutputStream.class);
        try {
            gzipe.writeTo(out);
        }
        catch (IOException ex) {
            ((OutputStream)Mockito.verify((Object)out, (VerificationMode)Mockito.never())).close();
        }
    }

    @Test
    public void testDecompressionWithMultipleGZipStream() throws IOException {
        int[] data = new int[]{31, 139, 8, 8, 3, 241, 85, 90, 0, 3, 116, 101, 115, 116, 49, 0, 43, 46, 41, 74, 77, 204, 213, 53, 228, 2, 0, 3, 97, 240, 95, 9, 0, 0, 0, 31, 139, 8, 8, 8, 241, 85, 90, 0, 3, 116, 101, 115, 116, 50, 0, 43, 46, 41, 74, 77, 204, 213, 53, 226, 2, 0, 192, 50, 221, 116, 9, 0, 0, 0};
        byte[] bytes = new byte[data.length];
        for (int i = 0; i < data.length; ++i) {
            bytes[i] = (byte)(data[i] & 0xFF);
        }
        InputStreamEntity out = new InputStreamEntity((InputStream)new ByteArrayInputStream(bytes));
        GzipDecompressingEntity gunZipEntity = new GzipDecompressingEntity((HttpEntity)out);
        Assert.assertEquals((Object)"stream-1\nstream-2\n", (Object)EntityUtils.toString((HttpEntity)gunZipEntity, (Charset)Consts.ASCII));
    }
}

