/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.util.ArrayList;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.conn.SchemePortResolver;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.conn.SystemDefaultRoutePlanner;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestSystemDefaultRoutePlanner {
    private SchemePortResolver schemePortResolver;
    private ProxySelector proxySelector;
    private SystemDefaultRoutePlanner routePlanner;

    @Before
    public void setup() {
        this.schemePortResolver = (SchemePortResolver)Mockito.mock(SchemePortResolver.class);
        this.proxySelector = (ProxySelector)Mockito.mock(ProxySelector.class);
        this.routePlanner = new SystemDefaultRoutePlanner(this.schemePortResolver, this.proxySelector);
    }

    @Test
    public void testDirect() throws Exception {
        HttpHost target = new HttpHost("somehost", 80, "http");
        BasicHttpRequest request = new BasicHttpRequest("GET", "/", (ProtocolVersion)HttpVersion.HTTP_1_1);
        BasicHttpContext context = new BasicHttpContext();
        HttpRoute route = this.routePlanner.determineRoute(target, (HttpRequest)request, (HttpContext)context);
        Assert.assertEquals((Object)target, (Object)route.getTargetHost());
        Assert.assertEquals((long)1L, (long)route.getHopCount());
        Assert.assertFalse((boolean)route.isSecure());
        ((SchemePortResolver)Mockito.verify((Object)this.schemePortResolver, (VerificationMode)Mockito.never())).resolve((HttpHost)Matchers.any());
    }

    @Test
    public void testDirectDefaultPort() throws Exception {
        HttpHost target = new HttpHost("somehost", -1, "https");
        Mockito.when((Object)this.schemePortResolver.resolve(target)).thenReturn((Object)443);
        BasicHttpRequest request = new BasicHttpRequest("GET", "/", (ProtocolVersion)HttpVersion.HTTP_1_1);
        BasicHttpContext context = new BasicHttpContext();
        HttpRoute route = this.routePlanner.determineRoute(target, (HttpRequest)request, (HttpContext)context);
        Assert.assertEquals((Object)new HttpHost("somehost", 443, "https"), (Object)route.getTargetHost());
        Assert.assertEquals((long)1L, (long)route.getHopCount());
        Assert.assertTrue((boolean)route.isSecure());
    }

    @Test
    public void testProxy() throws Exception {
        InetAddress ia = InetAddress.getByAddress(new byte[]{127, 0, 0, 1});
        InetSocketAddress isa1 = new InetSocketAddress(ia, 11111);
        InetSocketAddress isa2 = new InetSocketAddress(ia, 22222);
        ArrayList<Proxy> proxies = new ArrayList<Proxy>(2);
        proxies.add(new Proxy(Proxy.Type.HTTP, isa1));
        proxies.add(new Proxy(Proxy.Type.HTTP, isa2));
        Mockito.when(this.proxySelector.select(new URI("http://somehost:80"))).thenReturn(proxies);
        HttpHost target = new HttpHost("somehost", 80, "http");
        BasicHttpRequest request = new BasicHttpRequest("GET", "/", (ProtocolVersion)HttpVersion.HTTP_1_1);
        BasicHttpContext context = new BasicHttpContext();
        HttpRoute route = this.routePlanner.determineRoute(target, (HttpRequest)request, (HttpContext)context);
        Assert.assertEquals((Object)target, (Object)route.getTargetHost());
        Assert.assertEquals((long)2L, (long)route.getHopCount());
        Assert.assertEquals((long)isa1.getPort(), (long)route.getProxyHost().getPort());
    }
}

