/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.execchain;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.http.HttpClientConnection;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.execchain.ConnectionHolder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestConnectionHolder {
    private Log log;
    private HttpClientConnectionManager mgr;
    private HttpClientConnection conn;
    private ConnectionHolder connHolder;

    @Before
    public void setup() {
        this.log = (Log)Mockito.mock(Log.class);
        this.mgr = (HttpClientConnectionManager)Mockito.mock(HttpClientConnectionManager.class);
        this.conn = (HttpClientConnection)Mockito.mock(HttpClientConnection.class);
        this.connHolder = new ConnectionHolder(this.log, this.mgr, this.conn);
    }

    @Test
    public void testAbortConnection() throws Exception {
        this.connHolder.abortConnection();
        Assert.assertTrue((boolean)this.connHolder.isReleased());
        ((HttpClientConnection)Mockito.verify((Object)this.conn)).shutdown();
        ((HttpClientConnectionManager)Mockito.verify((Object)this.mgr)).releaseConnection(this.conn, null, 0L, TimeUnit.MILLISECONDS);
        this.connHolder.abortConnection();
        ((HttpClientConnection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.times((int)1))).shutdown();
        ((HttpClientConnectionManager)Mockito.verify((Object)this.mgr, (VerificationMode)Mockito.times((int)1))).releaseConnection((HttpClientConnection)Mockito.any(), Mockito.anyObject(), Mockito.anyLong(), (TimeUnit)((Object)Mockito.any()));
    }

    @Test
    public void testAbortConnectionIOError() throws Exception {
        ((HttpClientConnection)Mockito.doThrow((Throwable)new IOException()).when((Object)this.conn)).shutdown();
        this.connHolder.abortConnection();
        Assert.assertTrue((boolean)this.connHolder.isReleased());
        ((HttpClientConnection)Mockito.verify((Object)this.conn)).shutdown();
        ((HttpClientConnectionManager)Mockito.verify((Object)this.mgr)).releaseConnection(this.conn, null, 0L, TimeUnit.MILLISECONDS);
    }

    @Test
    public void testCancell() throws Exception {
        Assert.assertTrue((boolean)this.connHolder.cancel());
        Assert.assertTrue((boolean)this.connHolder.isReleased());
        ((HttpClientConnection)Mockito.verify((Object)this.conn)).shutdown();
        ((HttpClientConnectionManager)Mockito.verify((Object)this.mgr)).releaseConnection(this.conn, null, 0L, TimeUnit.MILLISECONDS);
        Assert.assertFalse((boolean)this.connHolder.cancel());
        ((HttpClientConnection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.times((int)1))).shutdown();
        ((HttpClientConnectionManager)Mockito.verify((Object)this.mgr, (VerificationMode)Mockito.times((int)1))).releaseConnection((HttpClientConnection)Mockito.any(), Mockito.anyObject(), Mockito.anyLong(), (TimeUnit)((Object)Mockito.any()));
    }

    @Test
    public void testReleaseConnectionReusable() throws Exception {
        this.connHolder.setState((Object)"some state");
        this.connHolder.setValidFor(100L, TimeUnit.SECONDS);
        this.connHolder.markReusable();
        this.connHolder.releaseConnection();
        Assert.assertTrue((boolean)this.connHolder.isReleased());
        ((HttpClientConnection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.never())).close();
        ((HttpClientConnectionManager)Mockito.verify((Object)this.mgr)).releaseConnection(this.conn, (Object)"some state", 100L, TimeUnit.SECONDS);
        this.connHolder.releaseConnection();
        ((HttpClientConnectionManager)Mockito.verify((Object)this.mgr, (VerificationMode)Mockito.times((int)1))).releaseConnection((HttpClientConnection)Mockito.any(), Mockito.anyObject(), Mockito.anyLong(), (TimeUnit)((Object)Mockito.any()));
    }

    @Test
    public void testReleaseConnectionNonReusable() throws Exception {
        this.connHolder.setState((Object)"some state");
        this.connHolder.setValidFor(100L, TimeUnit.SECONDS);
        this.connHolder.markNonReusable();
        this.connHolder.releaseConnection();
        Assert.assertTrue((boolean)this.connHolder.isReleased());
        ((HttpClientConnection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.times((int)1))).close();
        ((HttpClientConnectionManager)Mockito.verify((Object)this.mgr)).releaseConnection(this.conn, null, 0L, TimeUnit.MILLISECONDS);
        this.connHolder.releaseConnection();
        ((HttpClientConnectionManager)Mockito.verify((Object)this.mgr, (VerificationMode)Mockito.times((int)1))).releaseConnection((HttpClientConnection)Mockito.any(), Mockito.anyObject(), Mockito.anyLong(), (TimeUnit)((Object)Mockito.any()));
    }
}

