/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.conn.ssl;

import java.io.ByteArrayInputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.net.ssl.SSLException;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.apache.http.conn.ssl.BrowserCompatHostnameVerifier;
import org.apache.http.conn.ssl.CertificatesToPlayWith;
import org.apache.http.conn.ssl.StrictHostnameVerifier;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.junit.Assert;
import org.junit.Test;

@Deprecated
public class TestHostnameVerifier {
    @Test
    public void testVerify() throws Exception {
        BrowserCompatHostnameVerifier DEFAULT = new BrowserCompatHostnameVerifier();
        StrictHostnameVerifier STRICT = new StrictHostnameVerifier();
        AllowAllHostnameVerifier ALLOW_ALL = new AllowAllHostnameVerifier();
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream in = new ByteArrayInputStream(CertificatesToPlayWith.X509_FOO);
        X509Certificate x509 = (X509Certificate)cf.generateCertificate(in);
        DEFAULT.verify("foo.com", x509);
        STRICT.verify("foo.com", x509);
        this.exceptionPlease((X509HostnameVerifier)DEFAULT, "a.foo.com", x509);
        this.exceptionPlease((X509HostnameVerifier)STRICT, "a.foo.com", x509);
        this.exceptionPlease((X509HostnameVerifier)DEFAULT, "bar.com", x509);
        this.exceptionPlease((X509HostnameVerifier)STRICT, "bar.com", x509);
        ALLOW_ALL.verify("foo.com", x509);
        ALLOW_ALL.verify("a.foo.com", x509);
        ALLOW_ALL.verify("bar.com", x509);
        in = new ByteArrayInputStream(CertificatesToPlayWith.X509_HANAKO);
        x509 = (X509Certificate)cf.generateCertificate(in);
        DEFAULT.verify("\u82b1\u5b50.co.jp", x509);
        STRICT.verify("\u82b1\u5b50.co.jp", x509);
        this.exceptionPlease((X509HostnameVerifier)DEFAULT, "a.\u82b1\u5b50.co.jp", x509);
        this.exceptionPlease((X509HostnameVerifier)STRICT, "a.\u82b1\u5b50.co.jp", x509);
        in = new ByteArrayInputStream(CertificatesToPlayWith.X509_FOO_BAR);
        x509 = (X509Certificate)cf.generateCertificate(in);
        this.exceptionPlease((X509HostnameVerifier)DEFAULT, "foo.com", x509);
        this.exceptionPlease((X509HostnameVerifier)STRICT, "foo.com", x509);
        this.exceptionPlease((X509HostnameVerifier)DEFAULT, "a.foo.com", x509);
        this.exceptionPlease((X509HostnameVerifier)STRICT, "a.foo.com", x509);
        DEFAULT.verify("bar.com", x509);
        STRICT.verify("bar.com", x509);
        this.exceptionPlease((X509HostnameVerifier)DEFAULT, "a.bar.com", x509);
        this.exceptionPlease((X509HostnameVerifier)STRICT, "a.bar.com", x509);
        in = new ByteArrayInputStream(CertificatesToPlayWith.X509_FOO_BAR_HANAKO);
        x509 = (X509Certificate)cf.generateCertificate(in);
        this.exceptionPlease((X509HostnameVerifier)DEFAULT, "foo.com", x509);
        this.exceptionPlease((X509HostnameVerifier)STRICT, "foo.com", x509);
        this.exceptionPlease((X509HostnameVerifier)DEFAULT, "a.foo.com", x509);
        this.exceptionPlease((X509HostnameVerifier)STRICT, "a.foo.com", x509);
        DEFAULT.verify("bar.com", x509);
        STRICT.verify("bar.com", x509);
        this.exceptionPlease((X509HostnameVerifier)DEFAULT, "a.bar.com", x509);
        this.exceptionPlease((X509HostnameVerifier)STRICT, "a.bar.com", x509);
        this.exceptionPlease((X509HostnameVerifier)DEFAULT, "a.\u82b1\u5b50.co.jp", x509);
        this.exceptionPlease((X509HostnameVerifier)STRICT, "a.\u82b1\u5b50.co.jp", x509);
        in = new ByteArrayInputStream(CertificatesToPlayWith.X509_NO_CNS_FOO);
        x509 = (X509Certificate)cf.generateCertificate(in);
        DEFAULT.verify("foo.com", x509);
        STRICT.verify("foo.com", x509);
        this.exceptionPlease((X509HostnameVerifier)DEFAULT, "a.foo.com", x509);
        this.exceptionPlease((X509HostnameVerifier)STRICT, "a.foo.com", x509);
        in = new ByteArrayInputStream(CertificatesToPlayWith.X509_NO_CNS_FOO);
        x509 = (X509Certificate)cf.generateCertificate(in);
        DEFAULT.verify("foo.com", x509);
        STRICT.verify("foo.com", x509);
        this.exceptionPlease((X509HostnameVerifier)DEFAULT, "a.foo.com", x509);
        this.exceptionPlease((X509HostnameVerifier)STRICT, "a.foo.com", x509);
        in = new ByteArrayInputStream(CertificatesToPlayWith.X509_THREE_CNS_FOO_BAR_HANAKO);
        x509 = (X509Certificate)cf.generateCertificate(in);
        this.exceptionPlease((X509HostnameVerifier)DEFAULT, "foo.com", x509);
        this.exceptionPlease((X509HostnameVerifier)STRICT, "foo.com", x509);
        this.exceptionPlease((X509HostnameVerifier)DEFAULT, "a.foo.com", x509);
        this.exceptionPlease((X509HostnameVerifier)STRICT, "a.foo.com", x509);
        this.exceptionPlease((X509HostnameVerifier)DEFAULT, "bar.com", x509);
        this.exceptionPlease((X509HostnameVerifier)STRICT, "bar.com", x509);
        this.exceptionPlease((X509HostnameVerifier)DEFAULT, "a.bar.com", x509);
        this.exceptionPlease((X509HostnameVerifier)STRICT, "a.bar.com", x509);
        DEFAULT.verify("\u82b1\u5b50.co.jp", x509);
        STRICT.verify("\u82b1\u5b50.co.jp", x509);
        this.exceptionPlease((X509HostnameVerifier)DEFAULT, "a.\u82b1\u5b50.co.jp", x509);
        this.exceptionPlease((X509HostnameVerifier)STRICT, "a.\u82b1\u5b50.co.jp", x509);
        in = new ByteArrayInputStream(CertificatesToPlayWith.X509_WILD_FOO);
        x509 = (X509Certificate)cf.generateCertificate(in);
        this.exceptionPlease((X509HostnameVerifier)DEFAULT, "foo.com", x509);
        this.exceptionPlease((X509HostnameVerifier)STRICT, "foo.com", x509);
        DEFAULT.verify("www.foo.com", x509);
        STRICT.verify("www.foo.com", x509);
        DEFAULT.verify("\u82b1\u5b50.foo.com", x509);
        STRICT.verify("\u82b1\u5b50.foo.com", x509);
        DEFAULT.verify("a.b.foo.com", x509);
        this.exceptionPlease((X509HostnameVerifier)STRICT, "a.b.foo.com", x509);
        in = new ByteArrayInputStream(CertificatesToPlayWith.X509_WILD_CO_JP);
        x509 = (X509Certificate)cf.generateCertificate(in);
        DEFAULT.verify("*.co.jp", x509);
        STRICT.verify("*.co.jp", x509);
        DEFAULT.verify("foo.co.jp", x509);
        this.exceptionPlease((X509HostnameVerifier)STRICT, "foo.co.jp", x509);
        DEFAULT.verify("\u82b1\u5b50.co.jp", x509);
        this.exceptionPlease((X509HostnameVerifier)STRICT, "\u82b1\u5b50.co.jp", x509);
        in = new ByteArrayInputStream(CertificatesToPlayWith.X509_WILD_FOO_BAR_HANAKO);
        x509 = (X509Certificate)cf.generateCertificate(in);
        this.exceptionPlease((X509HostnameVerifier)DEFAULT, "foo.com", x509);
        this.exceptionPlease((X509HostnameVerifier)STRICT, "foo.com", x509);
        this.exceptionPlease((X509HostnameVerifier)DEFAULT, "www.foo.com", x509);
        this.exceptionPlease((X509HostnameVerifier)STRICT, "www.foo.com", x509);
        this.exceptionPlease((X509HostnameVerifier)DEFAULT, "\u82b1\u5b50.foo.com", x509);
        this.exceptionPlease((X509HostnameVerifier)STRICT, "\u82b1\u5b50.foo.com", x509);
        this.exceptionPlease((X509HostnameVerifier)DEFAULT, "a.b.foo.com", x509);
        this.exceptionPlease((X509HostnameVerifier)STRICT, "a.b.foo.com", x509);
        this.exceptionPlease((X509HostnameVerifier)DEFAULT, "bar.com", x509);
        this.exceptionPlease((X509HostnameVerifier)STRICT, "bar.com", x509);
        DEFAULT.verify("www.bar.com", x509);
        STRICT.verify("www.bar.com", x509);
        DEFAULT.verify("\u82b1\u5b50.bar.com", x509);
        STRICT.verify("\u82b1\u5b50.bar.com", x509);
        DEFAULT.verify("a.b.bar.com", x509);
        this.exceptionPlease((X509HostnameVerifier)STRICT, "a.b.bar.com", x509);
        in = new ByteArrayInputStream(CertificatesToPlayWith.X509_MULTIPLE_VALUE_AVA);
        x509 = (X509Certificate)cf.generateCertificate(in);
        ALLOW_ALL.verify("repository.infonotary.com", x509);
        DEFAULT.verify("repository.infonotary.com", x509);
        STRICT.verify("repository.infonotary.com", x509);
    }

    @Test
    public void testSubjectAlt() throws Exception {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream in = new ByteArrayInputStream(CertificatesToPlayWith.X509_MULTIPLE_SUBJECT_ALT);
        X509Certificate x509 = (X509Certificate)cf.generateCertificate(in);
        BrowserCompatHostnameVerifier verifier = BrowserCompatHostnameVerifier.INSTANCE;
        Assert.assertEquals((Object)"CN=localhost, OU=Unknown, O=Unknown, L=Unknown, ST=Unknown, C=CH", (Object)x509.getSubjectDN().getName());
        verifier.verify("localhost.localdomain", x509);
        verifier.verify("127.0.0.1", x509);
        try {
            verifier.verify("localhost", x509);
            Assert.fail((String)"SSLException should have been thrown");
        }
        catch (SSLException sSLException) {
            // empty catch block
        }
        try {
            verifier.verify("local.host", x509);
            Assert.fail((String)"SSLException should have been thrown");
        }
        catch (SSLException sSLException) {
            // empty catch block
        }
        try {
            verifier.verify("127.0.0.2", x509);
            Assert.fail((String)"SSLException should have been thrown");
        }
        catch (SSLException sSLException) {
            // empty catch block
        }
    }

    public void exceptionPlease(X509HostnameVerifier hv, String host, X509Certificate x509) {
        try {
            hv.verify(host, x509);
            Assert.fail((String)("HostnameVerifier shouldn't allow [" + host + "]"));
        }
        catch (SSLException sSLException) {
            // empty catch block
        }
    }

    private void checkMatching(X509HostnameVerifier hv, String host, String[] cns, String[] alts, boolean shouldFail) {
        block3: {
            try {
                hv.verify(host, cns, alts);
                if (shouldFail) {
                    Assert.fail((String)("HostnameVerifier should not allow [" + host + "] to match " + Arrays.toString(cns) + " or " + Arrays.toString(alts)));
                }
            }
            catch (SSLException e) {
                if (shouldFail) break block3;
                Assert.fail((String)("HostnameVerifier should have allowed [" + host + "] to match " + Arrays.toString(cns) + " or " + Arrays.toString(alts)));
            }
        }
    }

    @Test
    public void testMatching() {
        String[] cns = new String[]{};
        String[] alt = new String[]{};
        BrowserCompatHostnameVerifier bhv = new BrowserCompatHostnameVerifier();
        StrictHostnameVerifier shv = new StrictHostnameVerifier();
        this.checkMatching((X509HostnameVerifier)bhv, "a.b.c", cns, alt, true);
        this.checkMatching((X509HostnameVerifier)shv, "a.b.c", cns, alt, true);
        cns = new String[]{"*.b.c"};
        this.checkMatching((X509HostnameVerifier)bhv, "a.b.c", cns, alt, false);
        this.checkMatching((X509HostnameVerifier)shv, "a.b.c", cns, alt, false);
        this.checkMatching((X509HostnameVerifier)bhv, "s.a.b.c", cns, alt, false);
        this.checkMatching((X509HostnameVerifier)shv, "s.a.b.c", cns, alt, true);
        cns = new String[]{};
        alt = new String[]{"dummy", "*.b.c"};
        this.checkMatching((X509HostnameVerifier)bhv, "a.b.c", cns, alt, false);
        this.checkMatching((X509HostnameVerifier)shv, "a.b.c", cns, alt, false);
        this.checkMatching((X509HostnameVerifier)bhv, "s.a.b.c", cns, alt, false);
        this.checkMatching((X509HostnameVerifier)shv, "s.a.b.c", cns, alt, true);
        alt = new String[]{"*.gov.uk"};
        this.checkMatching((X509HostnameVerifier)bhv, "a.gov.uk", cns, alt, false);
        this.checkMatching((X509HostnameVerifier)shv, "a.gov.uk", cns, alt, true);
        this.checkMatching((X509HostnameVerifier)bhv, "s.a.gov.uk", cns, alt, false);
        this.checkMatching((X509HostnameVerifier)shv, "s.a.gov.uk", cns, alt, true);
        alt = new String[]{"*.gov.com"};
        this.checkMatching((X509HostnameVerifier)bhv, "a.gov.com", cns, alt, false);
        this.checkMatching((X509HostnameVerifier)shv, "a.gov.com", cns, alt, false);
        this.checkMatching((X509HostnameVerifier)bhv, "s.a.gov.com", cns, alt, false);
        this.checkMatching((X509HostnameVerifier)shv, "s.a.gov.com", cns, alt, true);
        alt = new String[]{"a*.gov.uk"};
        this.checkMatching((X509HostnameVerifier)bhv, "a.gov.uk", cns, alt, false);
        this.checkMatching((X509HostnameVerifier)shv, "a.gov.uk", cns, alt, true);
        this.checkMatching((X509HostnameVerifier)bhv, "s.a.gov.uk", cns, alt, true);
        this.checkMatching((X509HostnameVerifier)shv, "s.a.gov.uk", cns, alt, true);
    }

    @Test
    public void testHTTPCLIENT_1316() throws Exception {
        String[] cns = new String[]{"2001:0db8:aaaa:bbbb:cccc:0:0:0001"};
        String[] alt = new String[]{};
        BrowserCompatHostnameVerifier bhv = new BrowserCompatHostnameVerifier();
        StrictHostnameVerifier shv = new StrictHostnameVerifier();
        this.checkMatching((X509HostnameVerifier)bhv, "2001:0db8:aaaa:bbbb:cccc:0:0:0001", cns, alt, false);
        this.checkMatching((X509HostnameVerifier)shv, "2001:0db8:aaaa:bbbb:cccc:0:0:0001", cns, alt, false);
        this.checkMatching((X509HostnameVerifier)bhv, "2001:0db8:aaaa:bbbb:cccc::1", cns, alt, false);
        this.checkMatching((X509HostnameVerifier)shv, "2001:0db8:aaaa:bbbb:cccc::1", cns, alt, false);
        this.checkMatching((X509HostnameVerifier)bhv, "2001:0db8:aaaa:bbbb:cccc::10", cns, alt, true);
        this.checkMatching((X509HostnameVerifier)shv, "2001:0db8:aaaa:bbbb:cccc::10", cns, alt, true);
    }

    @Test
    public void testHTTPCLIENT_1097() {
        String[] alt = new String[]{};
        BrowserCompatHostnameVerifier bhv = new BrowserCompatHostnameVerifier();
        StrictHostnameVerifier shv = new StrictHostnameVerifier();
        String[] cns = new String[]{"a*.b.c"};
        this.checkMatching((X509HostnameVerifier)bhv, "a.b.c", cns, alt, false);
        this.checkMatching((X509HostnameVerifier)shv, "a.b.c", cns, alt, false);
        this.checkMatching((X509HostnameVerifier)bhv, "a.a.b.c", cns, alt, false);
        this.checkMatching((X509HostnameVerifier)shv, "a.a.b.c", cns, alt, true);
    }

    @Test
    public void testHTTPCLIENT_1255() {
        BrowserCompatHostnameVerifier bhv = new BrowserCompatHostnameVerifier();
        StrictHostnameVerifier shv = new StrictHostnameVerifier();
        String[] cns = new String[]{"m*.a.b.c.com"};
        String[] alt = new String[]{};
        this.checkMatching((X509HostnameVerifier)bhv, "mail.a.b.c.com", cns, alt, false);
        this.checkMatching((X509HostnameVerifier)shv, "mail.a.b.c.com", cns, alt, false);
    }
}

