/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client.integration;

import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.http.Header;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.concurrent.Cancellable;
import org.apache.http.conn.ConnectionPoolTimeoutException;
import org.apache.http.conn.ConnectionRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.localserver.LocalServerTestBase;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.protocol.HttpRequestHandlerMapper;
import org.apache.http.protocol.UriHttpRequestHandlerMapper;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestAbortHandling
extends LocalServerTestBase {
    @Test
    public void testAbortRetry_HTTPCLIENT_1120() throws Exception {
        final CountDownLatch wait = new CountDownLatch(1);
        this.serverBootstrap.registerHandler("*", new HttpRequestHandler(){

            public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
                try {
                    wait.countDown();
                    Thread.sleep(2000L);
                    response.setStatusCode(200);
                    StringEntity entity = new StringEntity("Whatever");
                    response.setEntity((HttpEntity)entity);
                }
                catch (Exception e) {
                    response.setStatusCode(408);
                }
            }
        });
        HttpHost target = this.start();
        final HttpGet httpget = new HttpGet("/");
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    wait.await();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                httpget.abort();
            }
        };
        t.start();
        HttpClientContext context = HttpClientContext.create();
        try {
            this.httpclient.execute(target, (HttpRequest)httpget, (HttpContext)context);
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        HttpRequest reqWrapper = context.getRequest();
        Assert.assertNotNull((String)"Request should exist", (Object)reqWrapper);
    }

    @Test
    public void testAbortInAllocate() throws Exception {
        CountDownLatch connLatch = new CountDownLatch(1);
        CountDownLatch awaitLatch = new CountDownLatch(1);
        ConMan conMan = new ConMan(connLatch, awaitLatch);
        AtomicReference throwableRef = new AtomicReference();
        CountDownLatch getLatch = new CountDownLatch(1);
        this.clientBuilder.setConnectionManager((HttpClientConnectionManager)conMan);
        BasicHttpContext context = new BasicHttpContext();
        final HttpGet httpget = new HttpGet("http://www.example.com/a");
        this.start();
        new Thread(new Runnable((HttpContext)context, throwableRef, getLatch){
            final /* synthetic */ HttpContext val$context;
            final /* synthetic */ AtomicReference val$throwableRef;
            final /* synthetic */ CountDownLatch val$getLatch;
            {
                this.val$context = httpContext;
                this.val$throwableRef = atomicReference;
                this.val$getLatch = countDownLatch;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    TestAbortHandling.this.httpclient.execute((HttpUriRequest)httpget, this.val$context);
                }
                catch (Throwable t) {
                    this.val$throwableRef.set(t);
                }
                finally {
                    this.val$getLatch.countDown();
                }
            }
        }).start();
        Assert.assertTrue((String)"should have tried to get a connection", (boolean)connLatch.await(1L, TimeUnit.SECONDS));
        httpget.abort();
        Assert.assertTrue((String)"should have finished get request", (boolean)getLatch.await(1L, TimeUnit.SECONDS));
        Assert.assertTrue((String)("should be instanceof IOException, was: " + throwableRef.get()), (boolean)(throwableRef.get() instanceof IOException));
        Assert.assertTrue((String)("cause should be InterruptedException, was: " + ((Throwable)throwableRef.get()).getCause()), (boolean)(((Throwable)throwableRef.get()).getCause() instanceof InterruptedException));
    }

    @Test
    public void testAbortAfterAllocateBeforeRequest() throws Exception {
        this.serverBootstrap.registerHandler("*", (HttpRequestHandler)new BasicService());
        CountDownLatch releaseLatch = new CountDownLatch(1);
        AtomicReference throwableRef = new AtomicReference();
        CountDownLatch getLatch = new CountDownLatch(1);
        BasicHttpContext context = new BasicHttpContext();
        final CustomGet httpget = new CustomGet("a", releaseLatch);
        final HttpHost target = this.start();
        new Thread(new Runnable((HttpContext)context, throwableRef, getLatch){
            final /* synthetic */ HttpContext val$context;
            final /* synthetic */ AtomicReference val$throwableRef;
            final /* synthetic */ CountDownLatch val$getLatch;
            {
                this.val$context = httpContext;
                this.val$throwableRef = atomicReference;
                this.val$getLatch = countDownLatch;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    TestAbortHandling.this.httpclient.execute(target, (HttpRequest)httpget, this.val$context);
                }
                catch (Throwable t) {
                    this.val$throwableRef.set(t);
                }
                finally {
                    this.val$getLatch.countDown();
                }
            }
        }).start();
        Thread.sleep(100L);
        httpget.abort();
        releaseLatch.countDown();
        Assert.assertTrue((String)"should have finished get request", (boolean)getLatch.await(1L, TimeUnit.SECONDS));
        Assert.assertTrue((String)("should be instanceof IOException, was: " + throwableRef.get()), (boolean)(throwableRef.get() instanceof IOException));
    }

    @Test
    public void testAbortBeforeExecute() throws Exception {
        this.serverBootstrap.registerHandler("*", (HttpRequestHandler)new BasicService());
        AtomicReference throwableRef = new AtomicReference();
        CountDownLatch getLatch = new CountDownLatch(1);
        final CountDownLatch startLatch = new CountDownLatch(1);
        BasicHttpContext context = new BasicHttpContext();
        final HttpGet httpget = new HttpGet("a");
        final HttpHost target = this.start();
        new Thread(new Runnable((HttpContext)context, throwableRef, getLatch){
            final /* synthetic */ HttpContext val$context;
            final /* synthetic */ AtomicReference val$throwableRef;
            final /* synthetic */ CountDownLatch val$getLatch;
            {
                this.val$context = httpContext;
                this.val$throwableRef = atomicReference;
                this.val$getLatch = countDownLatch2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    try {
                        if (!startLatch.await(1L, TimeUnit.SECONDS)) {
                            throw new RuntimeException("Took too long to start!");
                        }
                    }
                    catch (InterruptedException interrupted) {
                        throw new RuntimeException("Never started!", interrupted);
                    }
                    TestAbortHandling.this.httpclient.execute(target, (HttpRequest)httpget, this.val$context);
                }
                catch (Throwable t) {
                    this.val$throwableRef.set(t);
                }
                finally {
                    this.val$getLatch.countDown();
                }
            }
        }).start();
        httpget.abort();
        startLatch.countDown();
        Assert.assertTrue((String)"should have finished get request", (boolean)getLatch.await(1L, TimeUnit.SECONDS));
        Assert.assertTrue((String)("should be instanceof IOException, was: " + throwableRef.get()), (boolean)(throwableRef.get() instanceof IOException));
    }

    @Test
    public void testAbortAfterRedirectedRoute() throws Exception {
        UriHttpRequestHandlerMapper reqistry = new UriHttpRequestHandlerMapper();
        this.serverBootstrap.setHandlerMapper((HttpRequestHandlerMapper)reqistry);
        CountDownLatch connLatch = new CountDownLatch(1);
        CountDownLatch awaitLatch = new CountDownLatch(1);
        ConnMan4 conMan = new ConnMan4(connLatch, awaitLatch);
        AtomicReference throwableRef = new AtomicReference();
        CountDownLatch getLatch = new CountDownLatch(1);
        this.clientBuilder.setConnectionManager((HttpClientConnectionManager)conMan);
        BasicHttpContext context = new BasicHttpContext();
        final HttpGet httpget = new HttpGet("a");
        final HttpHost target = this.start();
        reqistry.register("*", (HttpRequestHandler)new BasicRedirectService(target.getPort()));
        new Thread(new Runnable((HttpContext)context, throwableRef, getLatch){
            final /* synthetic */ HttpContext val$context;
            final /* synthetic */ AtomicReference val$throwableRef;
            final /* synthetic */ CountDownLatch val$getLatch;
            {
                this.val$context = httpContext;
                this.val$throwableRef = atomicReference;
                this.val$getLatch = countDownLatch;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    HttpHost host = new HttpHost("127.0.0.1", target.getPort());
                    TestAbortHandling.this.httpclient.execute(host, (HttpRequest)httpget, this.val$context);
                }
                catch (Throwable t) {
                    this.val$throwableRef.set(t);
                }
                finally {
                    this.val$getLatch.countDown();
                }
            }
        }).start();
        Assert.assertTrue((String)"should have tried to get a connection", (boolean)connLatch.await(1L, TimeUnit.SECONDS));
        httpget.abort();
        Assert.assertTrue((String)"should have finished get request", (boolean)getLatch.await(1L, TimeUnit.SECONDS));
        Assert.assertTrue((String)("should be instanceof IOException, was: " + throwableRef.get()), (boolean)(throwableRef.get() instanceof IOException));
        Assert.assertTrue((String)("cause should be InterruptedException, was: " + ((Throwable)throwableRef.get()).getCause()), (boolean)(((Throwable)throwableRef.get()).getCause() instanceof InterruptedException));
    }

    @Test
    public void testSocketConnectFailureReleasesConnection() throws Exception {
        HttpClientConnection conn = (HttpClientConnection)Mockito.mock(HttpClientConnection.class);
        ConnectionRequest connrequest = (ConnectionRequest)Mockito.mock(ConnectionRequest.class);
        Mockito.when((Object)connrequest.get((long)Mockito.anyInt(), (TimeUnit)((Object)Mockito.any(TimeUnit.class)))).thenReturn((Object)conn);
        HttpClientConnectionManager connmgr = (HttpClientConnectionManager)Mockito.mock(HttpClientConnectionManager.class);
        ((HttpClientConnectionManager)Mockito.doThrow((Throwable)new ConnectException()).when((Object)connmgr)).connect((HttpClientConnection)Mockito.any(HttpClientConnection.class), (HttpRoute)Mockito.any(HttpRoute.class), Mockito.anyInt(), (HttpContext)Mockito.any(HttpContext.class));
        Mockito.when((Object)connmgr.requestConnection((HttpRoute)Mockito.any(HttpRoute.class), Mockito.any())).thenReturn((Object)connrequest);
        CloseableHttpClient client = HttpClients.custom().setConnectionManager(connmgr).build();
        BasicHttpContext context = new BasicHttpContext();
        HttpGet httpget = new HttpGet("http://www.example.com/a");
        try {
            client.execute((HttpUriRequest)httpget, (HttpContext)context);
            Assert.fail((String)"expected IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ((HttpClientConnectionManager)Mockito.verify((Object)connmgr)).releaseConnection(conn, null, 0L, TimeUnit.MILLISECONDS);
    }

    private static class CustomGet
    extends HttpGet {
        private final CountDownLatch releaseTriggerLatch;

        public CustomGet(String uri, CountDownLatch releaseTriggerLatch) {
            super(uri);
            this.releaseTriggerLatch = releaseTriggerLatch;
        }

        public void setCancellable(Cancellable cancellable) {
            try {
                if (!this.releaseTriggerLatch.await(1L, TimeUnit.SECONDS)) {
                    throw new RuntimeException("Waited too long...");
                }
            }
            catch (InterruptedException ie) {
                throw new RuntimeException(ie);
            }
            super.setCancellable(cancellable);
        }
    }

    static class ConMan
    implements HttpClientConnectionManager {
        private final CountDownLatch connLatch;
        private final CountDownLatch awaitLatch;

        public ConMan(CountDownLatch connLatch, CountDownLatch awaitLatch) {
            this.connLatch = connLatch;
            this.awaitLatch = awaitLatch;
        }

        public void closeIdleConnections(long idletime, TimeUnit timeUnit) {
            throw new UnsupportedOperationException("just a mockup");
        }

        public void closeExpiredConnections() {
            throw new UnsupportedOperationException("just a mockup");
        }

        public HttpClientConnection getConnection(HttpRoute route, long timeout, TimeUnit timeUnit) {
            throw new UnsupportedOperationException("just a mockup");
        }

        public ConnectionRequest requestConnection(HttpRoute route, Object state) {
            final Thread currentThread = Thread.currentThread();
            return new ConnectionRequest(){

                public boolean cancel() {
                    currentThread.interrupt();
                    return true;
                }

                public HttpClientConnection get(long timeout, TimeUnit timeUnit) throws InterruptedException, ConnectionPoolTimeoutException {
                    ConMan.this.connLatch.countDown();
                    if (!ConMan.this.awaitLatch.await(timeout > 0L ? timeout : Integer.MAX_VALUE, timeUnit)) {
                        throw new ConnectionPoolTimeoutException();
                    }
                    return (HttpClientConnection)Mockito.mock(HttpClientConnection.class);
                }
            };
        }

        public void shutdown() {
        }

        public void close() {
        }

        public void releaseConnection(HttpClientConnection conn, Object newState, long validDuration, TimeUnit timeUnit) {
            throw new UnsupportedOperationException("just a mockup");
        }

        public void connect(HttpClientConnection conn, HttpRoute route, int connectTimeout, HttpContext context) throws IOException {
            throw new UnsupportedOperationException("just a mockup");
        }

        public void upgrade(HttpClientConnection conn, HttpRoute route, HttpContext context) throws IOException {
            throw new UnsupportedOperationException("just a mockup");
        }

        public void routeComplete(HttpClientConnection conn, HttpRoute route, HttpContext context) throws IOException {
            throw new UnsupportedOperationException("just a mockup");
        }

        public void connect(HttpClientConnection conn, HttpHost host, InetSocketAddress localAddress, int connectTimeout, HttpContext context) {
            throw new UnsupportedOperationException("just a mockup");
        }

        public void upgrade(HttpClientConnection conn, HttpHost host, HttpContext context) {
            throw new UnsupportedOperationException("just a mockup");
        }
    }

    private static class ConnMan4
    extends PoolingHttpClientConnectionManager {
        private final CountDownLatch connLatch;
        private final CountDownLatch awaitLatch;

        public ConnMan4(CountDownLatch connLatch, CountDownLatch awaitLatch) {
            this.connLatch = connLatch;
            this.awaitLatch = awaitLatch;
        }

        public ConnectionRequest requestConnection(HttpRoute route, Object state) {
            if (route.getTargetHost().getHostName().equals("localhost")) {
                final Thread currentThread = Thread.currentThread();
                return new ConnectionRequest(){

                    public boolean cancel() {
                        currentThread.interrupt();
                        return true;
                    }

                    public HttpClientConnection get(long timeout, TimeUnit timeUnit) throws InterruptedException, ConnectionPoolTimeoutException {
                        ConnMan4.this.connLatch.countDown();
                        if (!ConnMan4.this.awaitLatch.await(timeout > 0L ? timeout : Integer.MAX_VALUE, timeUnit)) {
                            throw new ConnectionPoolTimeoutException();
                        }
                        return (HttpClientConnection)Mockito.mock(HttpClientConnection.class);
                    }
                };
            }
            return super.requestConnection(route, state);
        }
    }

    private static class BasicRedirectService
    implements HttpRequestHandler {
        private final int statuscode = 303;
        private final int port;

        public BasicRedirectService(int port) {
            this.port = port;
        }

        public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            response.setStatusLine(ver, this.statuscode);
            response.addHeader((Header)new BasicHeader("Location", "http://localhost:" + this.port + "/newlocation/"));
            response.addHeader((Header)new BasicHeader("Connection", "close"));
        }
    }

    private static class BasicService
    implements HttpRequestHandler {
        private BasicService() {
        }

        public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
            response.setStatusCode(200);
            response.setEntity((HttpEntity)new StringEntity("Hello World"));
        }
    }
}

