/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.cookie;

import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.cookie.SetCookie;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.impl.cookie.RFC2109DomainHandler;
import org.apache.http.impl.cookie.RFC2109VersionHandler;
import org.junit.Assert;
import org.junit.Test;

public class TestRFC2109CookieAttribHandlers {
    @Test
    public void testRFC2109DomainParse() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        RFC2109DomainHandler h = new RFC2109DomainHandler();
        h.parse((SetCookie)cookie, "somehost");
        Assert.assertEquals((Object)"somehost", (Object)cookie.getDomain());
        try {
            h.parse((SetCookie)cookie, null);
            Assert.fail((String)"MalformedCookieException should have been thrown");
        }
        catch (MalformedCookieException malformedCookieException) {
            // empty catch block
        }
        try {
            h.parse((SetCookie)cookie, "  ");
            Assert.fail((String)"MalformedCookieException should have been thrown");
        }
        catch (MalformedCookieException malformedCookieException) {
            // empty catch block
        }
    }

    @Test
    public void testRFC2109DomainValidate1() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        CookieOrigin origin = new CookieOrigin("somehost", 80, "/", false);
        RFC2109DomainHandler h = new RFC2109DomainHandler();
        cookie.setDomain("somehost");
        h.validate((Cookie)cookie, origin);
        cookie.setDomain("otherhost");
        try {
            h.validate((Cookie)cookie, origin);
            Assert.fail((String)"MalformedCookieException should have been thrown");
        }
        catch (MalformedCookieException malformedCookieException) {
            // empty catch block
        }
        cookie.setDomain(null);
        try {
            h.validate((Cookie)cookie, origin);
            Assert.fail((String)"MalformedCookieException should have been thrown");
        }
        catch (MalformedCookieException malformedCookieException) {
            // empty catch block
        }
    }

    @Test
    public void testRFC2109DomainValidate2() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        CookieOrigin origin = new CookieOrigin("www.somedomain.com", 80, "/", false);
        RFC2109DomainHandler h = new RFC2109DomainHandler();
        cookie.setDomain(".somedomain.com");
        h.validate((Cookie)cookie, origin);
        cookie.setDomain(".otherdomain.com");
        try {
            h.validate((Cookie)cookie, origin);
            Assert.fail((String)"MalformedCookieException should have been thrown");
        }
        catch (MalformedCookieException malformedCookieException) {
            // empty catch block
        }
        cookie.setDomain("www.otherdomain.com");
        try {
            h.validate((Cookie)cookie, origin);
            Assert.fail((String)"MalformedCookieException should have been thrown");
        }
        catch (MalformedCookieException malformedCookieException) {
            // empty catch block
        }
    }

    @Test
    public void testRFC2109DomainValidate3() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        CookieOrigin origin = new CookieOrigin("www.a.com", 80, "/", false);
        RFC2109DomainHandler h = new RFC2109DomainHandler();
        cookie.setDomain(".a.com");
        h.validate((Cookie)cookie, origin);
        cookie.setDomain(".com");
        try {
            h.validate((Cookie)cookie, origin);
            Assert.fail((String)"MalformedCookieException should have been thrown");
        }
        catch (MalformedCookieException malformedCookieException) {
            // empty catch block
        }
    }

    @Test
    public void testRFC2109DomainValidate4() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        CookieOrigin origin = new CookieOrigin("www.a.b.c", 80, "/", false);
        RFC2109DomainHandler h = new RFC2109DomainHandler();
        cookie.setDomain(".a.b.c");
        h.validate((Cookie)cookie, origin);
        cookie.setDomain(".b.c");
        try {
            h.validate((Cookie)cookie, origin);
            Assert.fail((String)"MalformedCookieException should have been thrown");
        }
        catch (MalformedCookieException malformedCookieException) {
            // empty catch block
        }
        cookie.setDomain(".a.a.b.c");
        try {
            h.validate((Cookie)cookie, origin);
            Assert.fail((String)"MalformedCookieException should have been thrown");
        }
        catch (MalformedCookieException malformedCookieException) {
            // empty catch block
        }
    }

    @Test
    public void testRFC2109DomainMatch1() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        CookieOrigin origin = new CookieOrigin("www.somedomain.com", 80, "/", false);
        RFC2109DomainHandler h = new RFC2109DomainHandler();
        cookie.setDomain(null);
        Assert.assertFalse((boolean)h.match((Cookie)cookie, origin));
        cookie.setDomain(".somedomain.com");
        Assert.assertTrue((boolean)h.match((Cookie)cookie, origin));
    }

    @Test
    public void testRFC2109DomainMatch2() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        CookieOrigin origin = new CookieOrigin("www.whatever.somedomain.com", 80, "/", false);
        RFC2109DomainHandler h = new RFC2109DomainHandler();
        cookie.setDomain(".somedomain.com");
        Assert.assertTrue((boolean)h.match((Cookie)cookie, origin));
    }

    @Test
    public void testRFC2109DomainMatch3() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        CookieOrigin origin = new CookieOrigin("somedomain.com", 80, "/", false);
        RFC2109DomainHandler h = new RFC2109DomainHandler();
        cookie.setDomain("somedomain.com");
        Assert.assertTrue((boolean)h.match((Cookie)cookie, origin));
    }

    @Test
    public void testRFC2109DomainMatch4() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        CookieOrigin origin = new CookieOrigin("www.somedomain.com", 80, "/", false);
        RFC2109DomainHandler h = new RFC2109DomainHandler();
        cookie.setDomain("somedomain.com");
        Assert.assertFalse((boolean)h.match((Cookie)cookie, origin));
    }

    @Test
    public void testRFC2109DomainInvalidInput() throws Exception {
        RFC2109DomainHandler h = new RFC2109DomainHandler();
        try {
            h.parse(null, null);
            Assert.fail((String)"IllegalArgumentException must have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            h.validate(null, null);
            Assert.fail((String)"IllegalArgumentException must have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            h.validate((Cookie)new BasicClientCookie("name", "value"), null);
            Assert.fail((String)"IllegalArgumentException must have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            h.match(null, null);
            Assert.fail((String)"IllegalArgumentException must have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            h.match((Cookie)new BasicClientCookie("name", "value"), null);
            Assert.fail((String)"IllegalArgumentException must have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testRFC2109VersionParse() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        RFC2109VersionHandler h = new RFC2109VersionHandler();
        h.parse((SetCookie)cookie, "12");
        Assert.assertEquals((long)12L, (long)cookie.getVersion());
    }

    @Test
    public void testRFC2109VersionParseInvalid() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        RFC2109VersionHandler h = new RFC2109VersionHandler();
        try {
            h.parse((SetCookie)cookie, "garbage");
            Assert.fail((String)"MalformedCookieException must have been thrown");
        }
        catch (MalformedCookieException malformedCookieException) {
            // empty catch block
        }
        try {
            h.parse((SetCookie)cookie, null);
            Assert.fail((String)"MalformedCookieException must have been thrown");
        }
        catch (MalformedCookieException malformedCookieException) {
            // empty catch block
        }
        try {
            h.parse((SetCookie)cookie, "  ");
            Assert.fail((String)"MalformedCookieException must have been thrown");
        }
        catch (MalformedCookieException malformedCookieException) {
            // empty catch block
        }
    }

    @Test
    public void testRFC2109VersionValidate() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        CookieOrigin origin = new CookieOrigin("somedomain.com", 80, "/", false);
        RFC2109VersionHandler h = new RFC2109VersionHandler();
        cookie.setVersion(12);
        h.validate((Cookie)cookie, origin);
        cookie.setVersion(-12);
        try {
            h.validate((Cookie)cookie, origin);
            Assert.fail((String)"MalformedCookieException must have been thrown");
        }
        catch (MalformedCookieException malformedCookieException) {
            // empty catch block
        }
    }

    @Test
    public void testRFC2109VersionInvalidInput() throws Exception {
        RFC2109VersionHandler h = new RFC2109VersionHandler();
        try {
            h.parse(null, null);
            Assert.fail((String)"IllegalArgumentException must have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            h.validate(null, null);
            Assert.fail((String)"IllegalArgumentException must have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

