/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.auth;

import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.junit.Assert;
import org.junit.Test;

public class TestAuthScope {
    @Test
    public void testBasics() {
        AuthScope authscope = new AuthScope("somehost", 80, "somerealm", "somescheme");
        Assert.assertEquals((Object)"SOMESCHEME", (Object)authscope.getScheme());
        Assert.assertEquals((Object)"somehost", (Object)authscope.getHost());
        Assert.assertEquals((long)80L, (long)authscope.getPort());
        Assert.assertEquals((Object)"somerealm", (Object)authscope.getRealm());
        Assert.assertEquals((Object)"SOMESCHEME 'somerealm'@somehost:80", (Object)authscope.toString());
    }

    @Test
    public void testBasicsOptionalRealm() {
        AuthScope authscope = new AuthScope("somehost", 80, AuthScope.ANY_REALM, "somescheme");
        Assert.assertEquals((Object)"SOMESCHEME", (Object)authscope.getScheme());
        Assert.assertEquals((Object)"somehost", (Object)authscope.getHost());
        Assert.assertEquals((long)80L, (long)authscope.getPort());
        Assert.assertEquals(null, (Object)authscope.getRealm());
        Assert.assertEquals((Object)"SOMESCHEME <any realm>@somehost:80", (Object)authscope.toString());
    }

    @Test
    public void testBasicsOptionalScheme() {
        AuthScope authscope = new AuthScope("somehost", 80, AuthScope.ANY_REALM, AuthScope.ANY_SCHEME);
        Assert.assertEquals(null, (Object)authscope.getScheme());
        Assert.assertEquals((Object)"somehost", (Object)authscope.getHost());
        Assert.assertEquals((long)80L, (long)authscope.getPort());
        Assert.assertEquals(null, (Object)authscope.getRealm());
        Assert.assertEquals((Object)"<any realm>@somehost:80", (Object)authscope.toString());
    }

    @Test
    public void testBasicsOptionalPort() {
        AuthScope authscope = new AuthScope("somehost", -1, AuthScope.ANY_REALM, AuthScope.ANY_SCHEME);
        Assert.assertEquals(null, (Object)authscope.getScheme());
        Assert.assertEquals((Object)"somehost", (Object)authscope.getHost());
        Assert.assertEquals((long)-1L, (long)authscope.getPort());
        Assert.assertEquals(null, (Object)authscope.getRealm());
        Assert.assertEquals((Object)"<any realm>@somehost", (Object)authscope.toString());
    }

    @Test
    public void testByOrigin() {
        HttpHost host = new HttpHost("somehost", 8080, "http");
        AuthScope authscope = new AuthScope(host);
        Assert.assertEquals(null, (Object)authscope.getScheme());
        Assert.assertEquals((Object)"somehost", (Object)authscope.getHost());
        Assert.assertEquals((long)8080L, (long)authscope.getPort());
        Assert.assertEquals(null, (Object)authscope.getRealm());
        Assert.assertEquals((Object)host, (Object)authscope.getOrigin());
        Assert.assertEquals((Object)"<any realm>@somehost:8080", (Object)authscope.toString());
    }

    @Test
    public void testMixedCaseHostname() {
        AuthScope authscope = new AuthScope("SomeHost", 80);
        Assert.assertEquals(null, (Object)authscope.getScheme());
        Assert.assertEquals((Object)"somehost", (Object)authscope.getHost());
        Assert.assertEquals((long)80L, (long)authscope.getPort());
        Assert.assertEquals(null, (Object)authscope.getRealm());
        Assert.assertEquals((Object)"<any realm>@somehost:80", (Object)authscope.toString());
    }

    public void testByOriginMixedCaseHostname() throws Exception {
        HttpHost host = new HttpHost("SomeHost", 8080, "http");
        AuthScope authscope = new AuthScope(host);
        Assert.assertEquals((Object)"somehost", (Object)authscope.getHost());
        Assert.assertEquals((Object)host, (Object)authscope.getOrigin());
    }

    @Test
    public void testBasicsOptionalHost() {
        AuthScope authscope = new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM, AuthScope.ANY_SCHEME);
        Assert.assertEquals(null, (Object)authscope.getScheme());
        Assert.assertEquals(null, (Object)authscope.getHost());
        Assert.assertEquals((long)-1L, (long)authscope.getPort());
        Assert.assertEquals(null, (Object)authscope.getRealm());
        Assert.assertEquals((Object)"<any realm>", (Object)authscope.toString());
    }

    @Test
    public void testScopeMatching() {
        AuthScope authscope1 = new AuthScope("somehost", 80, "somerealm", "somescheme");
        AuthScope authscope2 = new AuthScope("someotherhost", 80, "somerealm", "somescheme");
        Assert.assertTrue((authscope1.match(authscope2) < 0 ? 1 : 0) != 0);
        int m1 = authscope1.match(new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM, "somescheme"));
        int m2 = authscope1.match(new AuthScope(AuthScope.ANY_HOST, -1, "somerealm", AuthScope.ANY_SCHEME));
        Assert.assertTrue((m2 > m1 ? 1 : 0) != 0);
        m1 = authscope1.match(new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM, "somescheme"));
        m2 = authscope1.match(new AuthScope(AuthScope.ANY_HOST, -1, "somerealm", AuthScope.ANY_SCHEME));
        Assert.assertTrue((m2 > m1 ? 1 : 0) != 0);
        m1 = authscope1.match(new AuthScope(AuthScope.ANY_HOST, -1, "somerealm", "somescheme"));
        m2 = authscope1.match(new AuthScope(AuthScope.ANY_HOST, 80, AuthScope.ANY_REALM, AuthScope.ANY_SCHEME));
        Assert.assertTrue((m2 > m1 ? 1 : 0) != 0);
        m1 = authscope1.match(new AuthScope(AuthScope.ANY_HOST, 80, "somerealm", "somescheme"));
        m2 = authscope1.match(new AuthScope("somehost", -1, AuthScope.ANY_REALM, AuthScope.ANY_SCHEME));
        Assert.assertTrue((m2 > m1 ? 1 : 0) != 0);
        m1 = authscope1.match(AuthScope.ANY);
        m2 = authscope1.match(new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM, "somescheme"));
        Assert.assertTrue((m2 > m1 ? 1 : 0) != 0);
    }

    @Test
    public void testEquals() {
        AuthScope authscope1 = new AuthScope("somehost", 80, "somerealm", "somescheme");
        AuthScope authscope2 = new AuthScope("someotherhost", 80, "somerealm", "somescheme");
        AuthScope authscope3 = new AuthScope("somehost", 80, "somerealm", "somescheme");
        AuthScope authscope4 = new AuthScope("somehost", 8080, "somerealm", "somescheme");
        AuthScope authscope5 = new AuthScope("somehost", 80, "someotherrealm", "somescheme");
        AuthScope authscope6 = new AuthScope("somehost", 80, "somerealm", "someotherscheme");
        Assert.assertTrue((boolean)authscope1.equals((Object)authscope1));
        Assert.assertFalse((boolean)authscope1.equals((Object)authscope2));
        Assert.assertTrue((boolean)authscope1.equals((Object)authscope3));
        Assert.assertFalse((boolean)authscope1.equals((Object)authscope4));
        Assert.assertFalse((boolean)authscope1.equals((Object)authscope5));
        Assert.assertFalse((boolean)authscope1.equals((Object)authscope6));
    }

    @Test
    public void testHash() {
        AuthScope authscope1 = new AuthScope("somehost", 80, "somerealm", "somescheme");
        AuthScope authscope2 = new AuthScope("someotherhost", 80, "somerealm", "somescheme");
        AuthScope authscope3 = new AuthScope("somehost", 80, "somerealm", "somescheme");
        AuthScope authscope4 = new AuthScope("somehost", 8080, "somerealm", "somescheme");
        AuthScope authscope5 = new AuthScope("somehost", 80, "someotherrealm", "somescheme");
        AuthScope authscope6 = new AuthScope("somehost", 80, "somerealm", "someotherscheme");
        Assert.assertTrue((authscope1.hashCode() == authscope1.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((authscope1.hashCode() == authscope2.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((authscope1.hashCode() == authscope3.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((authscope1.hashCode() == authscope4.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((authscope1.hashCode() == authscope5.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((authscope1.hashCode() == authscope6.hashCode() ? 1 : 0) != 0);
    }
}

