/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.conn.ssl;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.apache.http.HttpHost;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustAllStrategy;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.bootstrap.HttpServer;
import org.apache.http.impl.bootstrap.SSLServerSetupHandler;
import org.apache.http.impl.bootstrap.ServerBootstrap;
import org.apache.http.localserver.SSLTestContexts;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContexts;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TestSSLSocketFactory {
    private HttpServer server;

    @After
    public void shutDown() throws Exception {
        if (this.server != null) {
            this.server.shutdown(10L, TimeUnit.SECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBasicSSL() throws Exception {
        this.server = ServerBootstrap.bootstrap().setServerInfo("TEST/1.1").setSslContext(SSLTestContexts.createServerSSLContext()).create();
        this.server.start();
        BasicHttpContext context = new BasicHttpContext();
        TestX509HostnameVerifier hostVerifier = new TestX509HostnameVerifier();
        SSLConnectionSocketFactory socketFactory = new SSLConnectionSocketFactory(SSLTestContexts.createClientSSLContext(), (HostnameVerifier)hostVerifier);
        Socket socket = socketFactory.createSocket((HttpContext)context);
        InetSocketAddress remoteAddress = new InetSocketAddress("localhost", this.server.getLocalPort());
        HttpHost target = new HttpHost("localhost", this.server.getLocalPort(), "https");
        SSLSocket sslSocket = (SSLSocket)socketFactory.connectSocket(0, socket, target, remoteAddress, null, (HttpContext)context);
        try {
            SSLSession sslsession = sslSocket.getSession();
            Assert.assertNotNull((Object)sslsession);
            Assert.assertTrue((boolean)hostVerifier.isFired());
        }
        finally {
            sslSocket.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBasicDefaultHostnameVerifier() throws Exception {
        this.server = ServerBootstrap.bootstrap().setServerInfo("TEST/1.1").setSslContext(SSLTestContexts.createServerSSLContext()).create();
        this.server.start();
        BasicHttpContext context = new BasicHttpContext();
        SSLConnectionSocketFactory socketFactory = new SSLConnectionSocketFactory(SSLTestContexts.createClientSSLContext(), SSLConnectionSocketFactory.getDefaultHostnameVerifier());
        Socket socket = socketFactory.createSocket((HttpContext)context);
        InetSocketAddress remoteAddress = new InetSocketAddress("localhost", this.server.getLocalPort());
        HttpHost target = new HttpHost("localhost", this.server.getLocalPort(), "https");
        SSLSocket sslSocket = (SSLSocket)socketFactory.connectSocket(0, socket, target, remoteAddress, null, (HttpContext)context);
        try {
            SSLSession sslsession = sslSocket.getSession();
            Assert.assertNotNull((Object)sslsession);
        }
        finally {
            sslSocket.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClientAuthSSL() throws Exception {
        this.server = ServerBootstrap.bootstrap().setServerInfo("TEST/1.1").setSslContext(SSLTestContexts.createServerSSLContext()).create();
        this.server.start();
        BasicHttpContext context = new BasicHttpContext();
        TestX509HostnameVerifier hostVerifier = new TestX509HostnameVerifier();
        SSLConnectionSocketFactory socketFactory = new SSLConnectionSocketFactory(SSLTestContexts.createClientSSLContext(), (HostnameVerifier)hostVerifier);
        Socket socket = socketFactory.createSocket((HttpContext)context);
        InetSocketAddress remoteAddress = new InetSocketAddress("localhost", this.server.getLocalPort());
        HttpHost target = new HttpHost("localhost", this.server.getLocalPort(), "https");
        SSLSocket sslSocket = (SSLSocket)socketFactory.connectSocket(0, socket, target, remoteAddress, null, (HttpContext)context);
        try {
            SSLSession sslsession = sslSocket.getSession();
            Assert.assertNotNull((Object)sslsession);
            Assert.assertTrue((boolean)hostVerifier.isFired());
        }
        finally {
            sslSocket.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IOException.class)
    public void testClientAuthSSLFailure() throws Exception {
        this.server = ServerBootstrap.bootstrap().setServerInfo("TEST/1.1").setSslContext(SSLTestContexts.createServerSSLContext()).setSslSetupHandler(new SSLServerSetupHandler(){

            public void initialize(SSLServerSocket socket) throws SSLException {
                socket.setNeedClientAuth(true);
            }
        }).create();
        this.server.start();
        BasicHttpContext context = new BasicHttpContext();
        TestX509HostnameVerifier hostVerifier = new TestX509HostnameVerifier();
        SSLConnectionSocketFactory socketFactory = new SSLConnectionSocketFactory(SSLTestContexts.createClientSSLContext(), (HostnameVerifier)hostVerifier);
        Socket socket = socketFactory.createSocket((HttpContext)context);
        InetSocketAddress remoteAddress = new InetSocketAddress("localhost", this.server.getLocalPort());
        HttpHost target = new HttpHost("localhost", this.server.getLocalPort(), "https");
        SSLSocket sslSocket = (SSLSocket)socketFactory.connectSocket(0, socket, target, remoteAddress, null, (HttpContext)context);
        try {
            SSLSession sslsession = sslSocket.getSession();
            Assert.assertNotNull((Object)sslsession);
            Assert.assertTrue((boolean)hostVerifier.isFired());
        }
        finally {
            sslSocket.close();
        }
    }

    @Test(expected=SSLException.class)
    public void testSSLTrustVerification() throws Exception {
        this.server = ServerBootstrap.bootstrap().setServerInfo("TEST/1.1").setSslContext(SSLTestContexts.createServerSSLContext()).create();
        this.server.start();
        BasicHttpContext context = new BasicHttpContext();
        SSLContext defaultsslcontext = SSLContexts.createDefault();
        SSLConnectionSocketFactory socketFactory = new SSLConnectionSocketFactory(defaultsslcontext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        Socket socket = socketFactory.createSocket((HttpContext)context);
        InetSocketAddress remoteAddress = new InetSocketAddress("localhost", this.server.getLocalPort());
        HttpHost target = new HttpHost("localhost", this.server.getLocalPort(), "https");
        SSLSocket sslSocket = (SSLSocket)socketFactory.connectSocket(0, socket, target, remoteAddress, null, (HttpContext)context);
        sslSocket.close();
    }

    @Test
    public void testSSLTrustVerificationOverrideWithCustsom() throws Exception {
        TrustStrategy trustStrategy = new TrustStrategy(){

            public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                return chain.length == 1;
            }
        };
        this.testSSLTrustVerificationOverride(trustStrategy);
    }

    @Test
    public void testSSLTrustVerificationOverrideWithTrustSelfSignedStrategy() throws Exception {
        this.testSSLTrustVerificationOverride((TrustStrategy)TrustSelfSignedStrategy.INSTANCE);
    }

    @Test
    public void testSSLTrustVerificationOverrideWithTrustAllStrategy() throws Exception {
        this.testSSLTrustVerificationOverride((TrustStrategy)TrustAllStrategy.INSTANCE);
    }

    private void testSSLTrustVerificationOverride(TrustStrategy trustStrategy) throws Exception, IOException, NoSuchAlgorithmException, KeyManagementException, KeyStoreException {
        this.server = ServerBootstrap.bootstrap().setServerInfo("TEST/1.1").setSslContext(SSLTestContexts.createServerSSLContext()).create();
        this.server.start();
        BasicHttpContext context = new BasicHttpContext();
        SSLContext sslcontext = SSLContexts.custom().loadTrustMaterial(null, (org.apache.http.ssl.TrustStrategy)trustStrategy).build();
        SSLConnectionSocketFactory socketFactory = new SSLConnectionSocketFactory(sslcontext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        Socket socket = socketFactory.createSocket((HttpContext)context);
        InetSocketAddress remoteAddress = new InetSocketAddress("localhost", this.server.getLocalPort());
        HttpHost target = new HttpHost("localhost", this.server.getLocalPort(), "https");
        SSLSocket sslSocket = (SSLSocket)socketFactory.connectSocket(0, socket, target, remoteAddress, null, (HttpContext)context);
        sslSocket.close();
    }

    @Test
    public void testTLSOnly() throws Exception {
        this.server = ServerBootstrap.bootstrap().setServerInfo("TEST/1.1").setSslContext(SSLTestContexts.createServerSSLContext()).setSslSetupHandler(new SSLServerSetupHandler(){

            public void initialize(SSLServerSocket socket) throws SSLException {
                socket.setEnabledProtocols(new String[]{"TLSv1"});
            }
        }).create();
        this.server.start();
        BasicHttpContext context = new BasicHttpContext();
        SSLConnectionSocketFactory socketFactory = new SSLConnectionSocketFactory(SSLTestContexts.createClientSSLContext());
        Socket socket = socketFactory.createSocket((HttpContext)context);
        InetSocketAddress remoteAddress = new InetSocketAddress("localhost", this.server.getLocalPort());
        HttpHost target = new HttpHost("localhost", this.server.getLocalPort(), "https");
        SSLSocket sslSocket = (SSLSocket)socketFactory.connectSocket(0, socket, target, remoteAddress, null, (HttpContext)context);
        SSLSession sslsession = sslSocket.getSession();
        Assert.assertNotNull((Object)sslsession);
    }

    @Test(expected=IOException.class)
    public void testSSLDisabledByDefault() throws Exception {
        this.server = ServerBootstrap.bootstrap().setServerInfo("TEST/1.1").setSslContext(SSLTestContexts.createServerSSLContext()).setSslSetupHandler(new SSLServerSetupHandler(){

            public void initialize(SSLServerSocket socket) throws SSLException {
                socket.setEnabledProtocols(new String[]{"SSLv3"});
            }
        }).create();
        this.server.start();
        BasicHttpContext context = new BasicHttpContext();
        SSLConnectionSocketFactory socketFactory = new SSLConnectionSocketFactory(SSLTestContexts.createClientSSLContext());
        Socket socket = socketFactory.createSocket((HttpContext)context);
        InetSocketAddress remoteAddress = new InetSocketAddress("localhost", this.server.getLocalPort());
        HttpHost target = new HttpHost("localhost", this.server.getLocalPort(), "https");
        socketFactory.connectSocket(0, socket, target, remoteAddress, null, (HttpContext)context);
    }

    static class TestX509HostnameVerifier
    implements HostnameVerifier {
        private boolean fired = false;

        TestX509HostnameVerifier() {
        }

        @Override
        public boolean verify(String host, SSLSession session) {
            this.fired = true;
            return true;
        }

        public boolean isFired() {
            return this.fired;
        }
    }
}

