/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client;

import java.io.IOException;
import java.net.UnknownHostException;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.protocol.HttpContext;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestDefaultHttpRequestRetryHandler {
    @Test
    public void noRetryOnConnectTimeout() throws Exception {
        HttpContext context = (HttpContext)Mockito.mock(HttpContext.class);
        HttpUriRequest request = (HttpUriRequest)Mockito.mock(HttpUriRequest.class);
        DefaultHttpRequestRetryHandler retryHandler = new DefaultHttpRequestRetryHandler();
        Assert.assertEquals((long)3L, (long)retryHandler.getRetryCount());
        Mockito.when((Object)request.isAborted()).thenReturn((Object)Boolean.FALSE);
        Mockito.when((Object)context.getAttribute("http.request")).thenReturn((Object)request);
        Assert.assertFalse((boolean)retryHandler.retryRequest((IOException)new ConnectTimeoutException(), 1, context));
    }

    @Test
    public void noRetryOnUnknownHost() throws Exception {
        HttpContext context = (HttpContext)Mockito.mock(HttpContext.class);
        HttpUriRequest request = (HttpUriRequest)Mockito.mock(HttpUriRequest.class);
        DefaultHttpRequestRetryHandler retryHandler = new DefaultHttpRequestRetryHandler();
        Mockito.when((Object)request.isAborted()).thenReturn((Object)Boolean.FALSE);
        Mockito.when((Object)context.getAttribute("http.request")).thenReturn((Object)request);
        Assert.assertFalse((boolean)retryHandler.retryRequest((IOException)new UnknownHostException(), 1, context));
    }

    @Test
    public void noRetryOnAbortedRequests() throws Exception {
        HttpContext context = (HttpContext)Mockito.mock(HttpContext.class);
        HttpUriRequest request = (HttpUriRequest)Mockito.mock(HttpUriRequest.class);
        DefaultHttpRequestRetryHandler retryHandler = new DefaultHttpRequestRetryHandler();
        Mockito.when((Object)request.isAborted()).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)context.getAttribute("http.request")).thenReturn((Object)request);
        Assert.assertFalse((boolean)retryHandler.retryRequest(new IOException(), 3, context));
    }

    @Test
    public void retryOnNonAbortedRequests() throws Exception {
        HttpContext context = (HttpContext)Mockito.mock(HttpContext.class);
        HttpUriRequest request = (HttpUriRequest)Mockito.mock(HttpUriRequest.class);
        DefaultHttpRequestRetryHandler retryHandler = new DefaultHttpRequestRetryHandler();
        Mockito.when((Object)request.isAborted()).thenReturn((Object)Boolean.FALSE);
        Mockito.when((Object)context.getAttribute("http.request")).thenReturn((Object)request);
        Assert.assertTrue((boolean)retryHandler.retryRequest(new IOException(), 3, context));
    }

    @Test
    public void noRetryOnConnectionTimeout() throws Exception {
        HttpContext context = (HttpContext)Mockito.mock(HttpContext.class);
        HttpUriRequest request = (HttpUriRequest)Mockito.mock(HttpUriRequest.class);
        DefaultHttpRequestRetryHandler retryHandler = new DefaultHttpRequestRetryHandler();
        Mockito.when((Object)request.isAborted()).thenReturn((Object)false);
        Mockito.when((Object)context.getAttribute("http.request")).thenReturn((Object)request);
        Assert.assertFalse((boolean)retryHandler.retryRequest((IOException)new ConnectTimeoutException(), 3, context));
    }
}

