/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.config;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import java.util.Properties;
import javax.annotation.concurrent.Immutable;
import org.apache.hudi.common.config.ConfigClassProperty;
import org.apache.hudi.common.config.ConfigGroups;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.config.DynamoDbBasedLockConfig;

@ConfigClassProperty(name="Amazon Web Services Configs", groupName=ConfigGroups.Names.AWS, description="Amazon Web Services configurations to access resources like Amazon DynamoDB (for locks), Amazon CloudWatch (metrics).")
@Immutable
public class HoodieAWSConfig
extends HoodieConfig {
    public static final ConfigProperty<String> AWS_ACCESS_KEY = ConfigProperty.key((String)"hoodie.aws.access.key").noDefaultValue().sinceVersion("0.10.0").withDocumentation("AWS access key id");
    public static final ConfigProperty<String> AWS_SECRET_KEY = ConfigProperty.key((String)"hoodie.aws.secret.key").noDefaultValue().sinceVersion("0.10.0").withDocumentation("AWS secret key");
    public static final ConfigProperty<String> AWS_SESSION_TOKEN = ConfigProperty.key((String)"hoodie.aws.session.token").noDefaultValue().sinceVersion("0.10.0").withDocumentation("AWS session token");

    private HoodieAWSConfig() {
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getAWSAccessKey() {
        return this.getString(AWS_ACCESS_KEY);
    }

    public String getAWSSecretKey() {
        return this.getString(AWS_SECRET_KEY);
    }

    public String getAWSSessionToken() {
        return this.getString(AWS_SESSION_TOKEN);
    }

    public static class Builder {
        private final HoodieAWSConfig awsConfig = new HoodieAWSConfig();

        public Builder fromFile(File propertiesFile) throws IOException {
            try (FileReader reader = new FileReader(propertiesFile);){
                this.awsConfig.getProps().load((Reader)reader);
                Builder builder = this;
                return builder;
            }
        }

        public Builder fromProperties(Properties props) {
            this.awsConfig.getProps().putAll((Map)props);
            return this;
        }

        public Builder withAccessKey(String accessKey) {
            this.awsConfig.setValue(AWS_ACCESS_KEY, accessKey);
            return this;
        }

        public Builder withSecretKey(String secretKey) {
            this.awsConfig.setValue(AWS_SECRET_KEY, secretKey);
            return this;
        }

        public Builder withSessionToken(String sessionToken) {
            this.awsConfig.setValue(AWS_SESSION_TOKEN, sessionToken);
            return this;
        }

        public Builder withDynamoDBTable(String dynamoDbTableName) {
            this.awsConfig.setValue(DynamoDbBasedLockConfig.DYNAMODB_LOCK_TABLE_NAME, dynamoDbTableName);
            return this;
        }

        public Builder withDynamoDBPartitionKey(String partitionKey) {
            this.awsConfig.setValue(DynamoDbBasedLockConfig.DYNAMODB_LOCK_PARTITION_KEY, partitionKey);
            return this;
        }

        public Builder withDynamoDBRegion(String region) {
            this.awsConfig.setValue(DynamoDbBasedLockConfig.DYNAMODB_LOCK_REGION, region);
            return this;
        }

        public Builder withDynamoDBBillingMode(String mode) {
            this.awsConfig.setValue(DynamoDbBasedLockConfig.DYNAMODB_LOCK_BILLING_MODE, mode);
            return this;
        }

        public Builder withDynamoDBReadCapacity(String capacity) {
            this.awsConfig.setValue(DynamoDbBasedLockConfig.DYNAMODB_LOCK_READ_CAPACITY, capacity);
            return this;
        }

        public Builder withDynamoDBWriteCapacity(String capacity) {
            this.awsConfig.setValue(DynamoDbBasedLockConfig.DYNAMODB_LOCK_WRITE_CAPACITY, capacity);
            return this;
        }

        public HoodieAWSConfig build() {
            this.awsConfig.setDefaults(HoodieAWSConfig.class.getName());
            return this.awsConfig;
        }
    }
}

